#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sc_bsp.h>
#include <errno.h>
#include "lynq-gpio.h"
#include "liblog/lynq_deflog.h"

#ifdef __cplusplus
extern "C" {
#endif

#define USER_LOG_TAG "LYNQ_GPIO"

/*****************************************
* @brief:lynq_gpio_init
* @param count [IN]:4
* @param sum [OUT]:NA
* @return :success 0, failed -1
* @todo:NA
* @see:NA
* @warning:NA
******************************************/

int lynq_gpio_init(int gpio, int direction, int value, int pullsel)
{
    LYLOGSET(LOG_INFO);
    LYLOGEINIT(USER_LOG_TAG);

    test_gpio_handle[gpio] = sc_gpio_init(gpio, direction, value, pullsel);
    if (!test_gpio_handle[gpio])
    {
        LYINFLOG("do_gpio_init failed, err:%d", errno);
        return -1;
    }
    return 0;
}

/*****************************************
* @brief:lynq_gpio_deinit
* @param count [IN]:1
* @param sum [OUT]:NA
* @return :success 0, failed -1
* @todo:NA
* @see:NA
* @warning:NA
******************************************/


int lynq_gpio_deinit(int gpio)
{
    int ret;
    LYLOGSET(LOG_INFO);
    LYLOGEINIT(USER_LOG_TAG);

    ret = sc_gpio_uninit(test_gpio_handle[gpio]);
    if (ret)
    {
        LYINFLOG("do_gpio_uninit failed, err:%d", ret);
        return -1;
    }
    return 0;
}

/*****************************************
* @brief:lynq_gpio_direction_set
* @param count [IN]:2
* @param sum [OUT]:NA
* @return :success 0, failed -1
* @todo:NA
* @see:NA
* @warning:NA
******************************************/

int lynq_gpio_direction_set(int gpio, int direction)
{
    int ret;
    LYLOGSET(LOG_INFO);
    LYLOGEINIT(USER_LOG_TAG);
    if(direction != 0 && direction != 1)
    {
        LYINFLOG("input direction is error\n");
        return -1;
    }
    ret = sc_gpio_direction_set(test_gpio_handle[gpio], direction, 0);
    if (ret)
    {
        LYINFLOG("do_gpio_input set direction failed, err:%d\n", ret);
        return -1;;
    }
    return 0;
}

/*****************************************
* @brief:lynq_gpio_value_set
* @param count [IN]:2
* @param sum [OUT]:NA
* @return :success 0, failed -1
* @todo:NA
* @see:NA
* @warning:NA
******************************************/

int lynq_gpio_value_set(int gpio, int value)
{
    int ret;
    LYLOGSET(LOG_INFO);
    LYLOGEINIT(USER_LOG_TAG);
    if(value != 0 && value != 1)
    {
        LYINFLOG("input value is error\n");
        return -1;
    }

    ret = sc_gpio_value_set(test_gpio_handle[gpio], value);
    if (ret)
    {
        LYINFLOG("do_gpio_output set value failed, err:%d\n", ret);
        return -1;
    }
    else
    {
        LYINFLOG("gpio%d set value:%d\n", gpio, value);
    }
    return 0;
}

/*****************************************
* @brief:lynq_gpio_value_set
* @param count [IN]:1
* @param sum [OUT]:NA
* @return :success 0, failed -1
* @todo:NA
* @see:NA
* @warning:NA
******************************************/


int lynq_gpio_value_get(int gpio)
{
    int ret;
    int value;
    LYLOGSET(LOG_INFO);
    LYLOGEINIT(USER_LOG_TAG);
    ret = sc_gpio_value_get(test_gpio_handle[gpio], &value);
    if (ret)
    {
        LYINFLOG("do_gpio_input get value failed, err:%d\n", ret);
        return -1;
    }
    else
    {
        LYINFLOG("gpio%d value:%d\n", gpio, value);
    }
    return value;
}

/*****************************************
* @brief:lynq_gpio_pullsel_set
* @param count [IN]:2
* @param sum [OUT]:NA
* @return :success 0, failed -1
* @todo:NA
* @see:NA
* @warning:NA
******************************************/


int lynq_gpio_pullsel_set(int gpio, int pullsel)
{
    int ret;
    LYLOGSET(LOG_INFO);
    LYLOGEINIT(USER_LOG_TAG);
    ret = sc_gpio_pullsel_set(test_gpio_handle[gpio], pullsel);
    if (ret)
    {
        LYINFLOG("do_gpio_input get pull failed, err:%d\n", ret);
        return -1;
    }
    else
    {
        LYINFLOG("gpio%d pull:%d\n", gpio, pullsel);
    }
    return 0;
}

/*****************************************
* @brief:lynq_gpio_pullsel_get
* @param count [IN]:1
* @param sum [OUT]:NA
* @return :success >=0, failed -1
* @todo:NA
* @see:NA
* @warning:NA
******************************************/


int lynq_gpio_pullsel_get(int gpio)
{
    int ret;
    int pullsel;
    LYLOGSET(LOG_INFO);
    LYLOGEINIT(USER_LOG_TAG);
    ret = sc_gpio_pullsel_get(test_gpio_handle[gpio], &pullsel);
    if (ret)
    {
        LYINFLOG("do_gpio_input get pull failed, err:%d\n", ret);
        return -1;
    }
    else
    {
        LYINFLOG("gpio%d pull:%d\n", gpio, pullsel);
    }
    return pullsel;
}


DEFINE_LYNQ_LIB_LOG(LYNQ_GPIO)

#ifdef __cplusplus
}
#endif



