#ifndef LYNQ_MONITOR_CFG_H
#define LYNQ_MONITOR_CFG_H

int lynq_config_load(const char* config_path);
const char* lynq_get_config_value(const char* key, char value_buffer[], size_t buffer_size);
const char* lynq_get_config_value_with_default(const char* key, char value_buffer[], 
                                               size_t buffer_size, const char* default_value);
int lynq_get_config_int_value(const char* key, int* value);
int lynq_get_config_int_value_with_default(const char* key, int default_value);

// 定义短名称，方便使用
#define lynq_cfg_get_s lynq_get_config_value_with_default
#define lynq_cfg_get_i lynq_get_config_int_value_with_default

#endif // LYNQ_MONITOR_CFG_H
