﻿#ifndef LYNQ_MONITOR_INTERNAL_H
#define LYNQ_MONITOR_INTERNAL_H


#define LYNQ_MONITOR_DEFAULT_CONFIG_PATH "/etc/config/lynq_monitor.cfg"

#define DEFAULT_NW_MONITOR_PERIOD 30
#define DEFAULT_PING_MONITOR_PERIOD 10
#define LIMIT_RESET_NAD_1 10
#define LIMIT_RESET_NW_1 4
#define LIMIT_RESET_DATA_1 2
#define LIMIT_RESET_NAD_2 18
#define LIMIT_RESET_NW_2 15
#define LIMIT_RESET_DATA_2 12
#define PING_ADDR_MAX_LEN 64
#define PING_ADDR1_DEFAULT "baidu.com"
#define PING_ADDR2_DEFAULT "qq.com"
#define PING_ADDR3_DEFAULT "114.114.114.114"

/**
 * @brief 异常类型定义
 */
#define LYNQ_EXCEPTION_TYPE_NW 0 /**< 网络异常 */
#define LYNQ_EXCEPTION_TYPE_DATA 1 /**< 数据异常 */
#define LYNQ_EXCEPTION_TYPE_DEV 2 /**< 设备运行异常 */
#define LYNQ_EXCEPTION_TYPE_PING 3 /**< ping网络异常 */

/**
 * @brief 操作码定义
 */
#define LYNQ_OPT_RESET_NW 0 /**< 重置网络 */
#define LYNQ_OPT_RESET_DATA 1 /**< 重置数据连接 */
#define LYNQ_OPT_RESET_SIM 2 /**< 重启SIM */
#define LYNQ_OPT_RESET_NAD 3 /**< 重启NAD */

/**
 * @brief 错误码定义
 */
#define LYNQ_ERR_NW_TIMEOUT 1 /**< 长时间网络注册不上 */
#define LYNQ_ERR_DATA_TIMEOUT 2 /**< 长时间数据连接失败 */
#define LYNQ_ERR_DEV_TIMEOUT 3 /**< 长时间设备状态异常 */
#define LYNQ_ERR_PING_TIMEOUT 4 /**< 长时间ping不通 */
#define LYNQ_ERR_DATA_DISCONNECT 5 /**< 长时间数据连接失败 */

typedef struct 
{
    int network_monitor_enabled;
    int device_monitor_enabled;
    int ping_monitor_enabled;
    int nw_monitor_period;
    int ping_monitor_period;
    int limit_reset_nad_1;
    int limit_reset_nw_1;
    int limit_reset_data_1;
    int limit_reset_nad_2;
    int limit_reset_nw_2;
    int limit_reset_data_2;
    int opt_reset_nad; // 0: do nothing, 1: notify app, 2, reset by lynq_monitor
    int opt_reset_nw; // 0: do nothing, 1: notify app, 2, reset by lynq_monitor
    int opt_reset_data; // 0: do nothing, 1: notify app, 2, reset by lynq_monitor
    char ping_addr1[PING_ADDR_MAX_LEN]; // URL
    char ping_addr2[PING_ADDR_MAX_LEN]; // URL
    char ping_addr3[PING_ADDR_MAX_LEN]; // IP
} Lynq_Monitor_Config;

extern int g_monitor_state;
extern Lynq_Monitor_Config g_monitor_config;

// 检查nad状态，返回1表示有重要任务，不做检查和重置操作
int lynq_monitor_check_state();

int lynq_monitor_need_reset_nad(int exception_type, int error_code);
int lynq_monitor_need_reset_flight_mode(int exception_type, int error_code);
int lynq_monitor_need_reset_sim(int exception_type, int error_code);
int lynq_monitor_need_reset_data(int exception_type, int error_code);
#endif // LYNQ_MONITOR_INTERNAL_H
