#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "dispatch.h"
#include "lynq.h"
dispatch_manager *g_dispatch;

int init_msg_dispatch(char * socket_name,int token)
{
    int ret;
    g_dispatch = new dispatch_manager;
    if(g_dispatch == NULL)
    {
        printf("[%s][%d] new class fail!\n",__FUNCTION__,__LINE__);
        return -1;
    }
    ret = g_dispatch->init_socket(socket_name);
    if(ret!=LYNQ_E_SUCCESS)
    {
        printf("[%s][%d] create socket fail!\n",__FUNCTION__,__LINE__);
        return ret;
    }
    g_dispatch->start_main_loop();
    return LYNQ_E_SUCCESS;
}
int main(int argc,char*argv[])
{
    printf("[%s][%d] enter\n",__FUNCTION__,__LINE__);
    int ret = 0;
    char socket_name[64]={0};

    system("rm -rf /var/run/socket");
    system("mkdir -p /var/run/socket");

    if(argc < 3)
    {
        printf("[%s][%d] please input socket name and token\n",__FUNCTION__,__LINE__);
        exit(1);
    }
    if((argv[1] != NULL) && (argv[2]!=NULL))
    {
        sprintf(socket_name,"/var/run/socket/%s",argv[1]);
        if(LYNQ_E_SUCCESS != init_msg_dispatch(socket_name, atoi(argv[2])))
        {
            exit(1);
        }
    }
    else
    {
	printf("[%s][%d] param fail!\n",__FUNCTION__,__LINE__);
        exit(1);
    }
    while (1)
    {
        sleep(1);
    }
    return 0;
}
