#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <libsim/lynq_sim.h>
#include <include/lynq_qser_sim.h>
#include "sim.h"
#define TEST_RESULT "lynq_result="

static int handle = 0;


int init_sim(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    int uToken = atoi(argv[1]);
    ret = lynq_sim_init(uToken);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}

int get_imsi_test(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    char imsi_buf[SIM_BUF] = "";
    ret = lynq_get_imsi(imsi_buf);
    printf("%s%d\n",TEST_RESULT,ret);
    printf("[%s-%d] IMSI:%s\n", __FUNCTION__, __LINE__, imsi_buf);
    return ret;
}

int get_sim_status_test(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    int sim_status = -1;
    //ret = lynq_get_sim_status(&sim_status);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}

int get_iccid_test(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    char iccid[SIM_BUF] = "";
    ret = lynq_get_iccid(iccid);
    printf("%s%d\n",TEST_RESULT,ret);
    if(!ret)
        printf("[%s-%d] ICCID:%s\n", __FUNCTION__, __LINE__, iccid);

    return ret;
}

int enable_pin_test(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    char pin[SIM_BUF] = "";
    ret = lynq_enable_pin(pin);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}



int sim_power_test(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    int mode = 0;
#ifdef MOBILETEK_TARGET_PLATFORM_T106
    ret = lynq_reset_sim();
#else
    ret = lynq_sim_power(mode);
#endif
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}

int disable_pin_test(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    char pin[SIM_BUF] = "";
    ret = lynq_disable_pin(pin);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}

int query_pin_lock_test(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    char pin[SIM_BUF] = "";
    int lock[SIM_BUF] = {0};
    ret = lynq_query_pin_lock(pin,lock);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}

int verify_pin_test(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    char pin[SIM_BUF] = "";
    ret = lynq_verify_pin(pin);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}

int change_pin_test(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    char old_pin[SIM_BUF] = "";
    char new_pin[SIM_BUF] = "";
    ret = lynq_change_pin(old_pin, new_pin);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}

int unlock_pin_test(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    char puk[SIM_BUF] = "";
    char new_pin[SIM_BUF] = "";
    ret = lynq_unlock_pin(puk, new_pin);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}
//#error rita

int get_imei_test(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    char buf[SIM_BUF] = "";
    ret = lynq_get_imei(buf);
    printf("%s%d\n",TEST_RESULT,ret);
    printf("[%s-%d] IMEI:%s\n", __FUNCTION__, __LINE__, buf);
    return ret;
}

int get_imei_and_sv_test(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    char imei[SIM_BUF] = "";
    char sv[SIM_BUF] = "";
    ret = lynq_get_imei_and_sv(imei, sv);
    printf("%s%d\n",TEST_RESULT,ret);
    printf("[%s-%d] IMEI:%s, SV:%s\n", __FUNCTION__, __LINE__, imei, sv);
    return ret;
}

int switch_card_test(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    char solt = 0;
    ret = lynq_switch_card(solt);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}

int query_phone_number_test(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    char buf[SIM_BUF] = "";
    ret = lynq_query_phone_number(buf);
    printf("%s%d\n",TEST_RESULT,ret);
    printf("[%s-%d] PHONE_NUM:%s\n", __FUNCTION__, __LINE__, buf);
    return ret;
}

int deinit_sim(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    ret = lynq_sim_deinit();
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}
int get_version(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    char buf[128] = "";
    int ret = -1;
    ret = lynq_get_version(buf);
    printf("%s%d\n",TEST_RESULT,ret);
    printf("[%s-%d] VERSION:%s\n", __FUNCTION__, __LINE__, buf);
    return ret;
}

int reset_modem(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    char buf[128] = "";
    int ret = -1;
    ret = lynq_reset_modem();
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}

int get_msisdn(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    char buf[128] = "";
    int ret = -1;
    ret = lynq_query_phone_number(buf);
    printf("[%s][%d] buf = %s\n",__FUNCTION__,__LINE__, buf);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}

//qser api
sim_client_handle_type  ph_sim;
int qser_init_sim(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    ph_sim = (sim_client_handle_type)atoi(argv[1]);
    ret = qser_sim_client_init(&ph_sim);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}

int qser_get_imsi_test(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    char imsi_buf[SIM_BUF] = "";
    //sim_client_handle_type h_sim = ph_sim;
    QSER_SIM_APP_ID_INFO_T pt_info; 
    size_t imsiLen = 0;
    ret = qser_sim_getimsi(ph_sim, &pt_info, imsi_buf, imsiLen);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}

int qser_get_iccid_test(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    char iccid[SIM_BUF] = "";
    int uToken = atoi(argv[1]);
    //sim_client_handle_type h_sim = gtoken;
    QSER_SIM_SLOT_ID_TYPE_T simId;
    int iccidLen = 0;
    ret = qser_sim_geticcid(ph_sim, simId, iccid, iccidLen);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}

int qser_get_phonenumber_test(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    char phone_num[SIM_BUF] = "";
    //sim_client_handle_type h_sim = gtoken;
    QSER_SIM_APP_ID_INFO_T pt_info; 
    int phoneLen = 0;
    ret = qser_sim_getphonenumber(ph_sim, &pt_info, phone_num, phoneLen);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}

int qser_verify_pin_test(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    //sim_client_handle_type h_sim = gtoken;
    QSER_SIM_VERIFY_PIN_INFO_T pt_info;
    strcpy(pt_info.pin_value, argv[1]);
    ret =  qser_sim_verifypin(ph_sim, &pt_info);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}

int qser_change_pin_test(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    //sim_client_handle_type h_sim = gtoken;
    QSER_SIM_CHANGE_PIN_INFO_T pt_info;

    strcpy(pt_info.old_pin_value, argv[1]);
    strcpy(pt_info.new_pin_value, argv[2]);
    ret =  qser_sim_changepin(ph_sim, &pt_info);
    
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}

int qser_unlock_pin_test(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    //sim_client_handle_type h_sim = gtoken;
    QSER_SIM_UNBLOCK_PIN_INFO_T pt_info;

    strcpy(pt_info.puk_value, argv[1]);
    strcpy(pt_info.new_pin_value, argv[2]);
    ret =  qser_sim_unblockpin(ph_sim, &pt_info);
    
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}

int qser_enable_pin_test(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    //sim_client_handle_type h_sim = gtoken;
    QSER_SIM_ENABLE_PIN_INFO_T pt_info;

    strcpy(pt_info.pin_value, argv[1]);
    ret =  qser_sim_enablepin(ph_sim, &pt_info);
    
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}

int qser_disable_pin_test(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    //sim_client_handle_type h_sim = gtoken;
    QSER_SIM_DISABLE_PIN_INFO_T pt_info;

    strcpy(pt_info.pin_value, argv[1]);
    ret =  qser_sim_disablepin(ph_sim, &pt_info);
    
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}

int qser_get_sim_status_test(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    //sim_client_handle_type h_sim = gtoken;
    QSER_SIM_SLOT_ID_TYPE_T simId;
    QSER_SIM_CARD_STATUS_INFO_T pt_info;

    ret =  qser_sim_getcardstatus(ph_sim, simId, &pt_info);
    
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}

int qser_deinit_sim(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    ret = qser_sim_client_deinit(ph_sim);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}
