/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    hal_audioapi.c
 * File Mark:    
 * Description:  This file contains the hardware interface for audio driver.
 * Others:        
 * Version:       V1.0
 * Author:        LvWenhua
 * Date:          2008-4-24
 * History 1:      
 *     Date: 20080710
 *     Version:
 *     Author: dangmaochang
 *     Modification:  
 * History 2: 
  ********************************************************************************/

/****************************************************************************
*                                                Include files
****************************************************************************/
#include "drvs_general.h"
#include "Audio_api.h"
#include "hal_Audio.h"

/****************************************************************************
*                                                Local Macros
****************************************************************************/

/****************************************************************************
*                                                Local Types
****************************************************************************/

/****************************************************************************
*                                                Local Constants
****************************************************************************/

/****************************************************************************
*                                                Local Function Prototypes
****************************************************************************/

/****************************************************************************
*                                               Global Constants
****************************************************************************/

/****************************************************************************
*                                               Global Variables
****************************************************************************/
T_HalAudio_Opt*  gHalAudio_ObjPtr = NULL;

/****************************************************************************
*                                               Global Function Prototypes
****************************************************************************/

/****************************************************************************
*                                               Function Definitions
****************************************************************************/
/*******************************************************************************
 * Function: halAudio_Open
 * Description: This function is used to init codec
 * Parameters: 
 *   Input:None
 *   Output:None
 *
 * Returns: 
 *           T_ZDrv_ErrCode
 *           others: if errcode<-100 ,please refer to the hal layer errcode file
 * Others: 
 ********************************************************************************/
SINT32 halAudio_Open(VOID)
{
    if ((NULL != gHalAudio_ObjPtr) && (NULL != gHalAudio_ObjPtr->hal_audio_Open))
    {
        return gHalAudio_ObjPtr->hal_audio_Open();
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
 * Function: halAudio_Close
 * Description: This function is used to exit codec
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns:
 *             T_ZDrv_ErrCode
 *             others: if errcode<-100 ,please refer to the hal layer errcode file
 * Others:
 ********************************************************************************/
SINT32 halAudio_Close(VOID)
{
    if ((NULL != gHalAudio_ObjPtr) && (NULL != gHalAudio_ObjPtr->hal_audio_Close))
    {
        return gHalAudio_ObjPtr->hal_audio_Close();
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
 * Function: halAudio_PlayStart
 * Description: This function is used to play music file.
 * Parameters:
 *   Input:
 *    datainfo:reserve
 *   Output:None
 *
 * Returns:
 *           T_ZDrv_ErrCode
 *           others: if errcode<-100 ,please refer to the hal layer errcode file
 * Others:
 ********************************************************************************/
SINT32 halAudio_PlayStart(T_ZDrvAudio_PlayParam *datainfo)
{
    if ((NULL != gHalAudio_ObjPtr) && (NULL != gHalAudio_ObjPtr->hal_Audio_PlayStart))
    {
        return gHalAudio_ObjPtr->hal_Audio_PlayStart(datainfo);
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
 * Function: halAudio_PlayStop
 * Description: This function is used to stop playing music file.
 * Parameters:
 *   Input:None
 *   Output:None
 *
 * Returns:
 *           T_ZDrv_ErrCode
 *           others: if errcode<-100 ,please refer to the hal layer errcode file
 * Others:
 ********************************************************************************/
SINT32 halAudio_PlayStop(VOID)
{
    if ((NULL != gHalAudio_ObjPtr) && (NULL != gHalAudio_ObjPtr->hal_Audio_PlayStop))
    {
        return gHalAudio_ObjPtr->hal_Audio_PlayStop();
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
 * Function: halAudio_PlayPause
 * Description: This function is used to pause to play music file.
 * Parameters: 
 *   Input:None
 *   Output:None
 *
 * Returns:
 *           T_ZDrv_ErrCode
 *           others: if errcode<-100 ,please refer to the hal layer errcode file
 * Others: 
 ********************************************************************************/
SINT32 halAudio_PlayPause(VOID)
{
    if ((NULL != gHalAudio_ObjPtr) && (NULL != gHalAudio_ObjPtr->hal_Audio_PlayPause))
    {
        return gHalAudio_ObjPtr->hal_Audio_PlayPause();
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
 * Function: halAudio_PlayResume
 * Description: This function is used to resume playing music file.
 * Parameters: 
 *   Input:None
 *   Output:None
 *
 * Returns:
 *           T_ZDrv_ErrCode
 *           others: if errcode<-100 ,please refer to the hal layer errcode file
 * Others: 
 ********************************************************************************/
SINT32 halAudio_PlayResume(VOID)
{
    if ((NULL != gHalAudio_ObjPtr) && (NULL != gHalAudio_ObjPtr->hal_Audio_PlayResume))
    {
        return gHalAudio_ObjPtr->hal_Audio_PlayResume();
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halAudio_SetSample
* Description: This function is used to set samplerate.
* Parameters:
*   Input:
*           pSampleRate: the samplerate
*   Output:None
* Returns:
*           T_ZDrv_ErrCode
*           others: if errcode<-100 ,please refer to the hal layer errcode file
* Others:
********************************************************************************/
SINT32 halAudio_SetSample(T_ZDrvAudio_SampleRate* pSampleRate)
{
    if ((NULL != gHalAudio_ObjPtr) && (NULL != gHalAudio_ObjPtr->hal_Audio_SetSample))
    {
        return gHalAudio_ObjPtr->hal_Audio_SetSample(pSampleRate);
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halAudio_SetRcdSample
* Description: This function is used to set record samplerate.
* Parameters:
*   Input:
*           pSampleRate: the samplerate
*   Output:None
* Returns:
*           T_ZDrv_ErrCode
*           others: if errcode<-100 ,please refer to the hal layer errcode file
* Others:
********************************************************************************/
SINT32 halAudio_SetRcdSample(T_ZDrvAudio_SampleRate* pSampleRate)
{
    if ((NULL != gHalAudio_ObjPtr) && (NULL != gHalAudio_ObjPtr->hal_Audio_SetRcdSample))
    {
        return gHalAudio_ObjPtr->hal_Audio_SetRcdSample(pSampleRate);
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halAudio_SetBanlance
* Description: This function is used to set the audio balance
* Parameters:
*   Input:
*           pBanlance: the balance set info
*   Output:None
* Returns:
*           T_ZDrv_ErrCode
*           others: if errcode<-100 ,please refer to the hal layer errcode file
* Others:
********************************************************************************/
SINT32 halAudio_SetBanlance(T_ZDrvAudio_Banlance* pBanlance)
{
    if ((NULL != gHalAudio_ObjPtr) && (NULL != gHalAudio_ObjPtr->hal_Audio_SetBanlance))
    {
        return gHalAudio_ObjPtr->hal_Audio_SetBanlance(pBanlance);
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halAudio_SetEqMode
* Description: This function is used to set the mode of eq.
* Parameters: 
*   Input:
*           pEQMODE: the mode of eq
*   Output:None
* Returns:
*           T_ZDrv_ErrCode
*           others: if errcode<-100 ,please refer to the hal layer errcode file
*
* Others: 
********************************************************************************/
SINT32 halAudio_SetEqMode(T_ZDrvAUDIO_EQMODE* pEQMODE)
{
    if ((NULL != gHalAudio_ObjPtr) && (NULL != gHalAudio_ObjPtr->hal_Audio_SetEQMODE))
    {
        return gHalAudio_ObjPtr->hal_Audio_SetEQMODE(pEQMODE);
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halAudio_Set3DEffect
* Description: This function is used to set the effect of 3d.
* Parameters: 
*   Input:
*           p3DEFFECT: the effect of 3d
*   Output:None
* Returns:
*           T_ZDrv_ErrCode
*           others: if errcode<-100 ,please refer to the hal layer errcode file
*
* Others: 
********************************************************************************/
SINT32 halAudio_Set3DEffect(T_ZDrvAudio_3DEFFECT* p3DEFFECT)
{
    if ((NULL != gHalAudio_ObjPtr) && (NULL != gHalAudio_ObjPtr->hal_Audio_Set3DEFFECT))
    {
        return gHalAudio_ObjPtr->hal_Audio_Set3DEFFECT(p3DEFFECT);
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halAudio_SetOutputPath
* Description: This function is used to set the output path of audio.
* Parameters: 
*   Input:
*           pOutputPath: the output path of audio
*   Output:None
* Returns:
*           T_ZDrv_ErrCode
*           others: if errcode<-100 ,please refer to the hal layer errcode file
*
* Others: 
********************************************************************************/
SINT32 halAudio_SetOutputPath(T_ZDrv_AudioOutputPath* pOutputPath)
{
    if ((NULL != gHalAudio_ObjPtr) && (NULL != gHalAudio_ObjPtr->hal_Audio_SetOutputPath))
    {
        return gHalAudio_ObjPtr->hal_Audio_SetOutputPath(pOutputPath);
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halAudio_SetOutputVol
* Description: This function is used to set the volum of audio.
* Parameters: 
*   Input:
*           pOutputVol: the volum of audio
*   Output:None
* Returns:
*           T_ZDrv_ErrCode
*           others: if errcode<-100 ,please refer to the hal layer errcode file
*
* Others: 
********************************************************************************/
SINT32 halAudio_SetOutputVol(T_ZDrvAudio_OutputVolLevel* pOutputVol)
{
    if ((NULL != gHalAudio_ObjPtr) && (NULL != gHalAudio_ObjPtr->hal_Audio_SetOutputVol))
    {
        return gHalAudio_ObjPtr->hal_Audio_SetOutputVol(pOutputVol);
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halAudio_SetMute
* Description: This function is used to set audio mute or not.
* Parameters: 
*   Input:
*           enable: TRUE, set mute; FALSE, set normal.
*   Output:None
*
* Returns:
*           T_ZDrv_ErrCode
*           others: if errcode<-100 ,please refer to the hal layer errcode file
*
* Others: 
********************************************************************************/
SINT32 halAudio_SetMute(BOOL *BlMute)
{
    if ((NULL != gHalAudio_ObjPtr) && (NULL != gHalAudio_ObjPtr->hal_Audio_SetMute))
    {
        return gHalAudio_ObjPtr->hal_Audio_SetMute(BlMute);
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
 * Function: halAudio_GetPlayInfo
 * Description: This function is used to get play infomation, including total 
 * play time and current time position.
 * Parameters: 
 *   Input:
 *      none
 *   Output:
 *      play_info:T_ZDrvAudio_PlayInfo type, including total play time and 
 *      current time position(Millisecond).
 *
 * Returns:
 *           T_ZDrv_ErrCode
 *           others: if errcode<-100 ,please refer to the hal layer errcode file
 *
 *
 * Others: 
 ********************************************************************************/
SINT32 halAudio_GetPlayInfo(T_ZDrvAudio_PlayInfo* play_info)
{
    if ((NULL != gHalAudio_ObjPtr) && (NULL != gHalAudio_ObjPtr->hal_Audio_GetPlayInfo))
    {
        return gHalAudio_ObjPtr->hal_Audio_GetPlayInfo(play_info);
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halAudio_SetCallBackFunc
* Description: This function is used to set the callback function of audio.
* Parameters: 
*   Input:
*           pCallBcak: the callback function of audio
*   Output:None
* Returns:
*           T_ZDrv_ErrCode
*           others: if errcode<-100 ,please refer to the hal layer errcode file
*
* Others: 
********************************************************************************/
SINT32 halAudio_SetCallBackFunc(T_ZDrvAudio_CallbackFunc pCallBcak)
{
    if ((NULL != gHalAudio_ObjPtr) && (NULL != gHalAudio_ObjPtr->hal_Audio_SetCallBackFunc))
    {
        return gHalAudio_ObjPtr->hal_Audio_SetCallBackFunc(pCallBcak);
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halAudio_Write
* Description: This function is used to write steam data into device
* Parameters:
*   Input:
*      pointer to the written stream data;
*       count:the size of written stream data;
*   Output:None
*    Returns:
*       data length:  write successed.
*           T_ZDrv_ErrCode
*           others: if errcode<-100 ,please refer to the hal layer errcode file
* Others:
*      
 ********************************************************************************/
SINT32 halAudio_Write(UINT32 *dl_stream_data, UINT32 count)
{
    if ((NULL != gHalAudio_ObjPtr) && (NULL != gHalAudio_ObjPtr->halAudio_Write))
    {
        return gHalAudio_ObjPtr->halAudio_Write(dl_stream_data, count);
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halAudio_GetBuf
* Description: This function is used to get the infomation of audio buffer.
* Parameters: 
*   Input:
*           pBufInfo: the infomation of audio buffer
*   Output:None
* Returns:
*           T_ZDrv_ErrCode
*           others: if errcode<-100 ,please refer to the hal layer errcode file
*
* Others: 
********************************************************************************/
SINT32 halAudio_GetBuf(T_ZDrvAudio_BufInfo *pBufInfo)
{
    if ((NULL != gHalAudio_ObjPtr) && (NULL != gHalAudio_ObjPtr->halAudio_GetBuf))
    {
        return gHalAudio_ObjPtr->halAudio_GetBuf(pBufInfo);
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halAudio_RcdStart
* Description: This function is used to start record.
* Parameters: 
*   Input:
*           rcdParam: record param
*   Output:None
* Returns:
*           T_ZDrv_ErrCode
*           others: if errcode<-100 ,please refer to the hal layer errcode file
*
* Others: 
********************************************************************************/
SINT32 halAudio_RcdStart(T_ZDrvRcd_InfoParam *rcdParam)
{
    if ((NULL != gHalAudio_ObjPtr) && (NULL != gHalAudio_ObjPtr->halAudio_RcdStart))
    {
        return gHalAudio_ObjPtr->halAudio_RcdStart(rcdParam);
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halAudio_RcdStop
* Description: This function is used to stop record.
* Parameters: 
*   Input:None
*   Output:None
* Returns:
*           T_ZDrv_ErrCode
*           others: if errcode<-100 ,please refer to the hal layer errcode file
*
* Others: 
********************************************************************************/
SINT32 halAudio_RcdStop(VOID)
{
    if ((NULL != gHalAudio_ObjPtr) && (NULL != gHalAudio_ObjPtr->halAudio_RcdStop))
    {
        return gHalAudio_ObjPtr->halAudio_RcdStop();
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halAudio_GetRcdBuf
* Description: This function is used to get the buffer of record.
* Parameters: 
*   Input:
*           pBufInfo: the buffer of record info
*   Output:None
* Returns:
*           T_ZDrv_ErrCode
*           others: if errcode<-100 ,please refer to the hal layer errcode  file
*
* Others: 
********************************************************************************/
SINT32 halAudio_GetRcdBuf(T_ZDrvAudio_BufInfo *pBufInfo)
{
    if ((NULL != gHalAudio_ObjPtr) && (NULL != gHalAudio_ObjPtr->halAudio_GetRcdBuf))
    {
        return gHalAudio_ObjPtr->halAudio_GetRcdBuf(pBufInfo);
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halAudio_FreeRcdBuf
* Description: This function is used to relese the buffer of record.
* Parameters: 
*   Input:
*           pBuf: the buffer of record
*   Output:None
* Returns:
*           T_ZDrv_ErrCode
*           others: if errcode<-100 ,please refer to the hal layer errcode file
*
* Others: 
********************************************************************************/
SINT32 halAudio_FreeRcdBuf(VOID *pBuf)
{
    if ((NULL != gHalAudio_ObjPtr) && (NULL != gHalAudio_ObjPtr->halAudio_FreeRcdBuf))
    {
        return gHalAudio_ObjPtr->halAudio_FreeRcdBuf(pBuf);
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halAudio_Enable3DEffect
* Description: This function is used to enable or disenable 3DEffect.
* Parameters: 
*   Input:
*           pAudio3DEffect: 3deffect
*   Output:None
* Returns:
*           T_ZDrv_ErrCode
*           others: if errcode<-100 ,please refer to the hal layer errcode  file
*
* Others: 
********************************************************************************/
SINT32 halAudio_Enable3DEffect(T_ZDrvAudio_3DEFFECT* pAudio3DEffect)
{
    if ((NULL != gHalAudio_ObjPtr) && (NULL != gHalAudio_ObjPtr->hal_Audio_Enable3DEffect))
    {
        return gHalAudio_ObjPtr->hal_Audio_Enable3DEffect(pAudio3DEffect);
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halAudio_GetRcdData
* Description: This function is used to get record data.
* Parameters: 
*   Input:None        
*   Output:
         param: record data info
* Returns:
*           T_ZDrv_ErrCode
*           others: if errcode<-100 ,please refer to the hal layer errcode  file
*
* Others: 
********************************************************************************/
/*SINT32 halAudio_GetRcdData(T_ZDrvAudio_BufInfo *param)
{
    if ((NULL != gHalAudio_ObjPtr) && (NULL != gHalAudio_ObjPtr->halAudio_GetRcdData))
    {
        return gHalAudio_ObjPtr->halAudio_GetRcdData(param);
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}*/

/*******************************************************************************
* Function: halAudio_SetRecordPath
* Description: This function is used to set record input path.
* Parameters: 
*   Input:
*           param: record path info
*   Output:None
* Returns:
*           T_ZDrv_ErrCode
*           others: if errcode<-100 ,please refer to the hal layer errcode  file
*
* Others: 
********************************************************************************/
SINT32 halAudio_SetRecordPath(T_ZDrv_CodecInputPath *param)
{
    if ((NULL != gHalAudio_ObjPtr) && (NULL != gHalAudio_ObjPtr->halAudio_SetRecordPath))
    {
        return gHalAudio_ObjPtr->halAudio_SetRecordPath(param);
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halAudio_SetRecordVol
* Description: This function is used to set the volum of record.
* Parameters: 
*   Input:
*           param: the volum of record
*   Output:None
* Returns:
*           T_ZDrv_ErrCode
*           others: if errcode<-100 ,please refer to the hal layer errcode  file
*
* Others: 
********************************************************************************/
SINT32 halAudio_SetRecordVol(T_ZDrvAudio_InputVolLevel *param)
{
    if ((NULL != gHalAudio_ObjPtr) && (NULL != gHalAudio_ObjPtr->halAudio_SetRecordVol))
    {
        return gHalAudio_ObjPtr->halAudio_SetRecordVol(param);
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
 * Function: zDrvAudio_SetOperations
 * Description: This function is used to set the audio instance of hal layer.
 * Parameters: 
 *   Input:None
 *   Output:None
 *
 * Returns: The pointer to audio function block of hal layer
 *
 * Others: 
 ********************************************************************************/
VOID zDrvAudio_SetOperations(T_HalAudio_Opt* AudioObjPtr)
{
    gHalAudio_ObjPtr = AudioObjPtr;
}

