/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    hal_earpiece.h
 * File Mark:    
* Description:  Provide earpiece hal function prototype declaration and type declaration.
 * Others:        
 * Version:       V1.0
 * Author:        LvWenhua
 * Date:          2008-05-12
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ********************************************************************************/

#ifndef _HAL_EARPIECE_H
#define _HAL_EARPIECE_H

#include "earpiece_api.h"

/****************************************************************************
* 	                                        Include files
****************************************************************************/


/****************************************************************************
* 	                                        Macros
****************************************************************************/


/****************************************************************************
* 	                                        Types
****************************************************************************/

typedef  enum {
	EARPIECE_TAKEOFF,
	EARPIECE_TAKEON,

	MAX_EARPIECE
}
T_Earpiece_FirstState;


typedef void (*T_ZDrvEarp_CallbackFunc) (T_ZDrvEarp_Info);

typedef enum  {
	SND_JACK_NO_HEADSET = 0x0,
	SND_JACK_HEADPHONE	= 0x0001,
	SND_JACK_MICROPHONE	= 0x0002,
	SND_JACK_HEADSET	= SND_JACK_HEADPHONE | SND_JACK_MICROPHONE,
	SND_JACK_LINEOUT	= 0x0004,
	SND_JACK_MECHANICAL	= 0x0008, /* If detected separately */
	SND_JACK_VIDEOOUT	= 0x0010,
	SND_JACK_AVOUT		= SND_JACK_LINEOUT | SND_JACK_VIDEOOUT,
	SND_JACK_LINEIN		= 0x0020,
} T_ZDrvEarp_type;

typedef struct {
    T_ZDrvEarp_Info inform;
    T_ZDrvEarp_CallbackFunc callback;
}T_HalEarp_Block;

typedef struct 
{
    SINT32 (*hal_earp_Open)(VOID);
    SINT32 (*hal_earp_Close)(VOID);
    SINT32 (*hal_earp_get_plug_status)(T_ZDrvEarp_State* plug_status);  
    SINT32 (*hal_earp_set_callback_func)(T_ZDrvEarp_CallbackFunc callbackFunc);
    SINT32 (*hal_earp_set_hook_enable)(VOID);
    SINT32 (*hal_earp_set_hook_disable)(VOID);
} T_HalEarp_Opt;

/****************************************************************************
* 	                                        Constants
****************************************************************************/

/****************************************************************************
* 	                                        Global  Variables
****************************************************************************/

/****************************************************************************
* 	                                        Function Prototypes
****************************************************************************/

/*******************************************************************************
 * Function: halEarp_Init
 * Description: This function is used to init earpiece device
 * Parameters: 
 *   Input:None
 *   Output:None
 *
 * Returns: 0:success
 *              -1:fail
 *
 * Others: 
 ********************************************************************************/
extern SINT32 halEarp_Open(VOID);

/*******************************************************************************
 * Function: halEarp_Exit
 * Description: This function is used to exit earpiece device
 * Parameters: 
 *   Input:None
 *   Output:None
 *
 * Returns: 0:success
 *              -1:fail
 *
 * Others: 
 ********************************************************************************/
extern SINT32 halEarp_Close(VOID);

/*******************************************************************************
 * Function: halEarp_Exit
 * Description: This function is used to exit earpiece device
 * Parameters: 
 *   Input:None
 *   Output:None
 *
 * Returns: 0:success
 *              -1:fail
 *
 * Others: 
 ********************************************************************************/
extern SINT32 halEarp_GetPlugStatus(T_ZDrvEarp_State* plug_status);

/*******************************************************************************
* Function: halEarp_SetCallbackFunc
* Description: This function is used to set the callback function.
* Parameters: 
*   Input:
*           callbackFunc: the pointer to the callback function
*   Output:None
*
* Returns: None
*
* Others: 
********************************************************************************/
extern SINT32 halEarp_SetCallbackFunc(T_ZDrvEarp_CallbackFunc callbackFunc);

extern SINT32 halEarp_SetHookEnable(VOID);

extern SINT32 halEarp_SetHookDisable(VOID);

/*******************************************************************************
 * Function: zDrvEarp_SetOperations
 * Description: This function is used to set the earpiece instance of hal layer.
 * Parameters: 
 *   Input:None
 *   Output:None
 *
 * Returns: The pointer to earpiece function block of hal layer
 *
 * Others: 
 ********************************************************************************/
VOID zDrvEarp_SetOperations(T_HalEarp_Opt* EarpObjPtr);


#endif/*_HAL_EARPIECE_H*/

