/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    uicc_access.h
 * File Mark:    
 * Description:  This header file contains declarations related to the Card access layer containing ATR, PPS and INS engines.
 * Others:        
 * Version:       v1.0
 * Author:        mtr
 * Date:          2007-03-28
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ******************************************************************************/


#ifndef _UICC_ACCESS_H
#define _UICC_ACCESS_H

/****************************************************************************
* 	                                        Include files
****************************************************************************/
#include "uicc_type.h"
#include "ring_queue.h"

/****************************************************************************
* 	                                        Macros
****************************************************************************/
#define UICC_T_WWT 1200000    /* [us] Work Waiting Timer value                  */
#define UICC_T_IWT 1200000    /* [us] Initial Waiting Timer value.              */

#define UICC_F_DEFAULT     0x01
#define UICC_D_DEFAULT     0x01
#define UICC_DEFAULT_IFS     32
#define UICC_DEFAULT_WI      10
#define UICC_DEFAULT_CWI     13
#define UICC_DEFAULT_BWI      4
#define UICC_DEFAULT_EDC      0
#define UICC_DEFAULT_N        0

#define UICC_MAX_NOF_HISTORICAL_CHARS 15

#define UICC_EPILOGUE_POS  UICC_prologue[UICC_LEN_POS]     

#define UICC_PROLOGUE_SIZE  3
#define UICC_EPILOGUE_SIZE  (UICC_card_profile[UICC_current_reader].edc + 1)
/*  .....edc can only hold the values 0 and 1 (masked in UICC_ATR) */
/*  .....edc = 0 -> EDC length is 1 byte. */
/*  .....edc = 1 -> EDC length is 2 byte. */

#define UICC_MIN(A,B) (((A) < (B)) ? (A) : (B)) 

#if defined(LINT)
#define __align(x) /* x */
#endif

/****************************************************************************
* 	                                        Types
****************************************************************************/
/*[Begin] [wangxia-2007/12/19]  added */
typedef enum T_UICC_PROTOCOL_MODE
{
  UICC_AUTOMATIC_PROTOCOL_SELECTION,   /*!< The driver selects the used protocol. */
  UICC_T0_PROTOCOL_SELECTION,          /*!< T=0 protocol should be selected if available. */
  UICC_T1_PROTOCOL_SELECTION           /*!< T=1 protocol should be selected if available. */  
} T_UICC_PROTOCOL_MODE;
/*[End] [wangxia-2007/12/19]*/
typedef enum
{
  UICC_USIM_FLOW_CONTROL, 
  UICC_DMA_FLOW_CONTROL,
  UICC_USIM_FLOW_CONTROL_WITH_DMA_INT
} T_UICC_DMA_FLOW_CONTROL;

typedef enum
{
  UICC_TX_CMD,
  UICC_RX_CMD
} T_UICC_CMD_DIR;

enum
{
  UICC_CLA_POS  = 0,
  UICC_INS_POS  = 1,
  UICC_P1_POS   = 2, 
  UICC_P2_POS   = 3,
  UICC_P3_POS   = 4,
  UICC_DATA_POS = 5  
};
  
enum
{
  UICC_NAD_POS = 0,
  UICC_PCB_POS = 1,
  UICC_LEN_POS = 2,
  UICC_INF_POS = 3
};

typedef enum /* UICC ATR controller events */
{
  UICC_ATR_TIMER_EXPIRED = UICC_TIMER_EXPIRED,          
  UICC_ATR_CHARACTER_OK = UICC_CHARACTER_OK,
  UICC_ATR_PARITY_ERROR = UICC_PARITY_ERROR,
  UICC_ATR_OVERRUN_ERROR = UICC_OVERRUN_ERROR,

  UICC_INITIATE_WARM_ATR = UICC_LAST_INT_EVENT,
  UICC_INITIATE_COLD_ATR,
  UICC_RESET_ATR,
  UICC_LAST_ATR_EVENT
} T_UICC_ATR_EVENTS;

typedef enum /* UICC PPS controller events */
{
  UICC_PPS_TIMER_EXPIRED = UICC_TIMER_EXPIRED,
  UICC_PPS_GUARD_TIMER_EXPIRED = UICC_GUARD_TIMER_EXPIRED,
  UICC_PPS_CHARACTER_OK	= UICC_CHARACTER_OK,
  UICC_PPS_PARITY_ERROR  = UICC_PARITY_ERROR,
  UICC_INITIATE_PPS = UICC_LAST_INT_EVENT,
  UICC_RESET_PPS,              
  UICC_LAST_PPS_EVENT
} T_UICC_PPS_EVENTS;


typedef enum /* UICC T0 Command handler events */
{
  UICC_CMD_TIMER_EXPIRED = UICC_TIMER_EXPIRED,
  UICC_CMD_T0_END = UICC_T0_END,
  UICC_CMD_OVERRUN_ERROR =UICC_OVERRUN_ERROR,
  UICC_CMD_CHTIMEOUT = UICC_CHTIMEOUT,
  UICC_CMD_RX_LSREQ = UICC_RX_LSREQ,	
  UICC_CMD_TX_LSREQ = UICC_TX_LSREQ,	
  UICC_CMD_RX_SREQ =  UICC_RX_SREQ,  
  UICC_CMD_TX_SREQ = 	UICC_TX_SREQ,	 
  UICC_CMD_RX_LBREQ = UICC_RX_LBREQ,	
  UICC_CMD_TX_LBREQ = UICC_TX_LBREQ,	
  UICC_CMD_RX_BREQ = 	UICC_RX_BREQ,  
  UICC_CMD_TX_BREQ =  UICC_TX_BREQ,
  UICC_INITIATE_CMD  = UICC_LAST_INT_EVENT,
  UICC_STOP_CMD_CLOCK,
  UICC_RESET_CMD,
  UICC_LAST_CMD_EVENT
} T_UICC_T0_CMD_EVENTS;

typedef enum /* UICC T0 Transport handler events */
{
  UICC_T0_DUMMY_EVENT,
  UICC_T0_INITIATE_INS,
  UICC_T0_CMD_SUCCEEDED,                
  UICC_T0_CMD_SUCCEEDED_NO_DATA,
  UICC_T0_CMD_FAILED,

  UICC_T0_CLOCK_STOPPED,
  UICC_T0_LAST_TRANS_EVENT
} T_UICC_T0_TRANS_EVENTS;


typedef enum /* UICC T1 Block handler events */
{
  UICC_BLOCK_ER_EXPIRED = UICC_TIMER_EXPIRED,		  
  UICC_BLOCK_CHARACTER_OK = UICC_CHARACTER_OK,
  UICC_T1_BLOCK_END = UICC_T1_END,
  UICC_BLOCK_PARITY_ERROR = UICC_PARITY_ERROR,
  UICC_BLOCK_OVERRUN_ERROR = UICC_OVERRUN_ERROR,
  UICC_BLOCK_CHTIMEOUT = UICC_CHTIMEOUT,
  UICC_T1_BLOCK_PARITY_ERROR = UICC_T1_PARITY_ERROR,
  UICC_T1_BLOCK_BWT_EXPIRED = UICC_T1_BWT_EXPIRED,
  UICC_BLOCK_UNKNOWN_INT = UICC_UNKNOWN_INT,
  UICC_BLOCK_RX_LSREQ = UICC_RX_LSREQ,  
  UICC_BLOCK_TX_LSREQ = UICC_TX_LSREQ,  
  UICC_BLOCK_RX_SREQ = UICC_RX_SREQ,	
  UICC_BLOCK_TX_SREQ = UICC_TX_SREQ,	  
  UICC_BLOCK_RX_LBREQ = UICC_RX_LBREQ,  
  UICC_BLOCK_TX_LBREQ = UICC_TX_LBREQ,  
  UICC_BLOCK_RX_BREQ = UICC_RX_BREQ,	
  UICC_BLOCK_TX_BREQ = UICC_TX_BREQ,	
  
  UICC_INITIATE_BLOCK = UICC_LAST_INT_EVENT,
  UICC_STOP_BLOCK_CLOCK,
  UICC_RESET_BLOCK,
  UICC_LAST_BLOCK_EVENT
} T_UICC_T1_BLOCK_EVENTS;

typedef enum /* UICC T1 Link handler events */
{
  UICC_DUMMY_LINK_EVENT,
  UICC_INITIATE_LINK,
  UICC_BLOCK_RECEIVED,
  UICC_BWT_TIMEOUT,
  UICC_CWT_TIMEOUT,        

  UICC_CHAR_TIMEOUT,
  UICC_CHAR_PARITY_ERROR,
  UICC_CHAR_OVERRUN_ERROR,
  UICC_UNKNOWN_EVENT,
  UICC_BLOCK_CLOCK_STOPPED,

  UICC_LEN_VIOLATION,
  UICC_LAST_LINK_EVENT
} T_UICC_T1_LINK_EVENTS;

typedef enum /* UICC T1 Transport handler events */
{
  UICC_T1_DUMMY_EVENT,
  UICC_T1_INITIATE_INS,
  UICC_T1_CMD_SUCCEEDED,                
  UICC_T1_CMD_FAILED,
  UICC_T1_LAST_TRANS_EVENT
} T_UICC_T1_TRANS_EVENTS;

typedef enum /* UICC ctrl card presence events */
{
  UICC_CARD_IN_OUT_TIMER_EXPIRED = UICC_LAST_INT_EVENT
} T_UICC_CTRL_CARD_PRESENCE_EVENTS;

/* =============== */
/* ATR_CTRL_STATES */
/* =============== */
typedef enum
{
  UICC_ATR_NONE,
  UICC_ATR_READY,
  UICC_COLD_ENABLING,
  UICC_WARM_ENABLING,
  UICC_ACTIVATING_VCC,

  UICC_ACTIVATING_IO,
  UICC_TS_INTERNAL_RESET,
  UICC_TS_ACTIVE_LOW_RESET,
  UICC_T0,
  UICC_TA1, 

  UICC_TB1, 
  UICC_TC1, 
  UICC_TD1,
  UICC_TA2, 
  UICC_TB2, 

  UICC_TC2, 
  UICC_TDI,
  UICC_TAI, 
  UICC_TBI, 
  UICC_TCI,

  UICC_HISTORY,
  UICC_TCK,
  UICC_ATR_SUCCEDED,
  UICC_ATR_ERROR
} T_UICC_ATR_CTRL_STATE;

/* =============== */
/* PPS_CTRL_STATES */
/* =============== */
typedef enum
{
  UICC_PPS_NONE,
  UICC_PPS_READY,
  UICC_NO_PPS_NEEDED,
  UICC_PROTOCOL_PARAMETERS_NOT_SUPPORTED,       
  UICC_WARM_RESET_REQUIRED,       

  UICC_PREPARING_PPS,
  UICC_PPSS_REQ,
  UICC_PPS0_REQ,
  UICC_PPS1_REQ,
  UICC_PCK_REQ,

  UICC_PPSS_RESP,
  UICC_PPS0_RESP,
  UICC_PPS1_RESP,
  UICC_PPS2_RESP,
  UICC_PPS3_RESP,

  UICC_PCK_RESP,
  UICC_PPS_COMPLETED
} T_UICC_PPS_CTRL_STATE;

/* ============= */
/* T0_CMD_STATES */
/* ============= */
#ifdef UICC_HW_CONTROLLED_T0
  typedef enum
  {
    UICC_T0_CMD_NONE,
    UICC_T0_CMD_READY_CLK_OFF,
    UICC_T0_CMD_READY,
    UICC_RX_HEADER,
    UICC_CMD_DATA,

    UICC_CMD_SUCCEEDED,
    UICC_CMD_FAILED,
    UICC_AWAIT_CLK_POWER_DOWN,
    UICC_TX_CMD_DATA,
    UICC_RX_CMD_DATA,
    UICC_CMD_AWAIT_DMA_END,
    UICC_CMD_SUCCEEDED_WITH_NO_DATA,
    UICC_TX_AWAIT_FIFO_REQUEST,
    UICC_TX_PACK_TRANS,
    UICC_RX_AWAIT_FIFO_REQ,
    UICC_RX_PACK_TRANS    
  } T_UICC_T0_CMD_CTRL_STATE;
#else

  typedef enum
  {
    UICC_T0_CMD_NONE,
    UICC_T0_CMD_READY_CLK_OFF,
    UICC_T0_CMD_READY,
    UICC_CMD_HEADER_GUARD,
    UICC_CMD_HEADER,

    UICC_TX_PROCEDURE_BYTE,
    UICC_TX_ONE_DATA_GUARD,
    UICC_TX_ONE_DATA,
    UICC_TX_MORE_DATA_GUARD,
    UICC_TX_MORE_DATA,

    UICC_RX_PROCEDURE_BYTE,
    UICC_RX_ONE_DATA,
    UICC_RX_MORE_DATA,
    UICC_CMD_RESULT,
    UICC_CMD_SUCCEEDED,

    UICC_AWAIT_CLK_POWER_DOWN
  } T_UICC_T0_CMD_CTRL_STATE;
#endif

/* ==================== */
/* T0_TRANS_CTRL_STATES */
/* ==================== */
typedef enum {
  UICC_T0_TRANS_NONE,
  UICC_T0_TRANS_READY,
  UICC_CASE_1_CMD,
  UICC_RX_HANDLING_CASE_2_4_CMD,  
  UICC_TX_HANDLING_CASE_3_CMD,

  UICC_TX_HANDLING_CASE_4_CMD,  
  UICC_RESEND_CMD,
  UICC_GET_RESPONSE_AFTER_61H,
  UICC_GET_RESPONSE_AFTER_62_63H,  
  UICC_GET_RESPONSE_AFTER_9FH,

  UICC_OVERFLOW_HANDLING,
  UICC_TRANS_SUCCEEDED
} T_UICC_T0_TRANS_CTRL_STATE;

/* ==================== */
/* T1_BLOCK_CTRL_STATES */
/* ==================== */
#ifdef UICC_HW_CONTROLLED_T1
  typedef enum
  {
    UICC_BLOCK_NONE,
    UICC_BLOCK_READY_CLK_OFF,
    UICC_BLOCK_READY,
    UICC_TX_FRAME,
    UICC_RX_PROLOGUE,

    UICC_RX_INF_EPILOGUE,
    UICC_RX_PAR_BLOCK_ERROR,
    UICC_RX_PAR_BLOCK_FAILED,    
    UICC_TX_ERROR,
    UICC_BWT_ERROR,

    UICC_CWT_ERROR,    
    UICC_OVR_ERROR,    
    UICC_BLOCK_ERROR,    
    UICC_BLOCK_SUCCEEDED,
    UICC_BLOCK_AWAIT_CLOCK_OFF,
    
    UICC_CHAR_RX_INF_EPILOGUE,
    UICC_TX_AWAIT_FIFO_REQ,
    UICC_RX_PROLOGUE_ALFEEN,
    UICC_TX_TRANS,    
    UICC_RX_TRANS,
    UICC_RX_FRAME    
  } T_UICC_T1_BLOCK_CTRL_STATE;
#else
  typedef enum
  {
    UICC_BLOCK_NONE,
    UICC_BLOCK_READY_CLK_OFF,
    UICC_BLOCK_READY,
    UICC_TX_NAD,
    UICC_TX_PCB,

    UICC_TX_LEN,
    UICC_TX_INF,
    UICC_TX_EDC,
    UICC_RX_NAD,
    UICC_RX_PCB,

    UICC_RX_LEN,
    UICC_RX_INF,
    UICC_RX_EDC,
    UICC_BLOCK_SUCCEEDED,
    UICC_BLOCK_ERROR,

    UICC_BLOCK_AWAIT_CLOCK_OFF
  } T_UICC_T1_BLOCK_CTRL_STATE;
#endif

/* =================== */
/* T1_LINK_CTRL_STATES */
/* =================== */
typedef enum 
{
  UICC_T1_LINK_NONE,
  UICC_T1_LINK_READY,
  UICC_SENDING_IFX_REQ,
  UICC_SENDING_I_BLOCK,
  UICC_SENDING_I_BLOCK_CHAIN,
  UICC_SENDING_I_BLOCK_CHAIN_LAST,  

  UICC_RECEIVING_I_BLOCK,
  UICC_ABORT_RECEIVING_CHAIN,
  UICC_ABORT_SENDING_CHAIN,
  UICC_SENDING_RESYNC_REQ,
  UICC_LINK_SUCCEEDED  
} T_UICC_T1_LINK_CTRL_STATE;

/* =================== */
/* T1_TRANS_CTRL_STATES */
/* =================== */
typedef enum {
  UICC_T1_TRANS_NONE,
  UICC_T1_TRANS_READY,
  UICC_EXECUTING_CASE_1_CMD,
  UICC_EXECUTING_CASE_2_CMD,
  UICC_EXECUTING_CASE_3_CMD,

  UICC_EXECUTING_CASE_4_CMD
} T_UICC_T1_TRANS_CTRL_STATE;

typedef struct {
  ubyte            di;                  /* Baud Rate Adjustment factor [TA(1)] */
  ubyte            fi;                  /* Clock Rate Conversion factor [TA(1)] */
  ubyte            d_used;              /* The used Baud Rate Adjustment factor in the current session. */
  ubyte            f_used;              /* The used Clock rate Conversion factor in the current session. */
  ubyte            N;                   /* Extra Guard Time [TC(1)] */
  ushort           T_indicated;         /* Supported protocols [TD(i)] in a bit-field (T0=..0001, T1=..0010) [TD(i)] */
  T_UICC_PROTOCOL  T_used;              /* The used protocol in the current session. */
  ubyte            wi;                  /* Work Waiting Time calculatiopn factor [TC(2)] */
  ubyte            ifsc;                /* Information Field Size Card (the max. size the card can accept to receive) */
  ubyte            ifsd;                /* Information Field Size Device (the max. size the device can accept to receive) */
  ubyte            ifsc_used;           /* The actual used IFSC (the max. size the card can accept to receive) */
  ubyte            ifsd_used;           /* The actual used IFSD (the max. size the device can accept to receive) */
  ubyte            cwi;                 /* Character Waiting Time (CWI) [first T=1 TB(i)] */
  ubyte            bwi;                 /* Block Waiting Time (BWI) [first T=1 TB(i)] */
  ubyte            edc;                 /* Error Detection Code (EDC) [first T=1 TC(i)] */
  T_COM_CONVENTION convention;          /* Hold the communication convention (direct/inverse). */
  ushort           ta2_specific;        /* Specific mode (negotiable/specific) byte. The MSB value indicates 
                                           that the byte has actually been received. 
                                           |15|14|13|12|11|10|09|08|07|06|05|04|03|02|01|00|
                                           |  Data present indic.  |  |--|--|  |     T     |             
                                                                    |        |      |_______ Suggested Protocol
                                                                   |        |______________ Parameter definition parameter
                                                                  |_______________________ Ability to change indication */
      
  ushort           class_clock;         /* Class (voltage) and Indicator (UI) [first T=1 TA(i)]. The 
                                           MSB value indicates that the byte has actually been received. 
                                           |15|14|13|12|11|10|09|08|07|06|05|04|03|02|01|00|
                                           |  Data present indic.  |  XI |        UI       |            
                                                                      |           |___________ Class Indication (voltage)
                                                                     |_______________________ Clock Stop Indicatior      */

  BOOL                   voltage_settled;      /* Indicates if the voltage level has been indicated and thereby settled */
  T_UICC_VOLTAGE_CLASS   suggested_voltage;    /* The voltage level suggested for activation. */
  T_UICC_VOLTAGE_CLASS   used_voltage;         /* The actual (and currently) used voltage level. */
  T_UICC_CLOCK_STOP_MODE used_clock_stop_mode; /* The actual (and currently) used clock stop mode. */
  T_UICC_PROTOCOL_MODE   protocol_mode;        /* The protocol mode desired by upper layers.  071219*/ 
} T_UICC_CARD_PROFILE;

typedef struct {
  T_UICC_CMD_DIR  cmd_direction;
  ushort          data_size;
} T_UICC_T0_TPDU_CTRL;

typedef struct {
  ubyte sw1;
  ubyte sw2;
} T_UICC_CMD_RSP;

typedef struct
{
  union
  {
    ubyte  lrc;
    ushort crc;
  } edc;
} T_UICC_EPILOGUE_FIELD;


typedef struct {
  ushort    max_tx_payload_size;
  ushort    remaining_tx_payload_cnt;
  ushort    old_remaining_tx_payload_cnt;
  ubyte     *current_tx_payload_ptr;
  ubyte     *old_current_tx_payload_ptr;
  ubyte     *org_tx_payload_ptr;
  ushort    max_rx_payload_size;
  ushort    current_rx_payload_cnt;
  ubyte     *rx_payload_ptr;
  ubyte     *org_rx_payload_ptr;  
  ubyte     bwt_multiplier;  
} T_UICC_T1_TPDU_CTRL; 


typedef struct {
  ushort    cwt_extension;
  ushort    bwt_extension;
  ushort    wwt_extension;
  ubyte     max_speed;
  ubyte     preferred_protocol;
  ubyte     bgt;
  ubyte     support_voltage;
  ubyte     reserved_1;
  ubyte     reserved_2;
  ubyte     reserved_3;
  ubyte     reserved_4;  
} T_UICC_PROFILE_PARAMETER;


typedef T_UICC_CMD_RSP T_UICC_TPDU_FOOTER;







/****************************************************************************
* 	                                        Constants
****************************************************************************/

/****************************************************************************
* 	                                        Global  Variables
****************************************************************************/
extern ushort const UICC_baud_rate_table[];
extern ushort const UICC_clock_rate_table[];

extern T_UICC_CARD_PROFILE         UICC_card_profile[UICC_NOF_CARD_SLOTS];

extern T_UICC_ATR_CTRL_STATE       UICC_atr_ctrl_state;
extern T_UICC_PPS_CTRL_STATE       UICC_pps_ctrl_state;
extern T_UICC_T0_CMD_CTRL_STATE    UICC_t0_cmd_ctrl_state;
extern T_UICC_T0_TRANS_CTRL_STATE  UICC_t0_trans_ctrl_state;
extern T_UICC_T1_BLOCK_CTRL_STATE  UICC_t1_block_ctrl_state;
extern T_UICC_T1_LINK_CTRL_STATE   UICC_t1_link_ctrl_state;
extern T_UICC_T1_TRANS_CTRL_STATE  UICC_t1_trans_ctrl_state;

extern ubyte UICC_nof_atr_characters;
extern ubyte UICC_atr_characters[UICC_MAX_ATR_CHARACTERS];
extern ubyte UICC_t1_s_seq_no;
extern ubyte UICC_t1_r_seq_no;

#if 0//shideyou 20130718
#if defined (UICC_FIFO_MODE)
  extern ubyte __align(4)     UICC_tpdu_data[UICC_MAX_PAYLOAD_SIZE];
#else
  extern ubyte    UICC_tpdu_data[UICC_MAX_PAYLOAD_SIZE];
#endif
#else

#if defined (UICC_FIFO_MODE)
  extern ubyte 
  #ifdef __ARMCC_VERSION /*rvct*/
  __align(4)
  #endif
  UICC_tpdu_data[UICC_MAX_PAYLOAD_SIZE]
  #ifdef __GCC__
  __attribute__ ((aligned(4)))
  #endif
  ;
#else
  extern ubyte    UICC_tpdu_data[UICC_MAX_PAYLOAD_SIZE];
#endif
#endif


extern ubyte                     *UICC_tpdu_data_ptr;
extern ubyte                     *UICC_prologue;
extern ubyte                     *UICC_inf;
      
extern T_UICC_TPDU_FOOTER        UICC_tpdu_footer;
extern T_UICC_T0_TPDU_CTRL       UICC_t0_tpdu_ctrl;
extern T_UICC_T1_TPDU_CTRL       UICC_t1_tpdu_ctrl;

extern T_UICC_PROFILE_PARAMETER     UICC_profile_parameter;

#ifdef UICC_DEBUG_INF
extern UINT8 UICC_debug[200][3];
extern UINT16 UICC_debug_count;
extern UINT8 UICC_debug_t0[500][3];
extern UINT16 UICC_debug_count_t0;
#endif

/****************************************************************************
* 	                                        Function Prototypes
****************************************************************************/
extern void UICC_reset_atr(void);
extern void UICC_ctrl_atr(T_UICC_ATR_EVENTS event);
extern ubyte UICC_get_atr_historical_offset(ubyte *atr, ubyte nof_atr);
extern ushort UICC_get_atr_protocols(ubyte *atr, ubyte nof_atr);  /*add 071219*/

extern void UICC_reset_pps(void);
extern void UICC_ctrl_pps(T_UICC_PPS_EVENTS event);

extern void UICC_t0_transport_handler(T_UICC_T0_TRANS_EVENTS event);    
extern void UICC_t0_cmd_handler(T_UICC_T0_CMD_EVENTS event);    
extern void UICC_reset_t0_cmd_handler(void);

extern void UICC_t1_transport_handler(T_UICC_T1_TRANS_EVENTS event);    
extern void UICC_reset_t1_transport_handler(void);
extern void UICC_t1_data_link_handler(T_UICC_T1_LINK_EVENTS event);
extern void UICC_reset_t1_data_link_handler(void);
extern void UICC_t1_block_handler(T_UICC_T1_BLOCK_EVENTS event);    
extern void UICC_reset_t1_block_handler(void);
extern void UICC_resign_from_power_saving(void);

#ifdef UICC_ENABLE_IN_OUT_DETECTION
  extern void UICC_ctrl_card_presence(T_UICC_CTRL_CARD_PRESENCE_EVENTS event);
  extern void UICC_in_out_control(T_UICC_CTRL_CARD_PRESENCE_EVENTS event);
#endif

#endif /* _UICC_ACCESS_H */
                                                 /* End of file.              */
