/************************************************************************
* Ȩ(C)2007,ͨѶɷ޹˾
* ģ   ƵŲģ
* ļƣ zMsp_com.h
* ļʶ 
* ժҪ 
* 
* ޸      汾     ޸ı       ޸       ޸      
* ----------------------------------------------------------------------
* 2009/3/25    1.0                                                
************************************************************************/

#ifndef ZMSP_COM_H
#define ZMSP_COM_H

#ifdef __cplusplus
   extern "C"
   {
#endif 
/**************************************************************************
 *                        ͷļ                                      *
 **************************************************************************/
#include "drv_api.h"
#include "oss_api.h"
#include "ZMF_OutDef.h"
#include "zte_display.h"
#include "zMsp_def.h"

/**************************************************************************
 *                                                                    *
 **************************************************************************/

/**************************************************************************
 *                         궨                                         *
 **************************************************************************/
/* Ժ꿪 */
#define __ZMSP_DEBUG__

/* ĺ꿪 */
#define  TEST_CREATE_INDEX


/* Ա */
#ifdef __ZMSP_DEBUG__
#define zMspCom_Print() zMspCom_DebugPrint(SUBMDL_MMBASE, PRINT_LEVEL_ALLWAYS, __FILE__, __LINE__)
#else
#define zMspCom_Print()  
#endif

/**************************************************************************
 *                                                                *
 **************************************************************************/
typedef VOID *DecHandle;
typedef VOID *EncHandle;

typedef enum
{
    MM_MODULE_AUDIO_DECODE = 0x00000001,/*Ƶ*/
    MM_MODULE_AUDIO_ENCODE = 0x00000002,/*Ƶ*/
    MM_MODULE_VIDEO_DECODE = 0x00000004,/*Ƶ*/
    MM_MODULE_VIDEO_ENCODE = 0x00000008,/*Ƶ*/
    MM_MODULE_CAMERA       = 0x00000010,/*ͷ*/
    MM_MODULE_FMRADIO      = 0x00000020,/*FM*/
    MM_MODULE_NETSOCKET    = 0x00000040, /*ý*/
    MM_MODULE_TOTAL_NUM
}MM_MODULE_ID_E;

typedef VOID (*MSP_NOTIFY_ERROR) (MM_MODULE_ID_E uiModule, DWORD dwParam);
typedef VOID (*MSP_NOTIFY_END) (MM_MODULE_ID_E uiModule);

/* Ƶý */
typedef struct _T_MediaAudioDecHandle
{
    DecHandle        pMediaDecHandle;      /* ý */
    EMediaAudioType  eMediaAType;          /* Ƶý */
}T_MediaAudioDecHandle;

/* Ƶý */
typedef struct _T_MediaAudioEncHandle
{
    EncHandle        pMediaEncHandle;      /* ý */
    EMediaAudioType  eMediaAType;          /* Ƶý */
}T_MediaAudioEncHandle;

/* Ƶʼ */
typedef struct _T_VideoEncInitParam
{
    UINT32                         uiStride;      /* ͼ */
    UINT32                         uiWidth;       /* ͼ */
    UINT32                         uiHeight;      /* ͼ߶ */
    UINT32                         uiFrameRate;   /* ֡ */
    UINT32                         uiBitrate;     /*  */
    UINT32                         uiVideoFd;     /* Ƶ豸 */
    T_ZDrv_PixelFmt                tPixelFmt;     /*  */
    T_ZDrvVideo_CodecStandard      tCodecStd;     /*  */
    T_ZDrv_RotateType              tRotate;       /* תǶ */
    T_ZDrv_MirrorType              tMirror;       /*  */
    T_ZDrv_EncQualityType          tQuality;      /* JPEG */
    
}T_VideoEncInitParam;

/* Ƶʵ򿪱ʱķֵڱԼرձʱʹ */
typedef struct _T_VideoEncInstParam
{
    UINT32         uiVideoFd;      /* Ƶ豸 */
    UINT32         uiVideoEncInst; /* Ƶʵ */   
    UINT32        *pHeaderData;    /* H264,MPEG4ȸʽͷϢ */
    UINT32         uiHeaderLen;    /* ͷݳ */
}T_VideoEncInstParam;

/* Ƶ */
typedef struct _T_VideoEncParam
{
    T_ZDrv_ImageDataBuf   pDataIn;   /* ָ */
    UINT8                *pDataOut;  /* ָ */
    UINT32                uiLenOut;  /* BufferСݳ */
    T_ZDrv_FrameType      frameType; /* ֡ */
    BOOL                  bIsBufferValid; /* pDataOutǷѾڴ */                 
}T_VideoEncParam;

typedef enum
{
    MSP_MODULE_AUDIO,   /* Ƶģ */
    MSP_MODULE_VIDEO,   /* Ƶģ */
    MSP_MODULE_OTHRE    /* ģ */
}MSP_MODULE_ID;

typedef enum
{
    MSP_PLAY_ERR,       /* 쳣 */
    MSP_PLAY_END        /* Ž */
}MSP_OP_MSG;

typedef enum
{
    FILE_DATA_NONE        = 0,                                   
    FILE_DATA_ONLY_AUDIO  = 1 << 0,                                      /* ýļƵ */
    FILE_DATA_ONLY_VIDEO  = 1 << 1,                                      /* ýļƵ */
    FILE_DATA_AUDIO_VIDEO = FILE_DATA_ONLY_AUDIO | FILE_DATA_ONLY_VIDEO  /* ýļƵ */
}FILE_DATA_INFO;

typedef struct _T_Video_FileParam
{
    UInt32                  u32FileID;            /* ýļͨID           */
    UInt32                  u32TrackNum;          /* Ŀ                   */
    UInt32                  u32AudioTrack;        /* Ƶ                   */
    UInt32                  u32VideoTrack;        /* Ƶ                   */
    UINT32                  uiAudioIndex;         /* Ƶ±             */
    UINT32                  uiVideoIndex;         /* Ƶ±             */
    UINT32                  uiAudioBufsize;       /* ƵС       */
    UINT32                  uiFileTotalTime;      /* ýļܲʱ       */
    UINT32                  uiMaxFramePcmLen;     /* һ֡Ƶռ */
    Float64                 f64AudioTimeScale;    /* Ƶʱ             */
    Float64                 f64VideoTimeScale;    /* Ƶʱ             */
    T_ZMFFileInfo          *pFileInfo;            /* ýļϢ             */    
    FILE_DATA_INFO          eFileDataInfo;        /* ýļƵϢ       */
    EMediaAudioType         eMediaAType;          /* Ƶظʽ             */
    EMediaVideoType         eMediaVType;          /* Ƶظʽ             */    
    T_ZDrvAudio_Channel     eChannel;             /* PCMͨ        */
    T_ZDrvAudio_SampleRate  eSample;              /* PCM                */  
}T_FileInfoParam;


typedef struct _T_Audio_AacParam
{
   UINT8   *pDecConfig;            /* Ϣ */
   SINT32   iConfigLen;            /* Ϣ */
   UInt32   u32SampleRate;         /*  */
   UInt32   u32Profile_ObjectType; /* Ϣ */   
}T_Audio_AacParam;

typedef struct
{
    SINT32  iBitrate;      /*                       */ 
    SINT32  iChannelIn;    /*  1--2--˫ */ 
    SINT32  iChannelOut;   /*  1--2--˫ */ 
    SINT32  iSampleRate;   /* ݵĲ                    */  
}T_MP3AddEnCoderData;

typedef struct _T_Audio_DecodeParam
{
   T_MediaAudioDecHandle    *pHandle;      /*  */    
   T_ZMFOutPutUnit          *pOutUnit;     /* ָ */
   VOID                     *pPhyBuf;      /* ַ */
   UINT32                    uiLen;        /* Buffer */
}T_Audio_DecodeParam;

/**************************************************************************
 *                          CԵͷļɲü           *
 **************************************************************************/

/**************************************************************************
 *                         ģ  CԵͷļɲü            *
 **************************************************************************/

/**************************************************************************
 *                         ȫֱ                                    *
 **************************************************************************/
extern MSP_NOTIFY_ERROR     zMsp_Notify_Error;
extern MSP_NOTIFY_END       zMsp_Notify_End;
extern UINT32 g_uiScreenWidth;
extern UINT32 g_uiScreenHeight;
extern UINT32 g_uiDefaultYSize;     /* ȫYUV420ʽYС */
extern UINT32 g_uiDefaultUSize;     /* ȫYUV420ʽUС */
extern UINT32 g_uiDefaultVSize;     /* ȫYUV420ʽVС */
extern UINT32 g_uiDefaultARGBSize;  /* ȫARGB888С         */

/**************************************************************************
 *                        ȫֺԭ                                     *
 **************************************************************************/ 
/**
 * ƣ zMspCom_InitFileParseModule 
 *  ʼļģ
 * ˵ (IN) 
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ 
 */
SINT32 zMspCom_InitFileParseModule(VOID);

/**
 * ƣ zMspCom_DecPreProcess 
 *  ýļǰĳʼļ֧ʶ
 * ˵ (IN)  eMoudleID       ģID
 *            (IN)  pFilePath       ýļ·
 *            (OUT) pFileInfoParam  ļýϢ
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ ļʼýļļʽԼý
 *            ļϢȡز(˴ƵBufferĴС
 *            Ϣ)
 */
SINT32 zMspCom_DecPreProcess(MSP_MODULE_ID eMoudleID, const char *pFilePath, T_FileInfoParam *pFileInfoParam);

/**
 * ƣ zMspCom_DecPostProcess 
 *  ýļ
 * ˵ (IN)  u32FileID   ýļͨID
 *   ֵ 
 * ˵ 
 */
VOID zMspCom_DecPostProcess(UInt32 u32FileID);

/**
 * ƣ zMspCom_LoadAudioDecodeLib 
 *  Ƶ
 * ˵ (IN)  eMediaAType  Ƶݸʽ
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ Ƶָ֧ʽԺҪ
 */
SINT32 zMspCom_LoadAudioDecodeLib(EMediaAudioType eMediaAType);

/**
 * ƣ zMspCom_UnLoadAudioDecodeLib 
 *  Ƶж
 * ˵ (IN)  eMediaAType  Ƶݸʽ
 *   ֵ 
 * ˵ Ƶָ֧ʽԺҪ
 */
VOID zMspCom_UnLoadAudioDecodeLib(EMediaAudioType eMediaAType);

/**
 * ƣ zMspCom_LoadAudioEnCodeLib 
 *  Ƶ
 * ˵ (IN)  eMediaAType  Ƶݸʽ
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ Ƶָ֧ʽԺҪ
 */
SINT32 zMspCom_LoadAudioEnCodeLib(EMediaAudioType eMediaAType);

/**
 * ƣ zMspCom_UnLoadAudioEnCodeLib 
 *  Ƶж
 * ˵ (IN)  eMediaAType  Ƶݸʽ
 *   ֵ 
 * ˵ Ƶָ֧ʽԺҪ
 */
VOID zMspCom_UnLoadAudioEnCodeLib(EMediaAudioType eMediaAType);

/**
 * ƣ zMspCom_OpenAudioDecoder 
 *  Ƶ
 * ˵ (IN)  eMediaAType  Ƶݸʽ
 *            (IN)  buffer       ַ
 *            (IN)  uiLen        ݳ
 *            (IN)  pAacParam    Aacò
 *            (OUT) pChannelMode ģʽ
 *            (OUT) pSampleRate  PCMݲ
 *   ֵ ʧܷNULL
 * ˵ Ƶָ֧ʽԺҪ
 */
T_MediaAudioDecHandle *zMspCom_OpenAudioDecoder(EMediaAudioType         eMediaAType, 
                                   UINT8                  *buffer, 
                                   UINT32                  uiLen, 
                                   T_Audio_AacParam       *pAacParam,
                                   T_ZDrvAudio_Channel    *pChannelMode,
                                   T_ZDrvAudio_SampleRate *pSampleRate);

/**
 * ƣ zMspCom_CloseAudioDecoder 
 *  رƵ
 * ˵ (IN)  eMediaAType: Ƶݸʽ
 *            (IN)  pHandle:     
 *   ֵ 
 * ˵ Ƶָ֧ʽԺҪ
 */
VOID zMspCom_CloseAudioDecoder(T_MediaAudioDecHandle *pHandle);

/**
 * ƣ zMspCom_AudioDecode 
 *  Ƶݽ
 * ˵ (IN) pHandle      
 *            (IN) eMediaAType  Ƶظʽ
 *            (IN) pOutUnit     һ֡Ƶ
 *            (IN) pRawData     ַ
 *            (IN) uiLen        
 *   ֵ ʵд볤ȡ
 * ˵ 
 */
UINT32 zMspCom_AudioDecode(T_Audio_DecodeParam * pDecParam);

/**
 * ƣ zMspCom_OpenAudioEncoder 
 *  Ƶ
 * ˵ (IN)eMediaAType:  ʽ
 *            (IN)pAddData:     򿪱ĸӲ
 *            (OUT)pFrameLen:   ʱһPCMݳ(λ:)
 *   ֵ 
 * ˵ AMR˲ΪNULL; MP3
 *            ˲ΪT_MP3AddEnCoderDataṹ
 */
T_MediaAudioEncHandle * zMspCom_OpenAudioEncoder(EMediaAudioType        eMediaAType,
                                   VOID             *pAddData,
                                   UINT32                 *pFrameLen);

/**
 * ƣ zMspCom_CloseAudioEncoder 
 *  رƵ
 * ˵ (IN)eMediaAType:  ʽ
 *            (IN)pHandle:      
 *   ֵ 
 * ˵ Ŀǰ֧AMR
 */
VOID zMspCom_CloseAudioEncoder(T_MediaAudioEncHandle *pHandle);

/**
 * ƣ zMspCom_AudioEncode 
 *  Ƶݱ
 * ˵ (IN)pHandle:      
 *            (IN)eMediaAType:  ʽ
 *            (IN)pRawData:     Դ
 *            (IN)uiRawDataLen: pRawData(λΪֽ)
 *            (OUT)pOutDataLen: ݳ(λΪֽ)
 *   ֵ ʵʱݣûʹϺͷ
 * ˵ 
 */
UINT8 *zMspCom_AudioEncode(T_MediaAudioEncHandle *pHandle,
                           VOID      *pRawData,  UINT32     uiRawDataLen,
                           UINT32    *pOutDataLen);

/**
 * ƣ zMspCom_OpenVideoEncoder 
 *  Ƶ
 * ˵ (IN)pInitParam:      Ƶʼ
 *   ֵ Ƶʵ
 * ˵ 
 */
T_VideoEncInstParam *zMspCom_OpenVideoEncoder(T_VideoEncInitParam *pInitParam);

/**
 * ƣ zMspCom_CloseVideoEncoder 
 *  رƵ
 * ˵ (IN)pHandle:      
 *   ֵ 
 * ˵ 
 */
VOID zMspCom_CloseVideoEncoder(T_VideoEncInstParam *pVideoEncHandle);

/**
 * ƣ zMsgCom_PostMsg 
 *  װ첽Ϣӿ
 * ˵ (IN) pThreadId  ߳ID
 *            (IN) uiMsgId    ϢID
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ ӿڽ֧ϢʽϢ
 */
SINT32 zMspCom_PostMsg(ZOSS_THREAD_ID pThreadId, UINT32 uiMsgId);

/**
 * ƣ zMsgCom_RecvMsg 
 *  Ϣ
 * ˵ (IN/OUT) pMsgId  ϢID
 *            (IN)     timeout յȴʱ
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ ӿڽ֧ϢʽϢ
 */
SINT32 zMspCom_RecvMsg(UINT32 *pMsgId, UINT32  timeout);

/**
 * ƣ zMsp_AudioOpen 
 *  Ƶ豸
 * ˵ (IN)
 *            (OUT)
 *   ֵ ɹ豸
 * ˵ 
 */
SINT32 zMspCom_AudioOpen(VOID);

/**
 * ƣ zMspCom_AudioClose 
 *  رƵ豸
 * ˵ (IN)
 *            (OUT)
 *   ֵ 
 * ˵ 
 */
VOID zMspCom_AudioClose(VOID);

/**
 * ƣ zMspCom_MidiOpen 
 *  MIDI豸
 * ˵ (IN)
 *            (OUT)
 *   ֵ 
 * ˵ 
 */
SINT32 zMspCom_MidiOpen(VOID);

/**
 * ƣ zMspCom_MidiClose 
 *  رMidi豸
 * ˵ (IN)
 *            (OUT)
 *   ֵ 
 * ˵ 
 */
VOID zMspCom_MidiClose(VOID);

/**
 * ƣ zMspCom_ToneOpen 
 *  Tone豸
 * ˵ (IN)
 *            (OUT)
 *   ֵ ɹ豸þֵ0
 * ˵ 
 */
 SINT32 zMspCom_ToneOpen(VOID);

/**
 * ƣ zMspCom_ToneClose 
 *  رTone豸
 * ˵ (IN)
 *            (OUT)
 *   ֵ 
 * ˵ 
 */
VOID zMspCom_ToneClose(VOID);

/**
 * ƣ zMsp_VideoOpen 
 *  Ƶ豸
 * ˵ (IN)
 *            (OUT)
 *   ֵ ɹ:豸
 * ˵ 
 */
SINT32 zMspCom_VideoOpen(VOID);

/**
 * ƣ zMspCom_VideoClose 
 *  رƵ豸
 * ˵ (IN)
 *            (OUT)
 *   ֵ 
 * ˵ 
 */
VOID zMspCom_VideoClose(VOID);

/**
 * ƣ zMsp_CamOpen 
 *  Cam豸
 * ˵ (IN)tSensor:ͷID
 *            (OUT)
 *   ֵ ɹ:豸
 * ˵ 
 */
SINT32 zMspCom_CamOpen(T_MSP_CAM_SENSOR tSensor);

/**
 * ƣ zMspCom_CamSelect 
 *  ͷѡ
 * ˵ (IN)ͷID
 *            (OUT)
 *   ֵ ɹ:MSP_COM_OP_SUCCESS
 * ˵ 
 */
SINT32 zMspCom_CamSelect(T_MSP_CAM_SENSOR tSensor);

/**
 * ƣ zMspCom_CamClose 
 *  رCam豸
 * ˵ (IN)
 *            (OUT)
 *   ֵ 
 * ˵ 
 */
VOID zMspCom_CamClose(VOID);

/**
 * ƣ zMspCom_GetCamFd 
 *  õCam豸
 * ˵ (IN)
 *            (OUT)
 *   ֵ Cam豸
 * ˵ 
 */
UINT32 zMspCom_GetCamFd(VOID);

/**
 * ƣ zMspCom_GetVideoFd 
 *  õVideo豸
 * ˵ (IN)
 *            (OUT)
 *   ֵ Video豸
 * ˵ 
 */
UINT32 zMspCom_GetVideoFd(VOID);

/**
 * ƣ zMspCom_GetAudioFd 
 *  õAudio豸
 * ˵ (IN)
 *            (OUT)
 *   ֵ Audio豸
 * ˵ 
 */
UINT32 zMspCom_GetAudioFd(VOID);

/**
 * ƣ zMspCom_GetMidiFd 
 *  õMidi豸
 * ˵ (IN)
 *            (OUT)
 *   ֵ Midi豸
 * ˵ 
 */
UINT32 zMspCom_GetMidiFd(VOID);

/**
 * ƣ zMspCom_GetToneFd 
 *  õTone豸
 * ˵ (IN)
 *            (OUT)
 *   ֵ Midi豸
 * ˵ 
 */
UINT32 zMspCom_GetToneFd(VOID);

/**
 * ƣ zMspCom_SetOutputVol 
 *  
 * ˵ (IN)vol: 
 *            (OUT)
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ 
 */
SINT32 zMspCom_SetOutputVol(T_MSP_OUTPUT_VOLUME_LEVEL vol);

/**
 * ƣ zMspCom_GetOutputVol 
 *  õ
 * ˵ (IN)     
 *            (OUT) vol: 
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ 
 */
SINT32 zMspCom_GetOutputVol(T_MSP_OUTPUT_VOLUME_LEVEL *vol);

/**
 * ƣ zMspCom_SetInputVol 
 *  
 * ˵ (IN)vol: 
 *            (OUT)
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ 
 */
SINT32 zMspCom_SetInputVol(T_MSP_INPUT_VOLUME_LEVEL vol);

/**
 * ƣ zMspCom_SetOutputChannel 
 *  ͨ
 * ˵ (IN)channel: ͨ
 *            (OUT)
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ 
 */
SINT32  zMspCom_SetOutputChannel(T_MSP_CHANNEL_OUTPUT channel);

/**
 * ƣ zMspCom_GetOutputChannel 
 *  ͨ
 * ˵ (IN)   
 *            (OUT) channel: ͨ
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ 
 */
SINT32  zMspCom_GetOutputChannel(T_MSP_CHANNEL_OUTPUT *channel);

/**
 * ƣ zMspCom_SetInputChannel 
 *  ͨ
 * ˵ (IN)vol: ͨ
 *            (OUT)
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ 
 */
SINT32  zMspCom_SetInputChannel (T_MSP_CHANNEL_INPUT channel);

/**
 * ƣ zMspCom_GetMute 
 *  ȡ
 * ˵ (IN): 
 *            (OUT):bFlag
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ 
 */
SINT32  zMspCom_GetMute(BOOL *bFlag);

/**
 * ƣ zMspCom_SetMute 
 *  þ
 * ˵ (IN)bFlag: TRUE: þ
 *                         FALSE:ȡ
 *            (OUT)
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ 
 */
SINT32  zMspCom_SetMute(BOOL bFlag);

/**
 * ƣ zMspCom_SetZoom 
 *  ͷ
 * ˵ (IN)zoom: ż
 *            (OUT)
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ ʱָ֧ù
 */
SINT32  zMspCom_SetZoom(T_MSP_ZOOM_LEVEL zoom);

/**
 * ƣ zMspCom_SetBrightness 
 *  ͷ
 * ˵ (IN)brightness: ȼ
 *            (OUT)
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ 
 */
SINT32  zMspCom_SetBrightness(T_MSP_BRIGHTNESS_LEVEL brightness);

/**
 * ƣ zMspCom_SetContrast 
 *  ͷԱȶ
 * ˵ (IN)contrast: Աȶȼ
 *            (OUT)
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ 
 */
SINT32  zMspCom_SetContrast(T_MSP_CONTRAST_LEVEL contrast);

/**
 * ƣ zMspCom_SetEffect 
 *  ͷЧ
 * ˵ (IN)effect: Чֵ
 *            (OUT)
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ 
 */
SINT32  zMspCom_SetEffect(T_MSP_EFFECT_LEVEL effect);

/**
 * ƣ zMspCom_SetWhiteBalance 
 *  ðƽ
 * ˵ (IN)whiteBalance: ƽֵ
 *            (OUT)
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ Ŀǰ֧
 */
SINT32  zMspCom_SetWhiteBalance(T_MSP_WHITE_BALANCE whiteBalance);

/* ƣ zMspCom_SetCaputureMode
 *  ģʽ
 * ˵ (IN)modeCAPTURE_MODE_Eṹ
 *   ֵ ɹMSP_COM_OP_SUCCESS
 * ˵ 
 */
SINT32 zMspCom_SetCaputureMode(CAPTURE_MODE_E mode);

/**
 * ƣ zMspCom_SetMirror
 *  þ
 * ˵ (IN)paramMIRROR_PARAM_Tṹ
 *   ֵ ɹDCAMERA_OP_SUCCESS;
 * ˵ 
 */
SINT32 zMspCom_SetMirror(MIRROR_PARAM_T *param);

/**
 * ƣ zMspCom_GetSampleRate 
 *  ȡƵ
 * ˵ (IN)  iSampleRate    
 *            (OUT) pSampleRate    Ƶ
 *   ֵ 
 * ˵ 
 */
VOID zMspCom_GetSampleRate(UINT32 iSampleRate, T_ZDrvAudio_SampleRate *pSampleRate);

/**
 * ƣ zMspCom_VideoPlayRectModify 
 *  ƵͼƬʾʼ
 * ˵ (OUT) pRectDest   Ƶ
 *            (IN)  pRectSrc    ԴƵ
 *            (IN)  uiSrcWidth  ppuԴͼƬ
 *            (IN)  uiSrcHeight ppuԴͼƬ
 *   ֵ ɹVIDEO_OP_SUCCESS
 * ˵ ӲƣƵͼƬʾxy
 *            Ϊ16ı߱16ı 
 */
SINT32 zMspCom_VideoPlayRectModify(RECT_T *pRectDest,  RECT_T *pRectSrc, 
                                   UINT32  uiSrcWidth, UINT32  uiSrcHeight);

/**
 * ƣ zMspCom_NotifyUser 
 *  MSP֪ͨû쳣Ϣ
 * ˵ (IN) eModule  MSPģ־
 *            (IN) eMsg     MSP־
 *   ֵ 
 * ˵ 
 */
VOID zMspCom_NotifyUser(MSP_MODULE_ID eModule, MSP_OP_MSG eMsg);

/**
 * ƣ zMspCom_DebugPrint 
 *  ӡӿ
 * ˵ (IN) 
 *   ֵ 
 * ˵ 
 */
VOID zMspCom_DebugPrint(UINT32 nModNo, UINT8 nPrintLevel, const CHAR *pFileName, UINT32 uiLine);

#ifdef __cplusplus
   } 
#endif

#endif
