/************************************************************************
* Ȩ(C)2007,ͨѶɷ޹˾
* ģ   P98BϿӵ绰Эջöýӿ
* ļƣZmmf_api_VT.c
* ļʶ 
* ժҪ 
* 
* ޸      汾     ޸ı       ޸       ޸      
* ----------------------------------------------------------------------
* 2009/9/19    1.0                                              
************************************************************************/
  
/**************************************************************************
 *                        ͷļ                                      *
 **************************************************************************/
#include "zMsp_Com.h"
#include "zte_vtdriver.h"

/**************************************************************************
 *                                                                    *
 **************************************************************************/
#define	MSG_ID_SC_NET_BASE           (0x2800)
#define MSG_ID_SC_CALL_BASE          (MSG_ID_SC_NET_BASE+0x100)
#define TPM_CALL_VP_OPEN_DEVICE_IND  (MSG_ID_SC_CALL_BASE+64)

/**************************************************************************
 *                                                                      *
 **************************************************************************/
#define ZMMF_OPER_TYPE_VT   "ZMMF_OPER_TYPE_VT"  /* VT */

/**************************************************************************
 *                                                                 *
 **************************************************************************/
/* ýԴ */
typedef enum
{   
    ZMMF_MEDIASOURCE_FILE_MID = 1,
    ZMMF_MEDIASOURCE_FILE_AMR,
    ZMMF_MEDIASOURCE_FILE_MP3,
    ZMMF_MEDIASOURCE_FILE_AAC,
    ZMMF_MEDIASOURCE_FILE_H263,
    ZMMF_MEDIASOURCE_FILE_YUV,
    ZMMF_MEDIASOURCE_FILE_3GP,
    ZMMF_MEDIASOURCE_TONE,
    ZMMF_MEDIASOURCE_RECORD,
    ZMMF_MEDIASOURCE_PHONE_RECORD,
    ZMMF_MEDIASOURCE_VIDEORECORD,
    ZMMF_MEDIASOURCE_CAMERACHIP,
    ZMMF_MEDIASOURCE_VT_ALL,
    ZMMF_MEDIASOURCE_VT_AUDIO,
    ZMMF_MEDIASOURCE_VT_VIDEO,
    ZMMF_MEDIASOURCE_VT_RCD,
    ZMMF_MEDIASOURCE_VT_CAM,
    ZMMF_MEDIASOURCE_STREAM_AUDIO,
    ZMMF_MEDIASOURCE_STREAM_VIDEO,
    ZMMF_MEDIASOURCE_STREAM_ALL
} T_ZMmf_MediaSource;

/* ֵ */
enum
{   
    ZMMF_SUCCESS = 0,
    ZMMF_FAILED  = -1,
};

typedef enum
{
    VT_PLAY_STATE_IDLE,   /* ״̬               */
    VT_PLAY_STATE_OPEN,   /* Ѿ             */
    VT_PLAY_STATE_READY,  /* Ѿʼ(ֹͣ״̬) */ 
}VT_PLAY_STATE;

/* image size */
typedef enum
{
    IMG_UXGA    = ( (1600<<16) | 1200 ),        /* 1600 x1200 */
    IMG_SXGA     = ( (1280<<16) | 960 ),          /* 1280x960 */
    IMG_VGA       = ( (640<<16) | 480 ),             /* 640x480 */
    IMG_QVGA    = ( (320<<16) | 240 ),             /* 320x240 */
    IMG_QQVGA = ( (160<<16) | 120 ),             /* 160x120 */
    IMG_CIF         = ( (352<<16) | 288 ),             /* 352x288 */
    IMG_QCIF      = ( (176<<16) | 144 ),             /* 176x144 */
    IMG_QQCIF   = ( (88<<16) | 72 ),                  /* 88x72 */

    MAX_IMG_SIZE
} T_ZDrv_ImgSize;

/* encoding quality */
typedef enum
{
    VIDEO_QUALITY_ECONOMY,
    VIDEO_QUALITY_NORMAL,
    VIDEO_QUALITY_FINE,
    VIDEO_QUALITY_SUPERFINE,

    MAX_VIDEO_QUALITY_TYPE
} T_ZDrvVideo_QualityType;

typedef enum
{
    VIDEO_CODEC_STD_NOVIDEO_Ex,
    VIDEO_CODEC_STD_MPEG4_Ex,
    VIDEO_CODEC_STD_H263_Ex,
    VIDEO_CODEC_STD_AVC_Ex,
    VIDEO_CODEC_STD_MJPEG_Ex,
    
    MAX_VIDEO_CODEC_STD_Ex
} T_ZDrvVideo_CodecStandardEx;

/*  */
typedef enum{
    ZMMF_CODEC_DECODE_TYPE_AMR    = 0x1101, 
    ZMMF_CODEC_DECODE_TYPE_H263   = 0x1201,
    ZMMF_CODEC_ENCODE_TYPE_AMR    = 0x1301,
    ZMMF_CODEC_ENCODE_TYPE_H263   = 0x1401,
    ZMMF_CODEC_DEMUX_TYPE_3GP     = 0x3601,
    ZMMF_CODEC_VT_VIDEO_TYPE,
    ZMMF_CODEC_VT_AUDIO_TYPE
} T_ZMmf_CodecType;

/* ӵ绰*/
typedef enum
{
    ZMMF_VT_OPT_OUTPUTPATH = 300,  /* Ƶͨ   T_ZMmf_OutputPath */
    ZMMF_VT_OPT_INPUTPATH,         /* Ƶ       T_ZMmf_OutputVolLevel */
    ZMMF_VT_OPT_OUTPUTVOL,
    ZMMF_VT_OPT_INPUTVOL,
    ZMMF_VT_OPT_DISRECT,           /* ӵ绰ʾλ T_ZMmf_VTDisRect */    
    ZMMF_VT_OPT_LCDDSPRECT,        /* Ƶʾλ   T_ZMmf_DisplayRect */
    ZMMF_VT_OPT_CAMRECT,           /* camʾλ    T_ZMmf_DisplayRect */
    ZMMF_VT_OPT_CAMEFFECT,
    ZMMF_VT_OPT_CAMROTATE
} T_ZMmf_VtPropOpt;

/* encode parameters when video telophoning */
typedef struct
{
    T_ZDrvVideo_CodecStandardEx     tVideoType;       /* condec standard of output video data */
    T_ZDrv_ImgSize                  tImgSize;         /* output image size */
    T_ZDrvVideo_QualityType         tQuality;         /* encodec quality factor */
    UINT32                          uiFrameRate;      /* frame rate */
    UINT32                          uiBitrate;        /* bit rate*/
    UINT32                          uiIFrmInterval;   /* interval between I-frame */
    BOOL                            bResync;          /* re-synchronize if TRUE */
    BOOL                            bDataPart;        /* data part if TRUE  */
    BOOL                            bReverseVlc;      /* reverse vlc if TRUE */
    BOOL                            bShortHeader;     /* short header if TRUE */
} T_ZDrvVideo_VTEncParam;

/* decode parameters when video telophoning */
typedef struct
{
    T_ZDrvVideo_CodecStandardEx   tVideoType;     /* codec standard of input video data */
    T_ZDrv_ImgSize                tImgSize;       /* input image size */
    BOOL                          bShortHeader;   /* short header if TRUE */
    BOOL                          bMp4PostFilter;
} T_ZDrvVideo_VTDecParam;

/* parameters when video telophoning */
typedef struct
{
    T_ZDrvVideo_VTEncParam      tEncParam;      /* encode parameters when video telephoning */
    T_ZDrvVideo_VTDecParam      tDecParam;     /* decode parameters when video telephoning */
} T_ZDrvVideo_VTParam;

typedef struct
{
    BOOL                 bInit;
    T_ZDrvVideo_VTParam  tVtParam;    
}T_ZMmf_VTParam;

/* ӵ绰ʾ */
typedef struct
{
    struct
    {
        UINT32   uiXpos;
        UINT32   uiYpos;
        UINT32   uiWidth;
        UINT32   uiHeight;
    }tLocalRect;
    struct
    {
        UINT32   uiXpos;
        UINT32   uiYpos;
        UINT32   uiWidth;
        UINT32   uiHeight;
    }tRemoteRect;
}T_ZMmf_VTDisRect;

/**************************************************************************
 *                           ȫֱ                                      *
 **************************************************************************/
static VT_PLAY_STATE         g_zMmfVtState = VT_PLAY_STATE_IDLE;
static T_ZMmf_VTParam        tzMmfVTEncDecParam;
static VT_VIDEO_DISPARAM_T   tzMmfVTDisParam;
 
/**************************************************************************
 *                           ֲԭ                                  *
 **************************************************************************/
static SINT32 zMmfVT_VideoChip_Start(VOID); 

static SINT32 zMmfVT_VideoChip_Stop(VOID);
 
static SINT32 zMmfVT_AudioChip_Start(VOID);

static SINT32 zMmfVT_AudioChip_Stop(VOID);
/**************************************************************************
 *                ʵ--в֣CԵͷļɲü           *
 **************************************************************************/
extern SINT32 tp_comm_channel_post_msg(const CHAR* channel_name,UINT32 uiMsgId,const VOID* pMsgData,UINT32 uiMsgSize);

/**************************************************************************
 *                ʵ--֣CԵͷļɲü           *
 **************************************************************************/

/**************************************************************************
 *                ʵ--˽в֣CԵͷļɲü           *
 **************************************************************************/

/**************************************************************************
 *                     ȫֺʵ                                      *
 **************************************************************************/
/*******************************************************************
* ƣ  zMmf_VtOpen
*   ӵ绰ųʼ
* ˵  (IN)pOperType"ZMMF_MEDIA_ID_VT"
*                 iMediaSrcZMMF_MEDIASOURCE_VT_AUDIO
*                            ZMMF_MEDIASOURCE_VT_VIDEO
*                            ZMMF_MEDIASOURCE_VT_ALL
*                 iMmcId:MMC IDʶûò-1;
*                 iChannelId: ͨ
*             (OUT)
*   ֵ  ɹMMC IDʶʧܷظֵýӿΪӿڣ
* ˵:   
*******************************************************************/
SINT32 zMmf_VtOpen(const CHAR *pOperType,T_ZMmf_MediaSource iMediaSrc, SINT32 iMmcId, SINT32 iChannelId)
{
    if(NULL == pOperType 
       || strcmp((const char *)pOperType, ZMMF_OPER_TYPE_VT)
       || iMediaSrc != ZMMF_MEDIASOURCE_VT_ALL)
    {
        zMspCom_Print();
        
        return ZMMF_FAILED;
    }

    /* ״̬ */
    if(g_zMmfVtState != VT_PLAY_STATE_IDLE)
    {
        zMspCom_Print();
        
        return ZMMF_FAILED;
    }
    
	/* ȫֱ */
    zOss_Memset(&tzMmfVTDisParam,    0, sizeof(VT_VIDEO_DISPARAM_T));
    zOss_Memset(&tzMmfVTEncDecParam, 0, sizeof(T_ZMmf_VTParam));
    g_zMmfVtState = VT_PLAY_STATE_OPEN;
    
    return 0;
}

/*******************************************************************
* ƣ  zMmf_VtPlay
*   ӵ绰ʼӿ
* ˵  (IN)iHandle:MMFž
*                 iMediaSrc:ýԴͣƵ/Ƶ
*             (OUT)
*   ֵ  ZMMF_SUCCESSɹ
*             ZMMF_FAILED쳣
* ˵:  
*******************************************************************/
SINT32 zMmf_VtPlay(UINT32 iHandle,T_ZMmf_MediaSource iMediaSrc)
{
    SINT32 iRet = -1;
    
    if(iHandle != 0
       || g_zMmfVtState != VT_PLAY_STATE_OPEN)
    {
        zMspCom_Print();
        
        return ZMMF_FAILED;
    }

    /*  */
    iRet = zMmfVT_AudioChip_Start();
    if(iRet != ZMMF_SUCCESS)
    {
        zMspCom_Print();
        
        return ZMMF_FAILED;
    }
    
    /* Ƶ */
    iRet = zMmfVT_VideoChip_Start();
    if(iRet != ZMMF_SUCCESS)
    {
        zMmfVT_AudioChip_Stop();
        zMspCom_Print();
        
        return ZMMF_FAILED;
    }    

    /* 95TMMIҪϢͨ棬ӴϢķ */
    tp_comm_channel_post_msg(NULL, TPM_CALL_VP_OPEN_DEVICE_IND, NULL, 0);    

    /* ״̬Ǩ */
    g_zMmfVtState = VT_PLAY_STATE_READY;

    return ZMMF_SUCCESS;
}

/*******************************************************************
* ƣ  zMmf_VtStop
*   ӵ绰ֹͣӿ
* ˵  (IN)iHandle:MMFž
*                 iMediaSrc:ýԴ
*             (OUT)
*   ֵ  ZMMF_SUCCESSɹ
*             ZMMF_FAILED쳣
* ˵:  
*******************************************************************/
SINT32 zMmf_VtStop(UINT32 iHandle,T_ZMmf_MediaSource iMediaSrc)
{
    SINT32 iRet1 = -1;
    SINT32 iRet2 = -1;
    
    if(iHandle != 0
       || g_zMmfVtState != VT_PLAY_STATE_READY)
    {
        zMspCom_Print();
        
        return ZMMF_FAILED;
    }

    iRet1 = zMmfVT_AudioChip_Stop();
    iRet2 = zMmfVT_VideoChip_Stop();

    g_zMmfVtState = VT_PLAY_STATE_OPEN;
    if(iRet1 != ZMMF_SUCCESS || iRet2 != ZMMF_SUCCESS)
    {
        zMspCom_Print();
        
        return ZMMF_FAILED;
    }

    return ZMMF_SUCCESS;
}

/*******************************************************************
* ƣ zMmf_VtClose
*  ӵ绰Źر
* ˵(IN)iHandle:MMFž
*               iMediaSrc:ýԴ
*           (OUT)
*   ֵZMMF_SUCCESSɹ
*           ZMMF_FAILED쳣
* ˵  
*******************************************************************/
SINT32 zMmf_VtClose(UINT32 iHandle,T_ZMmf_MediaSource iMediaSrc)
{
    if(g_zMmfVtState != VT_PLAY_STATE_OPEN)
    {
        zMspCom_Print();
        
        return ZMMF_FAILED;
    }

    g_zMmfVtState = VT_PLAY_STATE_IDLE;

    return ZMMF_SUCCESS;
}

/*******************************************************************
* ƣ  zMmf_VtSetOpt
*   ӵ绰ò
* ˵  (IN)iHandle  MMFž
*                iOptTypeT_ZMmf_VtPropOpt
*                iMediaSrc:ýԴ
*                pOption:ò
*                iOptionSizeС
*   ֵ ZMMF_SUCCESSɹ
*            ZMMF_FAILED쳣
* ˵: 
*******************************************************************/
SINT32 zMmf_VtSetOpt(UINT32 iHandle, T_ZMmf_VtPropOpt iOptType, T_ZMmf_MediaSource iMediaSrc, VOID *pOption, UINT32 iOptionSize)
{
    T_ZMmf_VTDisRect        *pDisRect = NULL;
    DCAMERA_RETURN_VALUE_E   eRet;
    
    if(iHandle != 0
       || VT_PLAY_STATE_IDLE == g_zMmfVtState
       || iOptType != ZMMF_VT_OPT_DISRECT
       || iMediaSrc != ZMMF_MEDIASOURCE_VT_VIDEO
       || iOptionSize != sizeof(T_ZMmf_VTDisRect)
       || NULL == pOption)
    {
        zMspCom_Print();

        return ZMMF_FAILED;
    }

    pDisRect = (T_ZMmf_VTDisRect *)pOption;

    if(pDisRect != NULL)
    {
        tzMmfVTDisParam.tLocalRect.sx      = pDisRect->tLocalRect.uiXpos;
        tzMmfVTDisParam.tLocalRect.sy      = pDisRect->tLocalRect.uiYpos;
        tzMmfVTDisParam.tLocalRect.width   = pDisRect->tLocalRect.uiWidth;
        tzMmfVTDisParam.tLocalRect.height  = pDisRect->tLocalRect.uiHeight;
        tzMmfVTDisParam.tRemoteRect.sx     = pDisRect->tRemoteRect.uiXpos;
        tzMmfVTDisParam.tRemoteRect.sy     = pDisRect->tRemoteRect.uiYpos;
        tzMmfVTDisParam.tRemoteRect.width  = pDisRect->tRemoteRect.uiWidth;
        tzMmfVTDisParam.tRemoteRect.height = pDisRect->tRemoteRect.uiHeight;
    }

    if(VT_PLAY_STATE_READY == g_zMmfVtState)
    {
        eRet = VT_Video_SetDisplayParam(&tzMmfVTDisParam);
        if(eRet != DCAMERA_OP_SUCCESS)
        {
            return ZMMF_FAILED;
        }
    }
            
    return ZMMF_SUCCESS;
}

/*******************************************************************
* ƣ  zMmf_VtSetCodec
*   ӵ绰ñ
* ˵  (IN)iHandle:MMFž
*                iMediaSrcýԴ
*                iCodecType:T_ZMmf_CodecType
*                pInitParam:ò
*   ֵ ZMMF_SUCCESSɹ
*            ZMMF_FAILED쳣
* ˵:ýӿΪӿ
*******************************************************************/
SINT32 zMmf_VtSetCodec(UINT32 iHandle, T_ZMmf_MediaSource iMediaSrc,T_ZMmf_CodecType iCodecType, VOID* pInitParam)
{
    T_ZDrvVideo_VTParam *pVTEncDecParam = NULL;
    
    if(iHandle != 0
       || VT_PLAY_STATE_IDLE == g_zMmfVtState
       || NULL == pInitParam)
    {
        zMspCom_Print();
        
        return ZMMF_FAILED;
    }

    pVTEncDecParam = (T_ZDrvVideo_VTParam *)pInitParam;
    tzMmfVTEncDecParam.bInit    = TRUE;
    tzMmfVTEncDecParam.tVtParam = *pVTEncDecParam;
    
    return ZMMF_SUCCESS;
}

/*******************************************************************
* ƣ  zMmf_VtWrite
*   ӵ绰ݲ
* ˵  (IN)iHandleMMFž
*                 pBuf:ݻ
*                 iSize:ݴС
*                 iMediaSrc:ýT_ZMmf_MediaSource
*                 iTimeStampʱЧ
*   ֵ дֵֽʾʧܣ
* ˵:ƵÿαΪһ֡֡ͷAMR IF2ʽƵ֧ⳤȣh.263mpeg4ʽ
*******************************************************************/
SINT32 zMmf_VtWrite(UINT32 iHandle, CHAR *pBuf, SINT32 iSize,T_ZMmf_MediaSource iMediaSrc, UINT32 iTimeStamp)
{
    SINT32 iRet = -1;
    
    if(g_zMmfVtState != VT_PLAY_STATE_READY)
    {
        zMspCom_Print();

        return ZMMF_FAILED;
    }

    if(ZMMF_MEDIASOURCE_VT_AUDIO == iMediaSrc)
    {
        iRet = VT_Voice_Write(pBuf, iSize);
    }
    else if(ZMMF_MEDIASOURCE_VT_VIDEO == iMediaSrc)
    {
        iRet = VT_Video_Write(pBuf, iSize);
    }
    else
    {
        zMspCom_Print();
    }
    
    return iRet;    
}

/*******************************************************************
* ƣ  zMmf_VtRead
*   ӵ绰ݽӿ
* ˵  (IN)iHandleMMFž
*                 pBuf:ݻ
*                 iSize ݴС
*                 iMediaSrc:ýԴ
*                 iTimeStampʱЧ
*   ֵ ֵֽʾʧ
* ˵: ƵʱpBufĿռ31ֽ
*******************************************************************/
SINT32 zMmf_VtRead(UINT32 iHandle, CHAR *pBuf, SINT32 iSize, T_ZMmf_MediaSource iMediaSrc, UINT32 iTimeStamp)
{
    SINT32 iRet = -1;
    
    if(g_zMmfVtState != VT_PLAY_STATE_READY)
    {
        zMspCom_Print();

        return ZMMF_FAILED;
    }

    if(ZMMF_MEDIASOURCE_VT_AUDIO == iMediaSrc)
    {
        iRet = VT_Voice_Read(pBuf, iSize);
    }
    else if(ZMMF_MEDIASOURCE_VT_VIDEO == iMediaSrc)
    {
        iRet = VT_Video_Read(pBuf, iSize);
    }    
    else
    {
        zMspCom_Print();
    }    

    return iRet;    
}
 
/*******************************************************************
* ƣtp_man_mm_preview_SetSubLightness
* ͷ
* ˵(IN)LightnessLevelֵ
*   ֵʧܷظֵ
* ˵: 
*******************************************************************/
SINT32 tp_man_mm_preview_SetSubLightness(UINT8 LightnessLevel)
{
    SINT32                   iRet = -1;
    T_MSP_BRIGHTNESS_LEVEL   eBrightness;

    eBrightness = (T_MSP_BRIGHTNESS_LEVEL)LightnessLevel;
    iRet        = zMspCom_SetBrightness(eBrightness);
    
    return iRet;
}

/*******************************************************************
* ƣtp_man_mm_preview_SetLightness
* ͷ
* ˵(IN)LightnessLevelֵ
*   ֵʧܷظֵ
* ˵: 
*******************************************************************/
SINT32 tp_man_mm_preview_SetLightness(UINT8 LightnessLevel)
{
    SINT32                   iRet = -1;
    T_MSP_BRIGHTNESS_LEVEL   eBrightness;

    eBrightness = (T_MSP_BRIGHTNESS_LEVEL)LightnessLevel;
    iRet        = zMspCom_SetBrightness(eBrightness);
    
    return iRet;
}

/*******************************************************************
* ƣtp_man_mm_preview_SetSubContrast
* ͷöԱȶ
* ˵(IN)ContrastLevelԱȶֵ
*   ֵʧܷظֵ
* ˵: 
*******************************************************************/
SINT32 tp_man_mm_preview_SetSubContrast(UINT8 ContrastLevel)
{
    SINT32               iRet = -1;
    T_MSP_CONTRAST_LEVEL eContrast;

    eContrast = (T_MSP_CONTRAST_LEVEL)ContrastLevel;
    iRet      = zMspCom_SetContrast(eContrast);

    return iRet;
}

/*******************************************************************
* ƣtp_man_mm_preview_SetContrast
* ͷöԱȶ
* ˵(IN)ContrastLevelԱȶֵ
*   ֵʧܷظֵ
* ˵: 
*******************************************************************/
SINT32 tp_man_mm_preview_SetContrast(UINT8 ContrastLevel)
{
    SINT32               iRet = -1;
    T_MSP_CONTRAST_LEVEL eContrast;

    eContrast = (T_MSP_CONTRAST_LEVEL)ContrastLevel;
    iRet      = zMspCom_SetContrast(eContrast);

    return iRet;
}

/**************************************************************************
 *                      ֲʵ                                      *
 **************************************************************************/
/*******************************************************************
* ƣ  zMmfVT_VideoChip_Start
*   ӵ绰Ƶ
* ˵ 
* ˵: 
*******************************************************************/ 
static SINT32 zMmfVT_VideoChip_Start(VOID)
{
    VT_VIDEO_PARAM_T        tVideoParam;
    DCAMERA_RETURN_VALUE_E  eRet = DCAMERA_OP_ERROR;
    
    eRet = VT_Video_Open();
    if(eRet != DCAMERA_OP_SUCCESS)
    {
        zMspCom_Print();
        
        return ZMMF_FAILED;
    }
    
    if(0 == tzMmfVTDisParam.tLocalRect.width 
       && 0 == tzMmfVTDisParam.tRemoteRect.width)
    {
        tzMmfVTDisParam.tLocalRect.sx      = 0;
        tzMmfVTDisParam.tLocalRect.sy      = 240;
        tzMmfVTDisParam.tLocalRect.width   = 64;
        tzMmfVTDisParam.tLocalRect.height  = 48;
        tzMmfVTDisParam.tRemoteRect.sx     = 64;
        tzMmfVTDisParam.tRemoteRect.sy     = 80;
        tzMmfVTDisParam.tRemoteRect.width  = 176;
        tzMmfVTDisParam.tRemoteRect.height = 144;
    }    

    /* 趨Ƶʾ */
    tVideoParam.tDisParam             = tzMmfVTDisParam;
    tVideoParam.tEncParam.uiWidth     = 176;
    tVideoParam.tEncParam.uiHeight    = 144;
    tVideoParam.tEncParam.uiBitrate   = 36;  /* 3GƵҵһ48kbps */
    tVideoParam.tEncParam.uiFramerate = 15;
    tVideoParam.tDecParam.uiWidth     = 176;
    tVideoParam.tDecParam.uiHeight    = 144;
    
    if(!tzMmfVTEncDecParam.bInit)
    {
        /* Ĭֵ*/        
        tVideoParam.tEncParam.tVideoFormat       = VT_VIDEO_H263;

        tVideoParam.tDecParam.tVideoFormat       = VT_VIDEO_H263;
    }
    else
    {
        T_ZDrvVideo_VTParam *pVTParam = NULL;

        pVTParam = &tzMmfVTEncDecParam.tVtParam;
        
        if(1 == pVTParam->tEncParam.bShortHeader
           || VIDEO_CODEC_STD_H263 == pVTParam->tEncParam.tVideoType)
        {
            tVideoParam.tEncParam.tVideoFormat = VT_VIDEO_H263;
            tVideoParam.tDecParam.tVideoFormat = VT_VIDEO_H263;
        }
        else
        {
            tVideoParam.tEncParam.tVideoFormat = VT_VIDEO_MP4;
            tVideoParam.tDecParam.tVideoFormat = VT_VIDEO_MP4;
        }
    }

    eRet = VT_Video_Init(&tVideoParam);
    if(eRet != DCAMERA_OP_SUCCESS)
    {
        zMspCom_Print();
        
        return ZMMF_FAILED;
    }

    return ZMMF_SUCCESS;
}

/*******************************************************************
* ƣ  zMmfVT_VideoChip_Stop
*   ӵ绰رƵ
* ˵ 
* ˵: 
*******************************************************************/ 
static SINT32 zMmfVT_VideoChip_Stop(VOID)
{
    DCAMERA_RETURN_VALUE_E eRet1;
	DCAMERA_RETURN_VALUE_E eRet2;
    
    eRet1 = VT_Video_Release();
    eRet2 = VT_Video_Close();
    zOss_Memset(&tzMmfVTDisParam, 0, sizeof(VT_VIDEO_DISPARAM_T));    
    if(eRet1 != DCAMERA_OP_SUCCESS || eRet2 != DCAMERA_OP_SUCCESS)
    {
        zMspCom_Print();
        
        return ZMMF_FAILED;
    }    

    return ZMMF_SUCCESS;
}

/*******************************************************************
* ƣ  zMmfVT_AudioChip_Start
*   ӵ绰Ƶ
* ˵ 
* ˵: 
*******************************************************************/ 
static SINT32 zMmfVT_AudioChip_Start(VOID)
{
    VT_VOICE_PARAM_T        tVoiceParam;
    DCAMERA_RETURN_VALUE_E  eRet;

    eRet = VT_Voice_Open(0); 
    if(eRet != DCAMERA_OP_SUCCESS)
    {
        zMspCom_Print();
        
        return ZMMF_FAILED;
    }    
    
    tVoiceParam.tVoiceInfo.amrif     = VT_VOICE_AMR_IF2;
    tVoiceParam.tVoiceInfo.frametype = VT_VOICE_FRAME_MR122;

    eRet = VT_Voice_Init(&tVoiceParam);
    if(eRet != DCAMERA_OP_SUCCESS)
    {
        zMspCom_Print();
        
        return ZMMF_FAILED;
    }
    
    return ZMMF_SUCCESS;
}

/*******************************************************************
* ƣ  zMmfVT_AudioChip_Stop
*   ӵ绰رƵ
* ˵ 
* ˵: 
*******************************************************************/ 
static SINT32 zMmfVT_AudioChip_Stop(VOID)
{
    DCAMERA_RETURN_VALUE_E eRet1;
    DCAMERA_RETURN_VALUE_E eRet2;
	
    eRet1 = VT_Voice_Release();
    eRet2 = VT_Voice_Close();
    if(eRet1 != DCAMERA_OP_SUCCESS || eRet2 != DCAMERA_OP_SUCCESS)
    {
        zMspCom_Print();
        
        return ZMMF_FAILED;
    } 

    return ZMMF_SUCCESS;
}

