/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : P98C_WINAPI
*    : win_kernel.c
* ļ : 
* ʵֹ : osa for windows ʵļ
*      : xuxingkui
*      : V1.0
*  : 2007-05-28
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* ޸ı : 0001
*    : wuzhengjun
* ޸ : 2012-09-17
* ޸ : ʽ淶PC-LINT߲  EC:617001781798
**************************************************************************/
/**************************************************************************
* ޸ı : 0002
*    : wuzhengjun
* ޸ : 2012-09-27
* ޸ : ߲   EC:617001781846 
**************************************************************************/
/**************************************************************************
* #include
**************************************************************************/
#include "oss_api.h"
#include "osa.h"
#include "win_typedef.h"
#include "sup.h"

#ifdef __cplusplus
extern "C"
{
#endif
    
/*************************************************************************
*                           궨                                       *
**************************************************************************/
#define THREAD_MSG_HEAD_SIZE        sizeof(T_THREAD_MSG_HEAD)
#define THREAD_MSG_HEAD(buf)        (T_THREAD_MSG_HEAD *)((UINT8 *)(buf) - THREAD_MSG_HEAD_SIZE)
#define THREAD_MSG_BUF(head)        (VOID *)((UINT8 *)(head) + THREAD_MSG_HEAD_SIZE)
#define THREAD_MSG_SIZE(size)       ((size) + THREAD_MSG_HEAD_SIZE)

#define THREAD_MSG_MAGIC            0x3A3A3A3A

#define THREAD_MSG_HOOK_TYPE_MAX    ZOSS_SETHOOKFLAG_INTER
#define THREAD_MSG_HOOK_DIRE_MAX    ZOSS_MSGDIRE_INOUT

/**************************************************************************
* ݽṹ
**************************************************************************/
typedef struct
{
    UINT32      id;
    UINT32      buf_size;
    UINT32      magic;
} T_THREAD_MSG_HEAD;

typedef struct
{
    T_ZOss_Node     Node;                           /*  λòܸı            */
    ZOSS_THREAD_ID  thread_id;
    UINT8           dire[THREAD_MSG_HOOK_TYPE_MAX]; /* 0: ZOSS_SETHOOKFLAG_MONI=1   */
    THREAD_MSG_HOOK func[THREAD_MSG_HOOK_TYPE_MAX]; /* 0: ZOSS_SETHOOKFLAG_MONI=1   */
} THREAD_MSG_HOOK_CONTENT;

/**************************************************************************
* ֲԭ
**************************************************************************/
UINT32 OSA_IdentifyThread(ZOSS_THREAD_ID threadID);
static VOID OSA_DefaultEntry(SINT32 arg);
static ThreadContext *OSA_GetThreadContext(SINT32 thread_real_id);
static THREAD_MSG_HOOK_CONTENT* find_thread_content(ZOSS_THREAD_ID thread_id);
static BOOL is_sender_task(VOID *sender);
static UINT32 proc_thread_msg_hook(UINT32 dire, UINT32 msg_id, VOID *p_buf, UINT16 buf_size, ZOSS_THREAD_ID thread_id);
static UINT32 proc_task_msg_hook(UINT32 dire, UINT32 msg_id, VOID *p_buf, UINT16 buf_size, ZOSS_TASK_ID task_id);
static UINT32 proc_msg_hook(UINT32 msg_id, VOID *p_buf, UINT16 buf_size, ZOSS_THREAD_ID d_thread_id);

/**************************************************************************
* ȫֳ/
**************************************************************************/
/* ߳ */
static T_ZOss_List      gThreadList             = {0};
static ZOSS_MUTEX_ID    gThreadListMutex        = NULL;

/* 㵱ǰ̵߳Ŀ */  
static   UINT32         gThreadCount            = 0;
static T_OSA_PARAM      *gpOsa_Param            = NULL;     /* ȼӳ           */
static ZOSS_TASK_ID     *gOsa_AllTaskIdArray    = NULL;
static T_ZOss_List      s_thread_msg_hook_list  = {0};
UINT32                  gOsa_SysCpuFreq         = 1000;
BOOL                    gOsa_SwapTimeFlag       = FALSE;    /* ߳л¼cpuʱ־  */

/**************************************************************************
* ȫֺʵ
**************************************************************************/
/**************************************************************************
* ƣ OSA_Init
*  OSA ģʼ
* ˵ (IN)
             (OUT)
*   ֵ ʼɹZOSS_SUCCESS,ʧܷZOSS_ERROR
* ˵ 
**************************************************************************/
UINT32 OSA_Init(VOID)
{
    static BOOL bInit       = TRUE;   /* ʼ־ */
    T_OSS_PARAM *pOssParam  = NULL;
    UINT32      nRet        = ZOSS_SUCCESS;

    if (bInit)
    {
        pOssParam = zOss_GetOssCfg();
        gpOsa_Param = &(pOssParam->OsaCfg);

        zOss_ListInit(&gThreadList);

        gThreadListMutex = zOss_CreateMutex("thread_list_mutex", ZOSS_INHERIT);

        if (NULL == gThreadListMutex)
        {
            return ZOSS_ERROR;
        }

        zOss_ListInit(&s_thread_msg_hook_list); /* Initialize Thread List Info,֧߳Ϣhook */

       /* ʧб */
       /* Initialize Mem */
        nRet = MEM_Init();
        if (nRet != ZOSS_SUCCESS)
        {
            zOss_RamLog("SysEntry: MEM_Init Fail, Code = 0x%x!", nRet);
            return nRet;
        }
        zOss_RamLog("SysEntry(%u): MEM_Init Start OK!", zOss_GetTickCount());
        bInit = FALSE;
        return ZOSS_SUCCESS;
    }
    else/* ѳʼ */
    {
        return ZOSS_ERROR;
    }
}

/*************************************************************************
*                             ߳̽ӿ
**************************************************************************/
/**************************************************************************
* :  zOss_GetprioCfg
* :  ȡȼֵ
* ˵:  offset ȡֵΪ0~31
*   ֵ:  ȷȼֵ󷵻ZOSS_ERROR
* ˵:  offset ȡֵΪ0~31
**************************************************************************/
UINT32 zOss_GetPrioCfg(UINT8 offset)
{
    zOss_AssertEx(offset <= 31, ZOSS_ERROR);

    zOss_AssertEx(NULL != gpOsa_Param, ZOSS_ERROR);     /* ȫֱгʼ */
    
    if (NULL != gpOsa_Param->pPrioMap)
    {
        return (*(gpOsa_Param->pPrioMap))[offset];
    }
    else
    {
        return (UINT32)(offset);
    }
}

/**************************************************************************
* ƣ zOss_CreateThread
*  ߳
* ˵ (IN)
             thread_name: ߳,󳤶ȲܳMAX_THREADNAME_LEN
             entry:       ̵߳ʵ庯,ZOSS_THREAD_FUN
             arg:         ߳ʵ庯Ĳ
             stack_size:  ջСλֽڣ
             priority:    ߳ȼ0-31, ֵԽȼԽ
             preempt:     ͬȼ߳Ƿռ,1 Ϊռ,
                          0ΪռֵΪռ
             auto_start:  ǷԶ,1 ΪԶ,0ΪԶ
                          ֵΪԶ
             (OUT)
*   ֵɹ߳IDʧܷZOSS_INVALID_THREAD_ID
* ˵ windowsµ˵
            1.߳ȼwindows·Ϊ7ȼ
              0-3;4-7;8-12;13-17;18-22;23-25;26-31;Χڵ
              ֵΪͬȼ;
            2.ռwindowsЧģ
**************************************************************************/
ZOSS_THREAD_ID zOss_CreateThread(const CHAR *thread_name,
                                 VOID       (*entry)(SINT32),
                                 SINT32     arg,
                                 UINT32     stack_size,
                                 UINT32     priority, 
                                 UINT32     preempt,
                                 UINT32     auto_start)
{
    ThreadContext   *tmpContext = NULL;
    int             winPriority = 0;
    UINT32          name_len    = 0;
    
    
    zOss_AssertEx((thread_name != NULL) && (entry != NULL) && (priority <= 31) && 0 < stack_size, ZOSS_INVALID_THREAD_ID);
    
    name_len = strlen(thread_name);
    zOss_AssertEx((name_len <= MAX_THREADNAME_LEN), ZOSS_INVALID_THREAD_ID);
    /* 鵱ǰ߳ĿǷѴﵽ */
    if (gThreadCount >= MAX_THREAD_NUM)
    {
        return ZOSS_INVALID_THREAD_ID;
    }

    /* һ߳ */
    tmpContext = (ThreadContext *)zOss_Malloc(sizeof(ThreadContext));
    if (tmpContext == NULL)
    {
        return ZOSS_INVALID_THREAD_ID;
    }

    zOss_Memset(tmpContext, 0, sizeof(ThreadContext));

    strcpy(tmpContext->thread_name, thread_name);
    tmpContext->priority    = priority;
    tmpContext->preempt     = preempt;
    tmpContext->auto_start  = auto_start;
    tmpContext->msgQueue    = (T_ZOss_Queue *)zOss_QueueCreate(thread_name, MAX_QUEUE_SIZE, sizeof(T_Osa_Signal)); /* Ϣ*/

    /* ʱֵ */
    tmpContext->ua.threadid = (ZOSS_THREAD_ID)tmpContext;
    strncpy(tmpContext->ua.threadname, thread_name, 16);
    tmpContext->ua.priority = (UINT8)priority;

    if (tmpContext->msgQueue  == NULL)
    {
        zOss_Free(tmpContext);
        return ZOSS_INVALID_THREAD_ID;
    }

    /* ߳ȼ */
    if ((priority <= 3))
    {
        winPriority = THREAD_PRIORITY_TIME_CRITICAL;
    }
    else if ((priority >= 4)&&(priority <= 7))
    {
        winPriority = THREAD_PRIORITY_HIGHEST;
    }
    else if ((priority >= 8)&&(priority <= 12))
    {
        winPriority = THREAD_PRIORITY_ABOVE_NORMAL ;
    }
    else if ((priority >= 13)&&(priority <= 17))
    {
        winPriority = THREAD_PRIORITY_NORMAL ;
    }
    else if ((priority >= 18)&&(priority <= 22))
    {
        winPriority = THREAD_PRIORITY_BELOW_NORMAL;
    }
    else if ((priority >= 22)&&(priority <= 26))
    {
        winPriority = THREAD_PRIORITY_LOWEST;
    }
    else if ((priority >= 27)&&(priority <= 31))
    {
        winPriority = THREAD_PRIORITY_IDLE;
    }

    tmpContext->ThreadEntry = entry;

    /* ߳ */
    tmpContext->thread_handle = CreateThread(NULL, stack_size, (LPTHREAD_START_ROUTINE)OSA_DefaultEntry,
                                              (LPVOID)arg, CREATE_SUSPENDED, (unsigned long *)&( tmpContext->thread_real_id ));

    if (NULL == tmpContext->thread_handle)
    {
        zOss_QueueDelete(tmpContext->msgQueue);
        zOss_Free(tmpContext);
        return ZOSS_INVALID_THREAD_ID;
    }

    /* ߳ȼ */
    SetThreadPriority(tmpContext->thread_handle, winPriority);
    /* ӵ߳б */
    zOss_GetMutex(gThreadListMutex, ZOSS_WAIT_FOREVER);
    zOss_ListAdd(&gThreadList, (T_ZOss_Node *)tmpContext);
    zOss_PutMutex(gThreadListMutex);

    /* ߳ǷԶĴ */
    if (auto_start)
    {
        ResumeThread(tmpContext->thread_handle);
    }

    gThreadCount++;

    return (ZOSS_THREAD_ID)tmpContext;
}

/**************************************************************************
* ƣ zOss_ThreadExit
*  ˳ǰ߳
* ˵ (IN)
             (OUT)
*   ֵ 
* ˵ 
**************************************************************************/
VOID zOss_ExitThread(VOID)
{
    ThreadContext *pThreadContext = NULL;

    pThreadContext = (ThreadContext *)zOss_GetCurThreadID();

    if (pThreadContext == NULL)
    {
        return;
    }

    /* ߳бƳ, ͷŸ߳ */
    zOss_GetMutex(gThreadListMutex, ZOSS_WAIT_FOREVER);
    zOss_ListDelete(&gThreadList, (T_ZOss_Node*)pThreadContext);
    zOss_PutMutex(gThreadListMutex);
    zOss_Free((VOID *)pThreadContext->msgQueue);
    zOss_Free((VOID *)pThreadContext);
    gThreadCount--;

    ExitThread(0);
}

/**************************************************************************
* ƣ zOss_SuspendThread
*  ߳
* ˵ (IN)
             thread_id:̵߳ID
             (OUT)
*   ֵ ɹZOSS_SUCCESSZOSS_ERROR
* ˵ 
**************************************************************************/
UINT32 zOss_SuspendThread(ZOSS_THREAD_ID thread_id)
{
    ThreadContext   *pThreadContext = NULL;
    DWORD           result          = 0;

    zOss_AssertEx(NULL != thread_id, ZOSS_ERROR);
    
    if (ZOSS_SUCCESS != OSA_IdentifyThread(thread_id))
    {
        return ZOSS_ERROR;
    }

    pThreadContext = (ThreadContext *)thread_id;

    /* ߳ */
    result = SuspendThread(pThreadContext->thread_handle);

    if (result == (DWORD)-1)
    {
        return ZOSS_ERROR;
    }
    else
    {
        return ZOSS_SUCCESS;
    }
}

/**************************************************************************
* ƣ zOss_ResumeThread
*  ָ߳
* ˵ (IN)
             thread_id: ̵ָ߳ID
             (OUT)
*   ֵ ɹZOSS_SUCCESS,ZOSS_ERROR
* ˵ 
**************************************************************************/
UINT32 zOss_ResumeThread(ZOSS_THREAD_ID thread_id)
{
    ThreadContext   *pThreadContext = NULL;
    DWORD           result          = 0;

    zOss_AssertEx(NULL != thread_id, ZOSS_ERROR);
    
    if (ZOSS_SUCCESS != OSA_IdentifyThread(thread_id))
    {
        return ZOSS_ERROR;
    }

    pThreadContext  = (ThreadContext *)thread_id;
    result          = ResumeThread(pThreadContext->thread_handle);

    if (result == (DWORD)-1)
    {
        return ZOSS_ERROR;
    }
    else
    {
        return ZOSS_SUCCESS;
    }
}

/**************************************************************************
* ƣ zOss_Sleep
*  ʹ߳˯һʱ
* ˵ (IN)
             time_in_ms: ߳˯ʱ,λΪ
             (OUT)
*   ֵ 
* ˵ 
**************************************************************************/
VOID zOss_Sleep(UINT32 time_in_ms)
{
    Sleep(time_in_ms);
}

/**************************************************************************
* ƣ zOss_DeleteThread
*  ɾ߳,ǿƹرе߳
* ˵ (IN)
             thread_id: Ҫɾ̵߳ID;
             (OUT)
*   ֵ ɹZOSS_SUCCESS,ʧܷZOSS_ERROR
* ˵ 
**************************************************************************/
UINT32 zOss_DeleteThread(ZOSS_THREAD_ID thread_id)
{
    ThreadContext   *pThreadContext = NULL;
    HANDLE          handle          = NULL;

    zOss_AssertEx(NULL != thread_id, ZOSS_ERROR);

    if (ZOSS_SUCCESS != OSA_IdentifyThread(thread_id))
    {
        return ZOSS_ERROR;
    }

    /* ɾ߳ǵǰ̵߳ zOss_ExitThread ɾ */
    if (thread_id == zOss_GetCurThreadID())
    {
        zOss_ExitThread();
        return ZOSS_SUCCESS;
    }

    pThreadContext  = (ThreadContext *)thread_id;
    handle          = pThreadContext->thread_handle;

    /* ߳ */
    if (0 != TerminateThread(handle, 0))
    {
        CloseHandle(handle);
        /* ߳бƳ, ͷŸ߳̿ƿ */
        zOss_GetMutex(gThreadListMutex, ZOSS_WAIT_FOREVER);
        zOss_ListDelete(&gThreadList, (T_ZOss_Node*)pThreadContext);
        zOss_PutMutex(gThreadListMutex);
        zOss_QueueDelete((VOID *)pThreadContext->msgQueue);
        zOss_Free((VOID *)pThreadContext);
        gThreadCount--;

        return ZOSS_SUCCESS;
    }
    else
    {
        return ZOSS_ERROR;
    }
}

/**************************************************************************
* ƣ zOss_GetCurThreadID
*  ȡǰ̵߳ID
* ˵ (IN)
             (OUT)
*   ֵ ǰ̵߳ID
* ˵ ʹzOss_CreateThreadӿڴ߳,
             ӿڻȡǰ߳ IDܳɹ,ʧ,NULL
**************************************************************************/
ZOSS_THREAD_ID zOss_GetCurThreadID(VOID)
{
    ThreadContext   *pThreadContext = NULL;
    SINT32          thread_real_id  = 0;

    thread_real_id  = (SINT32)GetCurrentThreadId();
    pThreadContext  = OSA_GetThreadContext(thread_real_id);

    return (ZOSS_THREAD_ID)pThreadContext;
}

/**************************************************************************
* ƣ zOss_GetThreadIDByName
*  ߳ƻȡ߳ID
* ˵ (IN)
             thread_name: ߳
             (OUT)
*   ֵ ̵߳ID
* ˵ 
**************************************************************************/
ZOSS_THREAD_ID zOss_GetThreadIDByName (const CHAR *thread_name)
{
    T_ZOss_Node     *pCurNode   = NULL;
    ThreadContext   *pCurThread = NULL;

    zOss_AssertEx(NULL != thread_name, ZOSS_INVALID_THREAD_ID);
    
    zOss_GetMutex(gThreadListMutex, ZOSS_WAIT_FOREVER);
    pCurNode = zOss_ListFirst(&gThreadList);

    while (pCurNode != NULL)
    {
        pCurThread = (ThreadContext *)pCurNode;

        if (strcmp(pCurThread->thread_name, thread_name) == 0)
        {
            zOss_PutMutex(gThreadListMutex);
            return (ZOSS_THREAD_ID)pCurThread;
        }

        pCurNode = zOss_ListNext(pCurNode);
    }

    zOss_PutMutex(gThreadListMutex);

    return ZOSS_INVALID_THREAD_ID;
}

/**************************************************************************
* ƣ zOss_GetThreadInfo
*  ߳IDȡ߳ϸϢ
* ˵ (IN)
             thread_id:    ߳ID
             (OUT)
             thread_name:  ָ߳,ûռ,Ϊ
             stat:         ̵߳״̬,Ϊ
             priority:     ̵߳ȼΪ
             preempt:      ʾǰ߳ǷͬȼռΪ
*   ֵ ɹZOSS_SUCCESS,ʧܷZOSS_ERROR
* ˵ windowsƽ̨˵1.statЧ
**************************************************************************/
UINT32 zOss_GetThreadInfo(ZOSS_THREAD_ID thread_id,
                          CHAR           *thread_name,
                          UINT32         *state,
                          UINT32         *priority,
                          UINT32         *preempt)
{
    ThreadContext *pThreadContext = NULL;
    
    zOss_AssertEx(NULL != thread_id, ZOSS_ERROR);
    
    if (ZOSS_SUCCESS != OSA_IdentifyThread(thread_id))
    {
        return ZOSS_ERROR;
    }

    pThreadContext = (ThreadContext *)thread_id;

    if (thread_name != NULL)
    {
        strcpy(thread_name, pThreadContext->thread_name);
    }

    if (priority != NULL)
    {
        *priority = pThreadContext->priority;
    }

    if (preempt != NULL)
    {
        *preempt = pThreadContext->preempt;
    }

    if (state != NULL)
    {
        *state = ZOSS_OS_BLOCK;
    }

    return ZOSS_SUCCESS;
}


/**************************************************************************
* ƣ zOss_SetThreadPri
*  ߳ȼ
* ˵ (IN)
             thread_id: ߳ID
             priority:  ȼ,0-31,˵ZOSS_CreateThread˵
             (OUT)
*   ֵ ɹZOSS_SUCCESS,ʧܷZOSS_ERROR
* ˵ 
**************************************************************************/
UINT32 zOss_SetThreadPri(ZOSS_THREAD_ID thread_id, UINT32 priority)
{
    ThreadContext   *pThreadContext = NULL;
    SINT32          winPriority     = -1;

    zOss_AssertEx(NULL != thread_id && priority <= 31, ZOSS_ERROR);

    if (ZOSS_SUCCESS != OSA_IdentifyThread(thread_id))
    {
        return ZOSS_ERROR;
    }

    pThreadContext = (ThreadContext *)thread_id;

    /* ߳ȼ */
    if (priority <= 3)
    {
        winPriority = THREAD_PRIORITY_TIME_CRITICAL;
    }
    else if ((priority >= 4)&&(priority <= 7))
    {
        winPriority = THREAD_PRIORITY_HIGHEST;
    }
    else if ((priority >= 8)&&(priority <= 12))
    {
        winPriority = THREAD_PRIORITY_ABOVE_NORMAL;
    }
    else if ((priority >= 13)&&(priority <= 17))
    {
        winPriority = THREAD_PRIORITY_NORMAL ;
    }
    else if ((priority >= 18)&&(priority <= 22))
    {
        winPriority = THREAD_PRIORITY_BELOW_NORMAL;
    }
    else if ((priority >= 23)&&(priority <= 26))
    {
        winPriority = THREAD_PRIORITY_LOWEST;
    }
    else if ((priority >= 27)&&(priority <= 31))
    {
        winPriority = THREAD_PRIORITY_IDLE;
    }

    pThreadContext->priority = priority;

    if (0 != SetThreadPriority(pThreadContext->thread_handle, winPriority))
    {
        return ZOSS_SUCCESS;
    }
    else
    {
        return ZOSS_ERROR;
    }
}

/**************************************************************************
* ƣ zOss_GetThreadPri
*  ȡ߳ȼ
* ˵ (IN)
             thread_id: ߳ID
             (OUT)
             priority: õȼ
*   ֵ ɹZOSS_SUCCESS,ʧܷZOSS_ERROR
* ˵ 
**************************************************************************/
UINT32 zOss_GetThreadPri(ZOSS_THREAD_ID thread_id, UINT32 *priority)
{
    ThreadContext *pThreadContext = NULL;

    zOss_AssertEx(NULL != priority && NULL != thread_id, ZOSS_ERROR);
    
    if (ZOSS_SUCCESS != OSA_IdentifyThread(thread_id))
    {
        return ZOSS_ERROR;
    }

    pThreadContext  = (ThreadContext *)thread_id;
    *priority       = pThreadContext->priority;
    return ZOSS_SUCCESS;
}

/**************************************************************************
* :     ֤һ߳ǷЧ
* ˵:     
*   ()  thread_id:  ֤߳id
*   ()  void
*   ֵ:     ߳ЧZOSS_SUCCESSϵͳ
* ˵:     void
**************************************************************************/
UINT32 zOss_IdentifyThread(ZOSS_THREAD_ID threadID)
{
    return OSA_IdentifyThread(threadID);
}

/*****************************************************************************
*                               ϢͨѶ
******************************************************************************/
/*****************************************************************************
* ƣ zOss_SendMsg
*  Ϣ
* ˵ (IN)
             thread_id:  ߳ID
             msg_ptr:    Ϣַָ
             size:       ʵռֽ
             timeout:    Ϣ͵ȴʱ䣬λΪ,ʱ䵽,
                         ܷͳɹ񶼷.
                         ZOSS_NO_WAIT:Ϊܷͳɹ̷,
                         ZOSS_WAIT_FOREVER:һֱȴ,ֱͳ ŷ
*   ֵ ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR.
* ˵ 
*****************************************************************************/
UINT32 zOss_SendMsg(ZOSS_THREAD_ID thread_id, VOID *msg_ptr, UINT32 size, UINT32 timeout)
{
    UINT32          result      = 0 ;
    ThreadContext   *tmpContext = NULL;
    T_Osa_Signal    osasig      = {0};

    zOss_AssertEx(NULL != msg_ptr && NULL != thread_id, ZOSS_ERROR);
    
    if (ZOSS_SUCCESS != OSA_IdentifyThread(thread_id))
    {
        return ZOSS_ERROR;
    }

    tmpContext      = (ThreadContext *)thread_id;
    osasig.sig_no   = SIGNAL_MSG_NUMBER;                  /* sigalָתԶ ׼signal */
    osasig.msg_ptr  = msg_ptr;
    osasig.size     = size;                               /* ʵϢĳ */
    result          = zOss_QueueSend(tmpContext->msgQueue, &osasig, sizeof(T_Osa_Signal), timeout,
                                    ZOSS_QUEUE_MSG_PRI_NORMAL);
    return result;
}

/**************************************************************************
* ƣ zOss_RecvMsg
*  Ϣ
* ˵ (IN)
             msg_ptr: صϢָ
             size:    صϢС,λΪֽ
             timeout: յȴʱ,λΪ룬ʱ䵽,
                      ճɹ񶼷,
                      ZOSS_NO_WAIT:ܽճɹ̷,
                      ZOSS_WAIT_FOREVER:һֱȴ,ֱճɹŷ
*   ֵ ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR.
* ˵ 
**************************************************************************/
UINT32 zOss_RecvMsg(VOID**msg_ptr, UINT32 *size, UINT32 timeout)
{
    UINT32          result      = 0;
    T_Osa_Signal    osasig      = {0};
    ThreadContext   *tmpContext = NULL;

    zOss_AssertEx(NULL != msg_ptr && NULL != size, ZOSS_ERROR);
    
    tmpContext = (ThreadContext *)zOss_GetCurThreadID();

    if (tmpContext == NULL)
    {
        return ZOSS_ERROR;
    }

    result = zOss_QueueRecv(tmpContext->msgQueue, &osasig, sizeof(T_Osa_Signal), timeout);

    if (result == sizeof(T_Osa_Signal))
    {
        *msg_ptr    = osasig.msg_ptr;
        *size       = osasig.size;              /* ʵϢĳ */
        result      = ZOSS_SUCCESS;
    }
    else
    {
        result = ZOSS_ERROR;
    }

    return result;
}

VOID* zOss_ThreadGetMsgBuf(UINT32 size)
{
    T_THREAD_MSG_HEAD *p_msg_head = NULL;
    
    zOss_AssertEx(0 != size, NULL);
    
    p_msg_head = (T_THREAD_MSG_HEAD *)zOss_GetUB(THREAD_MSG_SIZE(size));
    zOss_AssertEx(NULL != p_msg_head, NULL);

    p_msg_head->magic = THREAD_MSG_MAGIC;

    return THREAD_MSG_BUF(p_msg_head);
}

VOID zOss_ThreadRetMsgBuf(VOID *p_buf)
{
    T_THREAD_MSG_HEAD   *p_msg_head = NULL;
    
    zOss_AssertExN(NULL != p_buf);
    p_msg_head = THREAD_MSG_HEAD(p_buf);
    zOss_RetUB(p_msg_head);
}

UINT32 zOss_ThreadSendMsg(UINT32 msg_id, VOID *p_buf, UINT16 buf_size, ZOSS_THREAD_ID thread_id)
{
    T_THREAD_MSG_HEAD   *p_msg_head = NULL;
    UINT32              ret         = 0;

    ret = OSA_IdentifyThread(thread_id);
    zOss_AssertEx(ret == ZOSS_SUCCESS, ZOSS_ERROR);

    if (ZOSS_SETHOOKFLAG_INTER == proc_msg_hook(msg_id, p_buf, buf_size, thread_id))
    {
        if (NULL != p_buf)
        {
            zOss_ThreadRetMsgBuf(p_buf);
        }
        return ZOSS_SUCCESS;
    }

    if ((NULL == p_buf) || (0 == buf_size))
    {
        buf_size = 0;   /* make sure the bufer size is zero */

        /* for emtpy message, buffer should be alloced by ourself */
        p_msg_head = (T_THREAD_MSG_HEAD *)zOss_GetUB(THREAD_MSG_SIZE(0));
        zOss_AssertEx(NULL != p_msg_head, ZOSS_ERROR);
        p_msg_head->magic   = THREAD_MSG_MAGIC;
    }
    else
    {
        p_msg_head = THREAD_MSG_HEAD(p_buf);
        zOss_AssertEx(THREAD_MSG_MAGIC == p_msg_head->magic, ZOSS_ERROR);
    }
    p_msg_head->id          = msg_id;
    p_msg_head->buf_size    = buf_size;

    ret = zOss_SendMsg(thread_id, p_msg_head, THREAD_MSG_SIZE(buf_size), ZOSS_WAIT_FOREVER);
    zOss_AssertEx(ZOSS_SUCCESS == ret, ZOSS_ERROR);

    return ZOSS_SUCCESS;
}

UINT32 zOss_ThreadRecvMsg(UINT32 *p_msg_id, VOID **p_buf, UINT32 *p_buf_size, UINT32 timeout)
{
    T_THREAD_MSG_HEAD   *p_msg_head = NULL;
    UINT32              msg_size    = 0;
    UINT32              ret         = 0;

    zOss_AssertEx((NULL != p_msg_id) && (NULL != p_buf) && (NULL != p_buf_size), ZOSS_ERROR);

    ret = zOss_RecvMsg((void **)&p_msg_head, &msg_size, timeout);
    zOss_AssertEx( ZOSS_SUCCESS == ret, ZOSS_ERROR);
    zOss_AssertEx( THREAD_MSG_MAGIC == p_msg_head->magic, ZOSS_ERROR);

    *p_msg_id   = p_msg_head->id;
    *p_buf_size = p_msg_head->buf_size;
    if (0 == p_msg_head->buf_size)
    {
        *p_buf  = NULL;
        /* for empty message, buffer is alloced by ourself */
        zOss_RetUB(p_msg_head);
    }
    else
    {
        *p_buf = THREAD_MSG_BUF(p_msg_head);
    }

    return ZOSS_SUCCESS;
}

UINT32 zOss_RegThreadMsgHook(ZOSS_THREAD_ID thread_id, UINT8 type, UINT8 dire, THREAD_MSG_HOOK func)
{
    THREAD_MSG_HOOK_CONTENT *p_content  = NULL;
    UINT32                  ret         = 0;

    ret = OSA_IdentifyThread(thread_id);
    zOss_AssertEx(((ZOSS_SUCCESS == ret) && (THREAD_MSG_HOOK_TYPE_MAX >= type)
                    && (THREAD_MSG_HOOK_DIRE_MAX >= dire) && (NULL != func)), ZOSS_ERROR);
    
    p_content = find_thread_content(thread_id);
    if (NULL == p_content)
    {
        p_content = (THREAD_MSG_HOOK_CONTENT *)zOss_Malloc( sizeof(THREAD_MSG_HOOK_CONTENT));
        zOss_Memset(p_content, 0, sizeof(THREAD_MSG_HOOK_CONTENT));
        p_content->thread_id = thread_id;
        zOss_ListAdd(&s_thread_msg_hook_list, (T_ZOss_Node *)p_content);
    }

    p_content->dire[type-1] = dire;
    p_content->func[type-1] = func;

    return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣ zOss_CreateSemaphore
*  ź
* ˵ (IN)
             name_ptr:      źַָ,ƳȲɳMAX_SEMNAME_LEN
             initial_count: źɹʵ
*   ֵ ɹؼźָ룻򣬷ZOSS_NULL
* ˵ 
**************************************************************************/
ZOSS_SEMAPHORE_ID zOss_CreateSemaphore(const CHAR *name_ptr, UINT32 initial_count)
{
    T_SemContext    *semContext = NULL;
    UINT32          name_len    = 0;

    if (name_ptr)
    {
        name_ptr = name_ptr;
    }
    
    semContext = (T_SemContext *)zOss_Malloc(sizeof(T_SemContext));

    if (NULL == semContext)
    {
        return NULL;
    }

    semContext->semID = CreateSemaphore(NULL, (SINT32)initial_count, MAX_SEM_CNTS,NULL);

    if (NULL == semContext->semID)
    {
        zOss_Free(semContext);
        semContext = NULL;
        return NULL;
    }

    semContext->semCount = (SINT32)initial_count;
    return (ZOSS_SEMAPHORE_ID)semContext;
}

/**************************************************************************
* ƣ zOss_GetSemaphore
*  ȡź
* ˵ (IN)
             sem_id:   ѾõļźID
             timeout:  ZOSS_NO_WAITʾܻȡǷɹ,
                       ZOSS_WAIT_FOREVERʾһֱȡź,ֱɹ
                       ȡźĵȴʱ,ʱ䵽,ܻȡɹ񶼷,
                       λ롣
*   ֵ ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR.
* ˵ 
**************************************************************************/
UINT32 zOss_GetSemaphore(ZOSS_SEMAPHORE_ID sem_id, UINT32 timeout)
{
    UINT32          dwWaitResult = 0;
    T_SemContext    *semContext  = NULL;

    zOss_AssertEx(NULL != sem_id, ZOSS_ERROR);
    
    semContext = (T_SemContext *)sem_id;

    if (timeout == ZOSS_NO_WAIT)
    {
        dwWaitResult = WaitForSingleObject(semContext->semID, 0);
    }
    else if (timeout == ZOSS_WAIT_FOREVER)
    {
        dwWaitResult = WaitForSingleObject(semContext->semID, INFINITE);
    }
    else
    {
        dwWaitResult = WaitForSingleObject(semContext->semID, timeout);
    }

    switch (dwWaitResult)
    {
        case WAIT_OBJECT_0:
        {
            semContext->semCount--;
            return ZOSS_SUCCESS;
        }
        case WAIT_TIMEOUT:
        {
            return ZOSS_ERROR;
        }
        case WAIT_ABANDONED:
        {
            return ZOSS_ERROR;
        }
        default:
        {
            return ZOSS_ERROR;
        }
    }
}

/**************************************************************************
* ƣ zOss_PutSemaphore
*  ͷź
* ˵ (IN)
             sem_id:ҪͷŵļźID
*   ֵ ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR.
* ˵ 
**************************************************************************/
UINT32 zOss_PutSemaphore(ZOSS_SEMAPHORE_ID sem_id)
{
    BOOL            result      = FALSE;
    T_SemContext    *semContext = NULL;

    zOss_AssertEx(NULL != sem_id, ZOSS_ERROR);
    
    semContext = (T_SemContext *)sem_id;
    semContext->semCount++;                                 /* ǰֵ+1         */
    result = ReleaseSemaphore(semContext->semID, 1, NULL);  /* ֵʱھ */

    if (result)
    {
        return ZOSS_SUCCESS;
    }
    else
    {
        semContext->semCount--; /* ԭǰֵ */
        return ZOSS_ERROR;
    }
}

/**************************************************************************
* ƣ zOss_DeleteSemaphore
*  ɾź
* ˵ (IN)
             sem_id:Ҫɾļź
*   ֵ ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR.
* ˵
**************************************************************************/
UINT32 zOss_DeleteSemaphore(ZOSS_SEMAPHORE_ID sem_id)
{
    T_SemContext    *semContext = NULL;
    BOOL            status      = FALSE;

    zOss_AssertEx(NULL != sem_id, ZOSS_ERROR);
    
    semContext  = (T_SemContext *) sem_id;
    status      = CloseHandle(semContext->semID);

    if (TRUE == status)
    {
        zOss_Free(sem_id);
        return ZOSS_SUCCESS;
    }
    else
    {
        return ZOSS_ERROR;
    }
}

/**************************************************************************
* :  zOss_GetSemaphoreCount
* : ȡźֵ
* ˵: (IN)
            sem_id:źID
*   ֵ: ɹ, صǰֵ; 򷵻ZOSS_ERROR
* ˵:
**************************************************************************/
UINT32 zOss_GetSemaphoreCount(ZOSS_SEMAPHORE_ID sem_id)
{
    T_SemContext    *semContext = NULL;
    UINT32          semCount    = 0;
    BOOL            result      = FALSE;
    DWORD           dwFlags     = 0;

    zOss_AssertEx(NULL != sem_id, ZOSS_ERROR);
    
    semContext  = (T_SemContext *)sem_id;
    result      = GetHandleInformation(semContext->semID, &dwFlags);     /* жǷΪЧID */

    if (result)                                                          /* ɹ */
    {
        semCount = (UINT32)(semContext->semCount);
    }
    else
    {
        semCount = ZOSS_ERROR;
    }

    return semCount;
}

/**************************************************************************
*                            ź
**************************************************************************/
/**************************************************************************
* ƣ zOss_CreateMutex
*  һź
* ˵
             (IN)
             name_ptr:         ҪĻź,Ȳɴ
                                MAX_MUTEXNAME_LEN
             priority_inherit: Ƿ֧ȼ̳(Ч)
                                ZOSS_INHERIT    ʾ֧ȼ̳
                                OSS_NO_INHERIT  ʾ֧ȼ̳
             (OUT)
*   ֵ ػźָ
* ˵ priority_inherit windowsƽ̨Ч
**************************************************************************/
ZOSS_MUTEX_ID zOss_CreateMutex(const CHAR *name_ptr, UINT32 priority_inherit)
{
    HANDLE handle = 0;
    
    if (name_ptr)
    {
        name_ptr = name_ptr;
    }

    handle = CreateMutex(NULL, FALSE, NULL);

    return (ZOSS_MUTEX_ID) handle;
}

/**************************************************************************
* ƣ zOss_GetMutex
*  ȡһź
* ˵ (IN)
             mutex_id:  źID
             timeout:   ȡʱʱ,λ
                        ΪZOSS_NO_WAIT,ܻȡǷɹ,
                        ZOSS_WAIT_FOREVERʾһֱȡ¼,ֱɹ
             (OUT)
*   ֵ ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR.
* ˵ 
**************************************************************************/
UINT32 zOss_GetMutex(ZOSS_MUTEX_ID mutex_id, UINT32 timeout)
{
    UINT32  dwWaitResult    = 0;
    UINT32  status          = 0;

    zOss_AssertEx(NULL != mutex_id, ZOSS_ERROR);
    
    if (timeout==ZOSS_NO_WAIT)
    {
        timeout = 0;
    }
    else if (timeout == ZOSS_WAIT_FOREVER)
    {
        timeout = INFINITE;
    }

    dwWaitResult = WaitForSingleObject(mutex_id, timeout);

    switch (dwWaitResult)
    {
    case WAIT_OBJECT_0:
        {
            status = ZOSS_SUCCESS;
            break;
        }
    case WAIT_TIMEOUT:
        {
            status = ZOSS_ERROR;
            break;
        }
            /* The specified object is a mutex object that was not released by the thread that owned the
              mutex object before the owning thread terminated. Ownership of the mutex object is granted
             to the calling thread, and the mutex is set to nonsignaled. */
    case WAIT_ABANDONED:
        {
            dwWaitResult = WaitForSingleObject(mutex_id, timeout);/* ٴλȡжϻǷЧ */

            if (WAIT_FAILED == dwWaitResult)
            {
                status = ZOSS_ERROR;
            }
            else if (WAIT_OBJECT_0 == dwWaitResult)
            {
                if (ReleaseMutex(mutex_id) != 0)
                {
                    status = ZOSS_SUCCESS;
                }
                else
                {
                    status = ZOSS_ERROR;
                }
            }
            else
            {
                status = ZOSS_ERROR;
            }

            break;
        }
    case WAIT_FAILED:
        {
            status =  ZOSS_ERROR;
            break;
        }
    default:
        {
            status =  ZOSS_ERROR;
            break;
        }
    }

    return status;
}

/**************************************************************************
* ƣ zOss_PutMutex
*  ͷһźͻȡź zOss_GetMutex()ɶʹã
             ͬһ߳̿Զεøú
* ˵ (IN)
             mutex_id: źID
             (OUT)
*   ֵ ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR.
* ˵ 
**************************************************************************/
UINT32 zOss_PutMutex(ZOSS_MUTEX_ID mutex_id)
{
    zOss_AssertEx(NULL != mutex_id, ZOSS_ERROR);
    
    if (ReleaseMutex(mutex_id))
    {
        return ZOSS_SUCCESS;
    }
    else
    {
        return ZOSS_ERROR;
    }
}

/**************************************************************************
* ƣ zOss_DeleteMutex
*  ɾһź
* ˵ (IN)
             mutex_id: źID
             (OUT)
*   ֵ ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵ 
**************************************************************************/
UINT32 zOss_DeleteMutex(ZOSS_MUTEX_ID mutex_id)
{    
    zOss_AssertEx(NULL != mutex_id, ZOSS_ERROR);

    if (CloseHandle(mutex_id))
    {
        return ZOSS_SUCCESS;
    }
    else
    {
        return ZOSS_ERROR;
    }
}

/**************************************************************************
* ƣ zOss_GetTickCount
*  ϵͳӵ󵽵ǰtick
* ˵ 
*   ֵ tick
* ˵ 
**************************************************************************/
UINT32 zOss_GetTickCount(VOID)
{
    return (UINT32)GetTickCount();
}

/*************************************************************************
* :  ʼ̺߳ı־λ
* ˵:     
*            ()  void
*            ()  void
*   ֵ:  void
* ˵:  void
**************************************************************************/
void zOss_TraceFuncInit(void)
{

}

/*************************************************************************
* :  ͳƸٺģļ¼Ϣ
* ˵:     
*            ()  func_name:  ƣΪգʾͳбٺļ¼Ϣ
                                     ǿʾͳָĸϢ.
*            ()  void
*   ֵ:  void
* ˵:  void
**************************************************************************/
void zOss_TraceFuncInfo(CHAR *func_name)
{

}

/**************************************************************************
* :  Osa_GetThreadUserArea
* : ʾ߳ϸϢ
* ˵: (IN)	
            thread_id:߳ID
*   ֵ: ɹ:߳ûռָ;ʧ:
* ˵: ߳лhookУbupdateֻΪFALSE,߳ID
            Чж
**************************************************************************/ 
T_ZOsa_ThreadUserArea* Osa_GetThreadUserArea(ZOSS_THREAD_ID thread_id, BOOL bupdate)
{
    ThreadContext           *tc     = NULL;
    T_ZOsa_ThreadUserArea   *ua     = NULL;
    UINT32                  temp    = 0;
    FILETIME                CreationTime;
    FILETIME                ExitTime;
    FILETIME                KernelTime;
    FILETIME                UserTime;  
  
    zOss_AssertEx(NULL != thread_id, NULL);
    
    tc = (ThreadContext *)thread_id;

    if (thread_id != tc->ua.threadid)
    {
        return NULL;
    }

    if (!bupdate)
    {
        return &(tc->ua);
    }

    ua = &(tc->ua);
    ua->priority = (UINT8)tc->priority;

    if (ua->topstack == 0)
    {
        strncpy((char *)ua->threadname, tc->thread_name, 16);
        ua->threadname[15]  = 0;
        ua->topstack        = 0;
        ua->stacksize       = 0;
        ua->threadid        = thread_id;
    }

    ua->msgnum = (UINT32)tc->msgQueue->queue_list.count;

    /* ߳ʱ */
    GetThreadTimes(tc->thread_handle, &CreationTime,&ExitTime, &KernelTime, &UserTime);
    temp = (UINT32)((((ULARGE_INTEGER*)&KernelTime)->QuadPart + ((ULARGE_INTEGER *)&UserTime)->QuadPart)
                    / 10000);
    ua->runtime     += temp - ua->cputime;
    ua->cputime     = temp;
    ua->RunTimeInMs = (UINT32)(ua->runtime / (gOsa_SysCpuFreq / 1000));

    /* ߳д         */

    /* ջʹ,  */
    ua->maxstack    = 0;
    ua->runstatus   = ZOSS_OS_BLOCK;
    return ua;
}

/**************************************************************************
* :  Osa_SwapCtl
* : 
* ˵: (IN):
*   ֵ:  ɹ:task_id;ʧ:NULL
* ˵:  
**************************************************************************/ 
VOID Osa_SwapCtl(BOOL enableRunTime)
{
    UINT32          count   = 0;
    UINT32          i       = 0;
    ThreadContext   *pTcb   = NULL;

    pTcb    = (ThreadContext *)gThreadList.HEAD;
    count   = (UINT32)gThreadList.count;

    if (enableRunTime)
    {
        if (NULL == gOsa_AllTaskIdArray)
        {
            T_OSS_PARAM *pPlatCfg = NULL;

            pPlatCfg = zOss_GetOssCfg();
            gOsa_AllTaskIdArray = (void **)zOss_Malloc(sizeof(ZOSS_TASK_ID) *pPlatCfg->TaskCfg.max_task_num);
            zOss_ASSERT(NULL != gOsa_AllTaskIdArray);
        }

        for (i = 0; i < count && pTcb != NULL ; i++)
        {
            pTcb->ua.cputime = 0;
            pTcb = (ThreadContext *)(pTcb->node.next);
        }
    }
}

/**************************************************************************
* : Osa_UpdateCpu
* : 
* ˵: (IN):
*   ֵ: 
* ˵:  
**************************************************************************/ 
VOID Osa_UpdateCpu(VOID)
{
    UINT32                  totaltime   = 0;
    UINT32                  excetime    = 0;
    T_ZOsa_ThreadUserArea   *pUa        = NULL;
    UINT32                  count       = 0;
    UINT32                  i           = 0;
    ThreadContext           *pTcb       = NULL;
    FILETIME                CreationTime; 
    FILETIME                ExitTime; 
    FILETIME                KernelTime; 
    FILETIME                UserTime;  

    GetProcessTimes(GetCurrentProcess(), &CreationTime, &ExitTime, &KernelTime, &UserTime);
    totaltime   = (UINT32)((((ULARGE_INTEGER*)&KernelTime)->QuadPart +
                            ((ULARGE_INTEGER*)&UserTime)->QuadPart) / 10000);

    pTcb        = (ThreadContext *)gThreadList.HEAD;
    count       =  (UINT32)gThreadList.count;

    for (i = 0; i < count && pTcb != NULL; i++)
    {
        pUa             = &(pTcb->ua);
        pTcb            = (ThreadContext *)(pTcb->node.next);
        excetime        = pUa->cputime * 100;
        pUa->cpupercent = (FLOAT)(((double)excetime) / totaltime);
    }

    if (gOsa_AllTaskIdArray)
    {
        T_ZOss_TCB *pTCB = NULL;

        count = zOss_GetAllTaskID(gOsa_AllTaskIdArray);

        for (i = 0;i < count;i++)
        {
            pTCB = (T_ZOss_TCB *)gOsa_AllTaskIdArray[i];

            if (pTCB != pTCB->task_id)
            {
                continue;/*may SDL task*/
            }

            excetime            = pTCB->cputime * 100;
            pTCB->cpupercent    = (FLOAT)(((double)excetime) / totaltime);
            pTCB->cputime       = 0;                             /* ˽cputime0 */
        }
    }
}

/**************************************************************************
* :  Osa_GetAllThreadId
* : ȡ߳ID
* ˵: (IN)
            (OUT)
            threadarray: ߳IDָ
*   ֵ: ߳
* ˵: ߳Ϊ0ʱ,ռûͷ
**************************************************************************/ 
UINT32 Osa_GetAllThreadId(ZOSS_THREAD_ID *threadarray[])
{
    UINT32          i           = 0;
    UINT32          count       = 0;
    ThreadContext   *pTcb       = NULL;
    ZOSS_THREAD_ID  *thread_id  = NULL;

    zOss_AssertEx(NULL != threadarray, 0);
    
    pTcb    = (ThreadContext *)gThreadList.HEAD;
    count   = (UINT32)gThreadList.count;

    if (count == 0)
    {
        *threadarray = NULL;
        return count;
    }

    thread_id = (ZOSS_THREAD_ID *)zOss_Malloc(MAX_THREAD_NUM * sizeof(ZOSS_THREAD_ID));

    zOss_AssertEx(NULL != thread_id, 0);
    
    for (i = 0; i < count && pTcb != NULL; i++)
    {
        thread_id[i] = (ZOSS_THREAD_ID)pTcb;
        pTcb         = (ThreadContext *)(pTcb->node.next);
    }

    *threadarray = thread_id;
    return count;
}

/**************************************************************************
* :  Osa_DisplayThreadExecInfo
* :
* ˵: (IN):
*   ֵ:
* ˵:
**************************************************************************/
UINT32 Osa_DisplayThreadExecInfo(PROCESS pid)
{
    zOss_Printf(SUBMDL_EXCEP, PRINT_LEVEL_NORMAL, "ùWinûʵ");
    return ZOSS_SUCCESS;
}

/**************************************************************************
* :  Osa_DisplayThreadsExecInfo
* :
* ˵: (IN):
*   ֵ:
* ˵:
**************************************************************************/
UINT32 Osa_DisplayThreadsExecInfo(UINT32 type)
{
    zOss_Printf(SUBMDL_EXCEP, PRINT_LEVEL_NORMAL, "ùWinûʵ");
    return ZOSS_SUCCESS;
}

/**************************************************************************
* :  Osa_DisplayThreadsExecInfo
* :
* ˵: (IN):
*   ֵ:
* ˵:
**************************************************************************/
FLOAT Osa_GetProcessCPU(ZOSS_THREAD_ID tid)
{
    FLOAT rate = 0;
    
    zOss_Printf(SUBMDL_EXCEP, PRINT_LEVEL_NORMAL, "ùWinûʵ");
    return rate;
}

/**************************************************************************
* ƣ OSA_IdentifyThread
*  жһ߳ǷЧ
* ˵ (IN)
             ZOSS_THREAD_ID : ߳ID
             (OUT)
*   ֵ ɹZOSS_SUCCESS;ʧܷZOSS_ERROR
* ˵ 
**************************************************************************/
UINT32 OSA_IdentifyThread(ZOSS_THREAD_ID threadID)
{
    T_ZOss_Node *pCurNode = NULL;

    zOss_AssertEx(NULL != threadID, ZOSS_ERROR);
    
    zOss_GetMutex(gThreadListMutex, ZOSS_WAIT_FOREVER);
    pCurNode = zOss_ListFirst (&gThreadList);

    while (pCurNode != NULL)
    {
        if (pCurNode == threadID)
        {
            zOss_PutMutex(gThreadListMutex);
            return ZOSS_SUCCESS;
        }

        pCurNode = zOss_ListNext(pCurNode);
    }

    zOss_PutMutex(gThreadListMutex);

    return ZOSS_ERROR;
}

/**************************************************************************
* ֲʵ
**************************************************************************/

/**************************************************************************
* ƣ OSA_DefaultEntry
*  Ĭ߳ںûں
* ˵ (IN)
             arg:     ߳ںĲ
             (OUT)
*   ֵ ʼɹZOSS_SUCCESS,ʧܷZOSS_ERROR
* ˵ ڲĬ߳ں;Ҫ߳Լִ˳б޸
**************************************************************************/
static VOID OSA_DefaultEntry(SINT32 arg)
{
    ThreadContext *threadContext = NULL;

    /* ȡ߳ */
    threadContext = (ThreadContext *)zOss_GetCurThreadID();

    if (NULL == threadContext)
    {
        return;
    }

    /* ִûں */
    threadContext->ThreadEntry(arg);

    /* ˳߳ */
    zOss_ExitThread();
}

/**************************************************************************
* ƣ OSA_GetThreadContext
*  IDȡ̵߳
* ˵ (IN)
             thread_real_id: ̵߳ID
             (OUT)
*   ֵ ̵߳
* ˵ Ϊڲӿڣӿʹ
**************************************************************************/
static ThreadContext* OSA_GetThreadContext(SINT32 thread_real_id)
{
    T_ZOss_Node     *pCurNode   = NULL;
    ThreadContext   *pCurThread = NULL;

    zOss_GetMutex(gThreadListMutex, ZOSS_WAIT_FOREVER);
    pCurNode = zOss_ListFirst(&gThreadList);

    while (pCurNode != NULL)
    {
        pCurThread = (ThreadContext *)pCurNode;

        if (pCurThread->thread_real_id == thread_real_id)
        {
            zOss_PutMutex(gThreadListMutex);
            return pCurThread;
        }

        pCurNode = zOss_ListNext(pCurNode);
    }

    zOss_PutMutex(gThreadListMutex);
    
    return NULL;
}

static THREAD_MSG_HOOK_CONTENT* find_thread_content(ZOSS_THREAD_ID thread_id)
{
    THREAD_MSG_HOOK_CONTENT *p_content = NULL;
    
    p_content = (THREAD_MSG_HOOK_CONTENT *)zOss_ListFirst(&s_thread_msg_hook_list);
    while (NULL != p_content)
    {
        if (thread_id == p_content->thread_id)
        {
            break;
        }
        p_content = (THREAD_MSG_HOOK_CONTENT *)zOss_ListNext((T_ZOss_Node *)p_content);
    }

    return p_content;
}

static BOOL is_sender_task(VOID *sender)
{  
    ZOSS_TASK_ID task_id = ZOSS_INVALID_TASK_ID;

    zOss_AssertEx(sender != NULL, FALSE);
    
    task_id = zOss_GetSelfTaskID();
    if (ZOSS_INVALID_TASK_ID != task_id)
    {
        *(UINT32 *)sender = (UINT32)task_id;
        return TRUE;
    }
    else
    {
        *(UINT32 *)sender = (UINT32)zOss_GetCurThreadID();
        return FALSE;
    }
}

static UINT32 proc_thread_msg_hook(UINT32 dire, UINT32 msg_id, VOID *p_buf, UINT16 buf_size, ZOSS_THREAD_ID thread_id)
{
    THREAD_MSG_HOOK_CONTENT *p_content = NULL;
    UINT32                  i          = 0;
    
    p_content = find_thread_content(thread_id);
    if (NULL == p_content)
    {
        return 0;
    }

    for (i=0; i<THREAD_MSG_HOOK_TYPE_MAX; i++)
    {
        if (0 != (dire & p_content->dire[i]))
        {
            (VOID)(p_content->func[i])(msg_id, p_buf, (UINT32)buf_size, (UINT8)dire);
        }
    }
    return (0 != (dire & p_content->dire[ZOSS_SETHOOKFLAG_INTER-1])) ? ZOSS_SETHOOKFLAG_INTER : 0;
}

static UINT32 proc_task_msg_hook(UINT32 dire, UINT32 msg_id, VOID *p_buf, UINT16 buf_size, ZOSS_TASK_ID task_id)
{
    T_ZOss_TCB          *task_tcb   = (T_ZOss_TCB *)task_id;
    T_ZOss_TaskMsgHead  msg_head    = {0};
    UINT32              i           = 0;

    msg_head.msgID = msg_id;
    for (i=0; i<THREAD_MSG_HOOK_TYPE_MAX; i++)
    {
        if (0 != (dire & task_tcb->dire[i]))
        {
            (VOID)task_tcb->HookEntry[i](&msg_head, (UINT8)dire);
        }
    }

    return (0 != (dire & task_tcb->dire[ZOSS_SETHOOKFLAG_INTER-1])) ? ZOSS_SETHOOKFLAG_INTER : 0;
}

static UINT32 proc_msg_hook(UINT32 msg_id, VOID *p_buf, UINT16 buf_size, ZOSS_THREAD_ID d_thread_id)
{
    VOID    *sender = NULL;
    UINT32  ret     = 0;
    
    if (is_sender_task(&sender))
    {
        ret = proc_task_msg_hook(ZOSS_MSGDIRE_OUT, msg_id, p_buf, buf_size, (ZOSS_TASK_ID)sender);
    }
    else
    {
        ret = proc_thread_msg_hook(ZOSS_MSGDIRE_OUT, msg_id, p_buf, buf_size, (ZOSS_THREAD_ID)sender);
    }
    if (ZOSS_SETHOOKFLAG_INTER == ret)
    {
        return ret;
    }
    
    return proc_thread_msg_hook(ZOSS_MSGDIRE_IN, msg_id, p_buf, buf_size, d_thread_id);
}


#ifdef __cplusplus
}
#endif

