/*******************************************************************************
* Copyright 2008 by  ZTE Corporation.
*
* FileName::    hal_comm.c
* File Mark:
* Description:  This file contains the hardware interface for common driver
* Others:
* Version:      v0.5
* Author:       WangShiyong
* Date:         2008-04-02
*
* History 1:
*     Date:     2009-3-3
*     Version:
*     Author:   zhangyingjun
*     Modification: add shutdown function
* History 2:
*     Date:     2010-6-17
*     Version:
*     Author:   wangxia
*     Modification: modify soft reset function for optimization
*******************************************************************************/
/****************************************************************************
*                                              Include files
******************************************************************************/
#include "drvs_general.h"
#include "drvs_spinlock.h"
#include "drvs_i2c.h"
#include "drvs_comm.h"
#include "drvs_cfg.h"
#include "drvs_pmic.h"


/****************************************************************************
*                                              Local Macros
****************************************************************************/
#define GLOBAL_RESET_REG            0x13B000
#ifdef _CHIP_ZX297520V3
#define DEFAULT_PSHOLD1_PIN         GPIO24
#define PSHOLD1_PIN_MODE_GPIO       GPIO24_GPIO24
#define PSHOLD1_PIN_GPIO_OUT   GPIO_IN     /*V3 gpio24 define  error*/
#else
#define DEFAULT_PSHOLD1_PIN         GPIO51
#define PSHOLD1_PIN_MODE_GPIO       GPIO51_GPIO51
#define PSHOLD1_PIN_GPIO_OUT   GPIO_OUT

#endif

/****************************************************************************
*                                              Local Types
****************************************************************************/
typedef enum
{
	RST_UNDEFINE	= 0,
	RST_TO_NORMAL = 1,
	RST_TO_CHARGER = 2,
	RST_TO_ALARM = 3,
	RST_TO_EXCEPT = 4,

	RST_MAX
}T_ResetType;

/****************************************************************************
*                                              Local Constants
****************************************************************************/
volatile T_ZDrvSys_PowerOn_Type gDrvPowerOnState;

/****************************************************************************
*                                              Local Function Prototypes
****************************************************************************/
SINT32 hal_Comm_Soft_Reset(T_ZDrvSys_RESET_TYPE reset_type);
SINT32 hal_Comm_ShutDown(VOID);
T_ZDrvSys_PowerOn_Type hal_Comm_Get_PowerOnState(VOID);

//static void comm_setPshold(T_ZDrvGpio_IoVal value);


/****************************************************************************
*                                             Global Constants
****************************************************************************/

/****************************************************************************
*                                             Global Variables
****************************************************************************/
HAL_COMM_OPT gHalComm_tOperations=
{
            NULL, //hal_Comm_ShutDown,
            NULL, //hal_Comm_Soft_Reset,
            hal_Comm_Get_PowerOnState,
};

extern UINT32 g_pmicPsholdPin;

/****************************************************************************
*                                             Global Function Prototypes
****************************************************************************/
extern void bsp_udelay(U32 us);

/****************************************************************************
*                                             Function Definitions
****************************************************************************/
#if 0

/*******************************************************************************
* Function: halComm_ShutDown
* Description: shut off power
* Parameters:
*   Input:
*           None
*   Outpu:  None
* Returns:
*           None
* Others:   None
*******************************************************************************/
//extern void l1d_rf_from_idle_to_standby(void);
SINT32 hal_Comm_ShutDown(VOID)
{
#if defined (_CORE_ARM_PS)
    SINT32 ret = DRV_SUCCESS;

	zDrvI2c_DevLock_BeforePSM(I2C_BUS_2);
    zDrv_DisableIrq();
	zDrvSysSpinlock_SoftLockPsm(I2C2_SFLOCK);

    /*l1d_rf_from_idle_to_standby();*/

    ret = Zx234290_setSoftOn_PSM(false);
    /* Disable PMIC shutdown when PWRON long long pressed, for Zx234290_getPoweronStatus_PSM may be executing.
       Protect the I2C communication of it. */
    ret |= zDrvPmic_SetRegister_PSM(ZX234290_I2C_SLAVE_ADDR0, ZX234290_REG_ADDR_PWRKEY_CONTROL1, 0, 0x01<<2);
    if( ret != DRV_SUCCESS )
    {
        zDrv_ASSERT(0);
    }

    while(1)
    {
        ret = Zx234290_getPoweronStatus_PSM();
        if(ret == 0)
        {
            break;
        }
        else if(ret < 0)
        {
            zDrv_ASSERT(0);
        }
    }

    comm_setPshold(GPIO_LOW);
    bsp_udelay(50000);

    /* RESET_TO_CHARGER */
    ret = hal_Comm_Soft_Reset(RESET_TO_CHARGER);
    if( ret != DRV_SUCCESS )
    {
        zDrv_ASSERT(0);
    }

	zDrvSysSpinlock_SoftUnlockPsm(I2C2_SFLOCK);
    zDrv_EnableIrq();
	zDrvI2c_DevUnlock_AfterPSM(I2C_BUS_2);
#endif
    return DRV_SUCCESS;
}
/*******************************************************************************
* Function: hal_Comm_Soft_Reset
* Description: soft reset
* Parameters:
*   Input:
*           reset_type:T_ZDrvSys_RESET_TYPE
*   Outpu:  None
* Returns:
*           None
* Others:
*******************************************************************************/
SINT32 hal_Comm_Soft_Reset(T_ZDrvSys_RESET_TYPE reset_type)
{
    SINT32 ret = DRV_SUCCESS;
    T_ResetType flag = 0;
	int cpsr = 0;

    if (reset_type>=MAX_RESET_TYPE)
    {
        return (SINT32)DRV_ERR_INVALID_PARAM;
    }

    switch (reset_type)
    {
        case  RESET_TO_NORMAL:
        {
            flag = RST_TO_NORMAL;
            break;
        }

        case RESET_TO_EXCEPTRESET:
        {
            flag = RST_TO_NORMAL;
            break;
        }

        case RESET_TO_CHARGER:
        {
            flag = RST_TO_CHARGER;
            break;
        }

        case RESET_TO_ALRAM:
        {
            flag = RST_TO_ALARM;
            break;
        }

        default:
        return (SINT32)DRV_ERR_INVALID_PARAM;
    }

	ZOSS_QUERY_IRQ(cpsr);

	if (!(cpsr & 0xC0))
	{
		zDrvI2c_DevLock_BeforePSM(I2C_BUS_2);
	}

    /* interrupt maybe disabled or not. disable it to avoid interruption. */
    zDrv_DisableIrq();

	zDrvSysSpinlock_SoftLockPsm(I2C2_SFLOCK);

    ret = Zx234290_SetUserReg_PSM(flag);

    if(flag == RST_TO_CHARGER)
    {
        comm_setPshold(GPIO_LOW);
    }
    else
    {
        comm_setPshold(GPIO_HIGH);
    }

    if (ret == DRV_SUCCESS)
    {
        reg32(GLOBAL_RESET_REG) = (0x01);
    }

	while(1); /* should never return */

	zDrvSysSpinlock_SoftUnlockPsm(I2C2_SFLOCK);

    zDrv_EnableIrq();

	if (!(cpsr & 0xC0))
	{
		zDrvI2c_DevUnlock_AfterPSM(I2C_BUS_2);
	}

    return ret;
}
#endif

T_ZDrvSys_PowerOn_Type hal_Comm_Get_PowerOnState(VOID)
{
    return gDrvPowerOnState;
}

extern unsigned int * get_boot_reason_addr(void);
VOID hal_Comm_CheckPowerOnState(VOID)
{
    #if 1
	unsigned int * p;
	p = get_boot_reason_addr();
           /*EVBػ⹦ */
    if(*(T_ZDrvSys_PowerOn_Type *)p >= POWER_ON_INVALID)
    {
        gDrvPowerOnState = POWER_ON_INVALID;
    }
    else
    {
        gDrvPowerOnState = *(T_ZDrvSys_PowerOn_Type *)(POWERON_TYPE_ADDR);
    }
    #else
    gDrvPowerOnState = POWER_ON_INVALID;
    #endif

}

/*******************************************************************************
* Function: Comm_SetInstance
* Description: comm function installr
* Parameters:
*   Input:
*           None
*
*   Outpu:  None
* Returns:
*
* Others:   None
*******************************************************************************/
VOID Comm_SetInstance(VOID)
{
    zDrvComm_SetOperations(&gHalComm_tOperations);
}

/*******************************************************************************
 * Function: zDrvComm_Initiate
 * Description:common module initiate
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns: always return  success
 *
 *
 * Others:
 ********************************************************************************/
SINT32 zDrvComm_Initiate(VOID)
{
    hal_Comm_CheckPowerOnState();
    Comm_SetInstance();

    return DRV_SUCCESS;
}

/******************************************************************************
 * Function:    comm_setPshold
 * Description: pull on or pull off pshold pin.
 * Parameters:
 *   Input:
 *      None
 *   Output:
 *      None
 * Returns:
 *      None
 *
 * Others:
 ******************************************************************************/
#if 0
static void comm_setPshold(T_ZDrvGpio_IoVal value)
{
    if((g_pmicPsholdPin == (UINT32)NULL) || (g_pmicPsholdPin >= INVLID_GPIO))
    {
        /* PSHOLD pin GPIO24 */
        zDrvGpio_PullUpDown(DEFAULT_PSHOLD1_PIN, GPIO_NO_ACTION);
        zDrvGpio_SetFunc(DEFAULT_PSHOLD1_PIN, PSHOLD1_PIN_MODE_GPIO);
        zDrvGpio_SetDirection(DEFAULT_PSHOLD1_PIN, PSHOLD1_PIN_GPIO_OUT);
        zDrvGpio_SetOutputValue(DEFAULT_PSHOLD1_PIN, value);
    }
    else
    {
        zDrvGpio_SetOutputValue(g_pmicPsholdPin, value);
    }
}
#endif
