/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:
 * File Mark:
 * Description:
 * Others:
 * Version:       1.0
 * Author:        geanfeng
 * Date:          2013-09-25
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

#ifndef _DRVS_IO_H_
#define _DRVS_IO_H_

/****************************************************************************
* 	                                        Include files
****************************************************************************/
#include "drvs_io_keys.h"
#include "drvs_io_names.h"

/****************************************************************************
* 	                                        Macros
****************************************************************************/
#define ZDRVIO_INVALID_HANDLE  NULL


/****************************************************************************
* 	                                        Types
****************************************************************************/
/*IO handle*/
typedef void * T_ZDrvIO_Handle;

/*Open Flags*/
typedef struct  _T_ZDRVIO_FLAGS
{
	UINT32 READ:1;
	UINT32 WRITE:1;
	UINT32 MULTI_READ:1;
	UINT32 MULTI_WRITE:1;
	UINT32 SHARED:1;
	UINT32 RESERVE:27;
}
T_ZDRVIO_FLAGS;


/*Global Notify Handle*/
typedef VOID * T_ZDrvIO_GNotifyHandle;


/*Global Notify Callback Function*/
typedef VOID (*T_ZDrvIO_GNotifyCallBack)(const char* devName, T_DRVIO_EVENT event);

/****************************************************************************
* 	                                        Constants
****************************************************************************/

/****************************************************************************
* 	                                        Global  Variables
****************************************************************************/

/****************************************************************************
* 	                                        Function Prototypes
****************************************************************************/
/*******************************************************************************
 * Function: zDrvIO_Open
 * Description:search device by device name, open it, and set the action flags.
 * Input:
    name: device name.
    flags: open flags, control the device action.
 * Output:None
 *
 * Returns:
              T_ZDrvIO_Handle: the opened device handle. if error happened, return NULL.
 * Others:
 ********************************************************************************/
T_ZDrvIO_Handle zDrvIO_Open(const char *name, T_ZDRVIO_FLAGS flags);
/*******************************************************************************
 * Function: zDrvIO_Read
 * Description:read data from device.
 * Input:
 	handle:the device handle for read.
 	buffer: the read data buffer. the buffer space supplied by high layer.
 	length:the data length need to read.
 * Output:None
 *
 * Returns:
              ret >= 0: return the actual read length.
              DRV_ERROR_NOCONNECT: the device disconnect event happend, need return error to inform higher user.
              other: other error maked by device.
 * Others:
 ********************************************************************************/
SINT32 zDrvIO_Read(T_ZDrvIO_Handle handle, UINT8* buffer, UINT32 length);
/*******************************************************************************
 * Function: zDrvIO_Write
 * Description:write data to IO handle
 * Input:
  	handle:the device handle for write.
 	buffer: the write data buffer. the buffer space supplied by high layer.
 	length:the write data length.
* Output:None
 *
 * Returns:
              ret >= 0: return the actual write length.
              DRV_ERROR_NOCONNECT: the device disconnect event happend, need return error to inform higher user.
              other: other error maked by device.
 * Others:
 ********************************************************************************/
SINT32 zDrvIO_Write(T_ZDrvIO_Handle handle, UINT8* buffer, UINT32 length);
/*******************************************************************************
 * Function: zDrvIO_BRead
 * Description:read data from device.
 * Input:
 	handle:the device handle for read.
 	buffer: the read data buffer. the buffer space supplied by high layer.
 	length:the data length need to read.
 	pos:the read data position in device storage space.
 * Output:None
 *
 * Returns:
              ret >= 0: return the actual read length.
              DRV_ERROR_NOCONNECT: the device disconnect event happend, need return error to inform higher user.
              other: other error maked by device.
 * Others:
 ********************************************************************************/
SINT32 zDrvIO_BRead(T_ZDrvIO_Handle handle, UINT8* buffer, UINT32 blkCnt, UINT32 pos);
/*******************************************************************************
 * Function: zDrvIO_BWrite
 * Description:write data to IO handle
 * Input:
  	handle:the device handle for write.
 	buffer: the write data buffer. the buffer space supplied by high layer.
 	length:the write data length.
 	pos:the write data position in device storage space.
* Output:None
 *
 * Returns:
              ret >= 0: return the actual write length.
              DRV_ERROR_NOCONNECT: the device disconnect event happend, need return error to inform higher user.
              other: other error maked by device.
 * Others:
 ********************************************************************************/
SINT32 zDrvIO_BWrite(T_ZDrvIO_Handle handle, UINT8* buffer, UINT32 blkCnt, UINT32 pos);
/*******************************************************************************
 * Function: zDrvIO_Ctrl
 * Description:control device.
 * Input:
  	handle:the device handle for control.
   	function:the control function.
  	handle:the control function arguments.
* Output:None
 *
 * Returns:
              DRV_SUCCESS: success.
              DRV_ERROR: error.
 * Others:
 ********************************************************************************/
SINT32 zDrvIO_Ctrl(T_ZDrvIO_Handle handle, T_DRVIO_CTRL_KEY  function, VOID *arg);
/*******************************************************************************
 * Function: zDrvIO_Close
 * Description:close the device
 * Input:
 	handle:the device handle to be closed.
 * Output:None
 *
 * Returns:
              DRV_SUCCESS: success.
              DRV_ERROR: error.
 * Others:
 ********************************************************************************/
SINT32 zDrvIO_Close(T_ZDrvIO_Handle handle);

/*******************************************************************************
 * Function: zDrvIO_RegisterGlobalNotify
 * Description: register global notifier.
 * Input:
 *        globalNotifyFn: global noitifier callback function
 * Output:None
 *
 * Returns:
 *       T_ZDrvIO_GNotifyHandle : the global notifier handler.
 * Others:
 ********************************************************************************/
T_ZDrvIO_GNotifyHandle zDrvIO_RegisterGlobalNotify(T_ZDrvIO_GNotifyCallBack globalNotifyFn);
/*******************************************************************************
 * Function: zDrvIO_UnregisterGlobalNotify
 * Description: unregister global notifier.
 * Input:
 *        gNotifyHandle: the global notifier handler
 * Output:None
 *
 * Returns:
 *
 * Others:
 ********************************************************************************/
VOID zDrvIO_UnregisterGlobalNotify(T_ZDrvIO_GNotifyHandle gNotifyHandle);


#endif/*_DRVS_IO_H_*/

