/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:ring_queue.h
 * File Mark:
 * Description:
 * Others:
 * Version:       1.0
 * Author:        geanfeng
 * Date:          2013-09-25
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

#ifndef _RING_QUEUE_H
#define _RING_QUEUE_H

/****************************************************************************
* 	                                        Include files
****************************************************************************/
#include "drvs_general.h"
/****************************************************************************
* 	                                        Macros
****************************************************************************/

/****************************************************************************
* 	                                        Types
****************************************************************************/
typedef enum _T_USER_PROTECT_POLICY {
	QUEUE_PROTECT_RAW = 0,
	QUEUE_PROTECT_MUTEX,
	QUEUE_PROTECT_IRQ,
}T_USER_PROTECT_POLICY;

typedef struct _T_Ring_Queue {
	UINT8 *unit_buffer;
	UINT32 unit_buffer_size;
	UINT32 unit_size;
	UINT32 unit_count;
	UINT32 write_pos;
	UINT32 read_pos;
	
	T_USER_PROTECT_POLICY multi_user_protect;
	ZOSS_SEMAPHORE_ID lock;
}T_Ring_Queue;

/****************************************************************************
* 	                                        Constants
****************************************************************************/

/****************************************************************************
* 	                                        Global  Variables
****************************************************************************/

/****************************************************************************
* 	                                        Function Prototypes
****************************************************************************/
T_Ring_Queue *ringQueue_Create(UINT32 unit_count, UINT32 unit_size, T_USER_PROTECT_POLICY multi_user_protect);

SINT32 ringQueue_Init(T_Ring_Queue *queue, UINT8 *unit_buffer, 
						UINT32 unit_count, UINT32 unit_size, T_USER_PROTECT_POLICY protect_policy);

SINT32 ringQueue_Enqueue(T_Ring_Queue *queue, VOID *unit);

SINT32 ringQueue_Dequeue(T_Ring_Queue *queue, VOID *unit);

SINT32 ringQueue_Empty(T_Ring_Queue *queue);

SINT32 ringQueue_Full(T_Ring_Queue *queue);

VOID ringQueue_Fush(T_Ring_Queue *queue);

VOID ringQueue_Destroy(T_Ring_Queue *queue);


#endif/*_RING_QUEUE_H*/

