/*******************************************************************************
* Copyright (C) 2013, ZTE Corporation.
*
* File Name:    request_queue.c
* File Mark:
* Description:
* Others:
* Version:		 V1.0
* Author:		 geanfeng
* Date: 		 2013-09-24
********************************************************************************/

#include "drvs_general.h"
#include "drvs_assert.h"
#include "ring_queue.h"
#include "request_queue.h"


/**
 * requestQueue_Create - create a new request queue.
 *
 * Create a new special request queue.
 */
T_Request_Queue *requestQueue_Create(UINT32 req_count, UINT32 req_size, queue_notify notify_fn, VOID* queue_data)
{
    T_Request_Queue *q = NULL;

    q = (T_Request_Queue*)zOss_Malloc(sizeof(T_Request_Queue));
    if (!q)
        return NULL;

    q->queue = ringQueue_Create(req_count, req_size, QUEUE_PROTECT_RAW);
    if (!q->queue)
    {
        free(q);
        return NULL;
    }
    q->notify_fn = notify_fn;
    q->process_state = QUEUE_IDLE;
    q->work_state = QUEUE_WORKING;
    q->queue_data = queue_data;
    return q;
}


/**
 * requestQueue_SubmitRequest - submit a new request.
 *
 *
 */
SINT32 requestQueue_SubmitRequest(T_Request_Queue *q, T_Request *req)
{
    SINT32 ret = 0;

    if (q == NULL || req == NULL)
    {
        zDrv_ASSERT(0);
        return DRV_ERROR;
    }
    zDrv_ASSERT(q->process_state == QUEUE_IDLE);

    ret = ringQueue_Enqueue(q->queue, (VOID *)req);
    if (ret)
    {
        q->process_state  = QUEUE_IDLE;
        return ret;
    }
	
    /*process_stateжwork_state˳Ҫ*/
    q->process_state = QUEUE_SUBMITING;

    if (q->work_state == QUEUE_SUSPEND)
    {
        q->process_state  = QUEUE_IDLE;
        return 0;
    }

    if (q->notify_fn)
        q->notify_fn(q);

    q->process_state  = QUEUE_IDLE;
    return 0;
}

/**
 * requestQueue_FetchRequest - fetch a new request.
 *
 *
 */
SINT32 requestQueue_FetchRequest(T_Request_Queue *q, T_Request *req)
{
    SINT32 ret = 0;

    if (q == NULL || req == NULL)
    {
        zDrv_ASSERT(0);
        return DRV_ERROR;
    }
    ret = ringQueue_Dequeue(q->queue, (VOID*)req);
    return ret;
}

/**
 * suspend_request_queue - suspend a request queue.
 *
 *
 */
SINT32 requestQueue_Suspend(T_Request_Queue *q)
{
    if (q == NULL)
    {
        zDrv_ASSERT(0);
        return DRV_ERROR;
    }

    q->work_state = QUEUE_SUSPEND;

    while (q->process_state == QUEUE_SUBMITING)
    {
        zOss_Sleep(1);
    }

    return 0;
}

/**
 * requestQueue_Resume - resume a suspend request queue.
 *
 *
 */
SINT32 requestQueue_Resume(T_Request_Queue *q)
{
    zDrv_ASSERT(q != NULL);

    if (q->work_state != QUEUE_SUSPEND)
    {
        zDrv_ASSERT(0);
        return DRV_ERROR;
    }

    if (q->notify_fn)
    {
        q->notify_fn(q);
    }

    q->work_state = QUEUE_WORKING;
    return 0;
}

/**
 * requestQueue_Destroy - destroy a suspend request queue.
 *
 *
 */
VOID requestQueue_Destroy(T_Request_Queue *q)
{
    zDrv_ASSERT(q != NULL);
    ringQueue_Destroy(q->queue);
    q->queue = NULL;
    zOss_Free(q);
}
