/*******************************************************************************
 * Copyright (C) 2014, ZTE Corporation.
 *
 * File Name:   hal_int_internal.h
 * File Mark:
 * Description:  describe functions and related macros and types used by 
 *               other driver modules
 * Others:
 * Version:       1.0
 * Author:        xuzhiguo
 * Date:          2014-05-05
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

#ifndef _DRVS_INT_INTERNAL_H
#define _DRVS_INT_INTERNAL_H

/****************************************************************************
*                                           Include files
****************************************************************************/
#include "drvs_general.h"
#include "drvs_int.h"

/****************************************************************************
*                                           Macros
****************************************************************************/

/****************************************************************************
*                                           Types
****************************************************************************/
typedef enum _T_Int_State
{
    INT_UNINSTALL,
    INT_PENDING,
    INT_ACTIVE,
} T_Int_State;

/*
* this struct presents the operation method
* and state of interrupt controller chip
*/
typedef struct _T_Int_Chip
{
    VOID (*pMaskIrq)( UINT32 line );
    VOID (*pUnmaskIrq)( UINT32 line );
    VOID (*pSetLineLevel)(UINT32 line, T_zDrvIntLineLevel level);
    VOID (*pSetLinePri)(UINT32 line, UINT32 pri);
} T_Int_Chip;

typedef VOID (*IsrFunc)(VOID);

/**************************************************************************
 *                           Global  Variable
 **************************************************************************/

/**************************************************************************
 *                           Function Prototypes
 **************************************************************************/
 /*******************************************************************************
 * Function:  zDrvInt_SetMaskRam
 * Description:  an inline function to set g_IntDev.MaskRegInRam
 * Parameters:
 *   Input:
 *          index: which member in array MaskRegInRam
 *          value: be writen
 *
 *   Output:
 *
 * Returns:
 *
 * Others:
 ********************************************************************************/
 VOID zDrvInt_SetMaskRam(UINT32 index, UINT32 value);

/*******************************************************************************
 * Function: zDrvInt_GetMaskRam
 * Description:  an inline function to get g_IntDev.MaskRegInRam
 * Parameters:
 *   Input:
 *          index: which member in array MaskRegInRam
 *
 *   Output:
 *
 * Returns:
 *          member's value in array MaskRegInRam
 *
 * Others:
 ********************************************************************************/
 UINT32 zDrvInt_GetMaskRam(UINT32 index);

/*******************************************************************************
 * Function: zDrvInt_GetExtraIsr
 * Description:  get a isr according to ex8in1 int and gpio int
 * Parameters:
 *   Input:
 *          line: interrupt line
 *
 *   Output:
 *
 * Returns:
 *          isr for ex8in1 int and gpio int
 * Others:
 ********************************************************************************/
 VOID* zDrvInt_GetExtraIsr(UINT32 line);

/*******************************************************************************
 * Function: zDrvInt_GetIntState
 * Description:  an inline function to get g_IntDev.IntState
 * Parameters:
 *   Input:
 *          line:  interrupt line to be disabled 0--INT_LINES_NUM
 *
 *   Output:
 *
 * Returns:
 *          member's value in array IntState
 *
 * Others:
 ********************************************************************************/
 T_Int_State zDrvInt_GetIntState(UINT32 line);

/*******************************************************************************
 * Function: zDrvInt_SetChipHandler
 * Description:
 * Parameters:
 *   Input:
 *          line: which member in array IntChipHandler, according to interrupt line
 *          pChip: point to struct T_Int_Chip to be set
 *
 *   Output:
 *
 * Returns:
 *
 * Others:
 ********************************************************************************/
 VOID zDrvInt_SetChipHandler(UINT32 line, T_Int_Chip *pChip);

 #endif
