/*********************************************************************
 Copyright 2007 by  ZTE Corporation.
 *
 * FileName::    hal_pmmanager.c
 * File Mark:
* Description:  This file contains the hardware interface for rtc driver
* Others:
* Version:   v0.5
* Author:   zhangyingjun
* Date:   2009-02-23

* History 1:
*     Date:
*     Version:
*     Author:
*     Modification:
* History 2:
**********************************************************************/

/**************************************************************************
 *                                                 Include files                                     *
 **************************************************************************/

#ifndef _HAL_POWERON_DEF_H
#define _HAL_POWERON_DEF_H

#define OS_FLASH_KPD_POWERON_FLAG            0x163FFFFC
#define OS_FLASH_ALARM_POWERON_FLAG        0x163FFFFD
#define OS_FLASH_CHARGER_POWERON_FLAG    0x163FFFFE
#define OS_FLASH_SOFTRESET_FLAG                  0x163FFFFF    /*use check softreset power on */

#define DPRAM_TRACE_LOADING_FLAG  0x40000000 + 0x1400
#define TRACE_LOADING_FLAG_VALUE                                  0xAABB

#define SOFTRESET_POWRON_FLAG_VALUE                            0xAA
#define KPD_POWER_FLAG_VALUE                                         0xBB
#define ALARM_POWER_FLAG_VALUE                                     0xCC
#define CHARGER_POWER_FLAG_VALUE                                 0xDD
typedef enum
{
    POWER_ON_STATE_NORMAL       = 0,
    POWER_ON_STATE_CLOCK         = 1,
    POWER_ON_STATE_CHARGING   = 2,
    POWER_ON_STATE_SOFTRESET  = 3,
    POWER_ON_STATE_INVALID      = 4,
    POWER_ON_STATE_INIT            = 5
}T_POWER_ON_State;

typedef enum
{
    POWER_ON_EVENT_NORMAL       = 0,
    POWER_ON_EVENT_CLOCK          = 1,
    POWER_ON_EVENT_CHARGING     = 2,
    POWER_ON_EVENT_SOFTRESET    =3,
    POWER_ON_EVENT_INVALID       = 4,
    POWER_ON_EVENT_INIT             = 5
}T_POWER_ON_EVENT;

typedef struct
{
    T_POWER_ON_State normal_Power_on_CurrentState;
    T_POWER_ON_State rtc_Power_on_CurrentState;
    T_POWER_ON_State charger_Power_on_CurrentState;
    T_POWER_ON_State softreset_Power_on_CurrentState;
}
T_POWER_ON_CURRENT_STATE;

SINT32 zDrvPmmanager_Initiate(VOID);
//T_POWER_ON_CURRENT_STATE hal_sysm_power_on_state_get(VOID);

#endif
