/*****************************************************************************
 *汾 (C)2008ͨѶɷ޹˾
 *  ģ	    
 *  ļ	   os_mutex.c
 *  ʵֹ     
 *  		    
 *  汾		    v1.0
 *  	    2010.10.10
 *  ˵	    
 *****************************************************************************/

/**************************************************************************
 *                        ͷļ                                                                         *
 **************************************************************************/

#include    "os_type.h"
#include    "os_pub.h"
#include    "os_mem.h"
#include    "os_mutex.h"
#include    <pthread.h>


/**************************************************************************
 *                          غ                                                                           *
 **************************************************************************/
#define mutex_context(mid)      ((OSA_MUTEX_CONTEXT *)mid)
#define mutex_pthread_t(mid)    (mutex_context(mid)->p_mutex_t)
#define mutex_info(mid)         (mutex_context(mid)->info)




/**************************************************************************
 *                                                                                                    *
 **************************************************************************/
typedef struct
{
    pthread_mutex_t  p_mutex_t;
    OS_MUTEX_INFO       info;
} OSA_MUTEX_CONTEXT;
/**************************************************************************
 *                           ֲԭ                                                               *
 **************************************************************************/
static SINT32 mutex_context_add( OSA_MUTEX_CONTEXT **p_context );
static SINT32 mutex_context_add_bk( OSA_MUTEX_CONTEXT **p_context );
static VOID   mutex_context_remove( OSA_MUTEX_CONTEXT *p_context );

/**************************************************************************
 *                     ȫֺʵ                                                                     *
 **************************************************************************/
/**************************************************************************
* ƣ tp_os_mutex_create
*  һ
* ˵ szNameĻ
                               bLockFlagʼǷ
*   ֵ    ɹ򷵻ػıʶţ򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
OS_MUTEX_ID tp_os_mutex_create( CHAR* szName, BOOL bLockFlag )
{
    OSA_MUTEX_CONTEXT  *p_context = NULL;

    TP_OS_ASSERTEx( NULL != szName, OS_MUTEX_INVALID_ID );
    TP_OS_ASSERTEx( bLockFlag, OS_MUTEX_INVALID_ID );  /* to be monitored */

    if ( OS_SUCCESS != mutex_context_add( &p_context ) )
    {
        printf("tp_os_mutex_create falied\n");
        return OS_MUTEX_INVALID_ID;
    }
    strncpy( p_context->info.name, szName, OS_MAX_NAME_LEN-1 );
    p_context->info.current_val = 0;  /* to be done */
  //printf("tp_os_mutex_create success\n");
    return p_context->info.id;
}
OS_MUTEX_ID tp_os_mutex_create_bk( CHAR* szName, BOOL bLockFlag )
{
    /*OSA_MUTEX_CONTEXT  *p_context = NULL;

    TP_OS_ASSERTEx( NULL != szName, OS_MUTEX_INVALID_ID );
    TP_OS_ASSERTEx( bLockFlag, OS_MUTEX_INVALID_ID );  /* to be monitored */

    /*if ( OS_SUCCESS != mutex_context_add_bk( &p_context ) )
    {
        printf("tp_os_mutex_create falied\n");
        return OS_MUTEX_INVALID_ID;
    }
    strncpy( p_context->info.name, szName, OS_MAX_NAME_LEN-1 );
    p_context->info.current_val = 0;  /* to be done */
  printf("tp_os_mutex_create success\n");
    //return p_context->info.id;
    return 0;
}

/**************************************************************************
* ƣ tp_os_mutex_delete
*  ɾָĻеȴû߳ȴ״̬
* ˵midıʶ
*   ֵ    ɹ򷵻OS_SUCCESS򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
OS_STATUS tp_os_mutex_delete( OS_MUTEX_ID mid )
{
    TP_OS_ASSERTEx( OS_MUTEX_INVALID_ID != mid, OS_FAILURE );

    /* to be done */
    if ( 0 < mutex_context(mid)->info.current_val )
    {
        return OS_FAILURE;
    }
    mutex_context_remove( mutex_context(mid) );

    return OS_SUCCESS;
}

/**************************************************************************
* ƣ tp_os_mutex_get
*  һָ߳ĶռȨ
* ˵midıʶ
                              timeoutָʾȴʱ䣬λΪ
*   ֵ    ɹ򷵻OS_SUCCESS򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
OS_STATUS tp_os_mutex_get( OS_MUTEX_ID mid, UINT32 timeout )
{
    TP_OS_ASSERTEx( OS_MUTEX_INVALID_ID != mid, OS_FAILURE );
    TP_OS_ASSERTEx( OS_WAIT_FOREVER == timeout, OS_FAILURE );  /* to be monitored */

    pthread_mutex_lock( &mutex_pthread_t(mid) );
    mutex_context(mid)->info.current_val ++;

    return OS_SUCCESS;
}
/**************************************************************************
* ƣ tp_os_mutex_put
*  ͷű̶ָ߳ĶռȨ
* ˵midıʶ
*   ֵ    ɹ򷵻OS_SUCCESS򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
OS_STATUS tp_os_mutex_put( OS_MUTEX_ID mid )
{
    TP_OS_ASSERTEx( OS_MUTEX_INVALID_ID != mid, OS_FAILURE );

    mutex_context(mid)->info.current_val --;
    pthread_mutex_unlock( &mutex_pthread_t(mid) );
    
    return OS_SUCCESS;
}

/**************************************************************************
* ƣ tp_os_mutex_info_get
*  ȡָϢ
* ˵midıʶ
                              info_ptrϢĴ洢ṹ
*   ֵ    ɹ򷵻OS_SUCCESS򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
OS_STATUS tp_os_mutex_info_get( OS_MUTEX_ID mid, OS_MUTEX_INFO *info_ptr )
{
    TP_OS_ASSERTEx( OS_MUTEX_INVALID_ID != mid, OS_FAILURE );
    TP_OS_ASSERTEx( NULL != info_ptr, OS_FAILURE );

    tp_os_mem_cpy( info_ptr, &mutex_info(mid), sizeof(OS_MUTEX_INFO) );

    return OS_SUCCESS;
}
/**************************************************************************
* ƣ mutex_context_add
* 
* ˵
*   ֵ	  ɹ򷵻OS_SUCCESS򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
static SINT32 mutex_context_add_bk( OSA_MUTEX_CONTEXT **p_context )
{
    /*OSA_MUTEX_CONTEXT   *p_mutex_context = NULL;
    pthread_mutexattr_t        attr;

    p_mutex_context = (OSA_MUTEX_CONTEXT *)tp_os_mem_malloc( sizeof(OSA_MUTEX_CONTEXT) );
    if ( NULL == p_mutex_context )
    {

        return OS_FAILURE;
    }
    tp_os_mem_set( p_mutex_context, 0, sizeof(OSA_MUTEX_CONTEXT) );

    pthread_mutexattr_init(&attr);
    pthread_mutexattr_settype(&attr,PTHREAD_MUTEX_RECURSIVE_NP);//ûĵݹ
    pthread_mutex_init(&p_mutex_context->p_mutex_t,&attr);//
    pthread_mutex_destroy(&attr);
    p_mutex_context->info.id = (OS_MUTEX_ID)p_mutex_context;

    *p_context = p_mutex_context;*/

    return OS_SUCCESS;
}

static SINT32 mutex_context_add( OSA_MUTEX_CONTEXT **p_context )
{
    static int mutex_num=0;
  
    
    OSA_MUTEX_CONTEXT   *p_mutex_context = NULL;
    pthread_mutexattr_t        attr = {0};

    p_mutex_context = (OSA_MUTEX_CONTEXT *)tp_os_mem_malloc( sizeof(OSA_MUTEX_CONTEXT) );
    if ( NULL == p_mutex_context )
    {
        return OS_FAILURE;
    }
    tp_os_mem_set( p_mutex_context, 0, sizeof(OSA_MUTEX_CONTEXT) );
  mutex_num++;
  //printf("mutex_context_add  mutex_num=%d\n",mutex_num);
    pthread_mutexattr_init(&attr);
    pthread_mutexattr_settype(&attr,PTHREAD_MUTEX_RECURSIVE_NP);//ûĵݹ
    //p_mutex_context->p_mutex_t = PTHREAD_MUTEX_INITIALIZER;
    pthread_mutex_init(&p_mutex_context->p_mutex_t,&attr);//
    pthread_mutexattr_destroy(&attr);
    p_mutex_context->info.id = (OS_MUTEX_ID)p_mutex_context;

    *p_context = p_mutex_context;

    return OS_SUCCESS;
}


/**************************************************************************
* ƣ mutex_context_add
* 
* ˵
*   ֵ	  ɹ򷵻OS_SUCCESS򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
static VOID mutex_context_remove( OSA_MUTEX_CONTEXT *p_context )
{
    pthread_mutex_destroy( &p_context->p_mutex_t);

    tp_os_mem_free( p_context );
    p_context = NULL;
}
