/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:
 * File Mark:
 * Description:
 * Others:
 * Version:       1.0
 * Author:        wangxia
 * Date:          2007-12-01
 * History 1:
 *     Date:2009-03-04
 *     Version:
 *     Author: wangxia
 *     Modification: add ISR register and unregister function
 * History 2:
 *     Date:2009-07-20
 *     Version:
 *     Author: wangxia
 *     Modification: add UICC power on and power down function
*
 * History 3:
 *     Date: 2011-12-23
 *     Version:
 *     Author: wujinlei
 *     Modification:  modify uicc interrupt for 297502
  ********************************************************************************/

/****************************************************************************
* 	                                           Include files
****************************************************************************/
#include "pub.h"
#include "drvs_general.h"
#include "drvs_int.h"
#include "oss_api.h"

#include "drvs_pm.h"
/****************************************************************************
* 	                                           Local Macros
****************************************************************************/
/****************************************************************************
* 	                                           Local Types
****************************************************************************/

/****************************************************************************
* 	                                           Local Constants
****************************************************************************/

/****************************************************************************
* 	                                           Local Function Prototypes
****************************************************************************/

/****************************************************************************
* 	                                          Global Constants
****************************************************************************/

/****************************************************************************
* 	                                          Global Variables
****************************************************************************/

/****************************************************************************
* 	                                          Global Function Prototypes
****************************************************************************/

/****************************************************************************
* 	                                          Function Definitions
****************************************************************************/

/*******************************************************************************
 * Function: UICC_GetUiccVoltage
 * Description: get Uicc interface voltage
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns: 0:  USIM 2.9V                   1:USIM 1.8V
 *
 *
 * Others:
 ********************************************************************************/

UINT32 UICC_GetUiccVoltage(VOID)
{
 #if 0
  T_ZDrvPm_VsimType  usim_vcc;
  T_ZDrvPmic_LdoOnoff  usim_vcc_state;
  UINT32 Ret = 0xFFFFFFFF;

   usim_vcc = zDrvPmic_GetVsim();
   usim_vcc_state = zDrvPmic_GetVsimOnoff();

    if((usim_vcc == PM_VSIM_2_900)&&(usim_vcc_state == PM_LDO_ON))
   	{
       Ret = 0;/*2.9V*/
    }
    else if((usim_vcc == PM_VSIM_1_800)&&(usim_vcc_state == PM_LDO_ON))
    {
        Ret = 1;/*1.8V*/
    }
    else
    {
        zDrv_ASSERT((usim_vcc == PM_VSIM_2_900)||(usim_vcc == PM_VSIM_1_800));
    }

  return Ret;
  #else
  return 0;
  #endif
}


/*******************************************************************************
 * Function: halUicc_PowerUp
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/

SINT32 UICC_PowerUp_2V9(VOID)
{
#if 0

   zDrvPmic_SetVsim(PM_VSIM_2_900);
#endif
#if defined (_CORE_ARM0)
    zDrvPmic_SetNormal_Voltage(VSIM1, PM_VOLT_3_000);//xuzhiguo
    zDrvPmic_SetNormal_Onoff(VSIM1, PM_ENABLE);
#endif
   return DRV_SUCCESS;
}



/*******************************************************************************
 * Function:
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/

SINT32 UICC_PowerUp_1V8(VOID)
{
  #if 0

   zDrvPmic_SetVsim(PM_VSIM_1_800);
#endif

#if defined (_CORE_ARM0)
    //zDrvPmic_SetVsim(PM_VSIM_1_800);
    //zDrvPmic_SetVsimOnoff(PM_LDO_ON);

    zDrvPmic_SetNormal_Voltage(VSIM1, PM_VOLT_1_800);//xuzhiguo
    zDrvPmic_SetNormal_Onoff(VSIM1, PM_ENABLE);
#endif

   return DRV_SUCCESS;
}


/*******************************************************************************
 * Function: halUicc_PowerDown
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/

SINT32 UICC_PowerDown(VOID)
{
#if 0

	zDrvPmic_SetVsimOnoff(PM_LDO_OFF);
#endif
#if defined (_CORE_ARM0)
    //zDrvPmic_SetVsimOnoff(PM_LDO_OFF);
    zDrvPmic_SetNormal_Onoff(VSIM1, PM_DISABLE);
#endif
	return DRV_SUCCESS;
}

/*******************************************************************************
 * Function: UICC_registerISR
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
SINT32 UICC_InstallIsr(VOID *pIsr,UINT32 intLine)
{
   SINT32  errCode =DRV_SUCCESS;

   zOss_AssertEx( NULL!=pIsr, DRV_ERR_INVALID_PARAM );
#ifdef _OS_TOS
    errCode = zDrvInt_InstallIsr(intLine,(VOID *)pIsr,"Uicc",INT_DEFAULT_LEVEL);
#elif defined(_OS_LINUX)
	errCode = zDrvInt_InstallFastIsr(intLine,(VOID *)pIsr,"Uicc",INT_DEFAULT_LEVEL);
#endif
    if(0>errCode)
    {
        return errCode;
    }
    return DRV_SUCCESS;
}
/*******************************************************************************
 * Function: UICC_UnregisterISR
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
SINT32 UICC_UninstallIsr(UINT32 intLine)
{
	SINT32  errCode = DRV_SUCCESS;

	errCode = zDrvInt_UninstallIsr(intLine);

    if ( 0 > errCode )
    {
        return errCode;
    }
    return DRV_SUCCESS;
}


