#inherit externalsrc package

DESCRIPTION = "liblynq-at-common"
LICENSE = "CLOSED"
LIC_FILES_CHKSUM = "file://LICENSE;md5=3f86c7f456a6d0bbeca155e65084eee1"
DEPENDS += "liblynq-log liblynq-qser-autosuspend  liblynq-led"
#inherit workonsrc
WORKONSRC = "${TOPDIR}/../src/lynq/lib/liblynq-at-common/"
FILESEXTRAPATHS_prepend :="${TOPDIR}/../src/lynq/lib/:"
SRC_URI = " \
          file://liblynq-at-common\
          "

SRC-DIR = "${S}/../liblynq-at-common"

TARGET_CC_ARCH += "${LDFLAGS}"
SYSTEMD_PACKAGES = "${PN}"
BB_INCLUDE_ADD = "--sysroot=${STAGING_DIR_HOST}"
BB_LDFLAGS_ADD = "--sysroot=${STAGING_DIR_HOST} -Wl,--hash-style=gnu"

EXTRA_OEMAKE = "'TARGET_PLATFORM = ${TARGET_PLATFORM}'"
EXTRA_OEMAKE += "'LYNQ_CONFIG_VERSION = ${LYNQ_CONFIG_VERSION}' \
                 'LYNQ_CONFIG_SW_VERSION = ${LYNQ_CONFIG_SW_VERSION}'"

FILES_${PN} += "${base_libdir}/*.so "

FILES_${PN}-dev = "/test \
                   ${includedir}"

FILES_${PN}-doc = "/doc"

FILES_${PN}-dbg ="${base_bindir}/.debug \
                  ${base_libdir}/.debug \
                  ${base_sbindir}/.debug"

INSANE_SKIP_${PN} += "already-stripped"
INSANE_SKIP_${PN} += "installed-vs-shipped"


#INHIBIT_PACKAGE_STRIP = "1"
do_compile () {
		oe_runmake all -C ${SRC-DIR} ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST} -Os -Wl,--hash-style=gnu -DTELEPHONYWARE"
}

do_install () {
    oe_runmake install -C ${SRC-DIR} ROOT=${D}

    if [ -d "${WORKONSRC}" ] ; then
        install -d ${D}${includedir}/
        cp -raf ${SRC-DIR}/include/ ${D}${includedir}/
    fi
}

addtask bachclean
do_bachclean () {
    oe_runmake clean
}
