#inherit externalsrc package
DESCRIPTION = "libpoweralarm.so "
SECTION = "base"
#LICENSE = "Mobiletek""
LICENSE = "CLOSED"
LIC_FILES_CHKSUM = "file://LICENSE;md5=d759532d295a4ec07250edf931caef80"
DEPENDS += "libpal liblynq-log liblynq-sim liblynq-network liblynq-uci"

#inherit workonsrc
WORKONSRC = "${TOPDIR}/../src/lynq/lib/liblynq-monitor/"

FILESEXTRAPATHS_prepend :="${TOPDIR}/../src/lynq/lib/:"
SRC_URI = " \
          file://liblynq-monitor \
          "
SRC-DIR = "${S}/../liblynq-monitor"
TARGET_CC_ARCH += "${LDFLAGS}"
BB_INCLUDE_ADD = "--sysroot=${STAGING_DIR_HOST}"
BB_LDFLAGS_ADD = "--sysroot=${STAGING_DIR_HOST} -Wl,--hash-style=gnu"

#Parameters passed to do_compile()
EXTRA_OEMAKE = "'RAT_CONFIG_C2K_SUPPORT = ${RAT_CONFIG_C2K_SUPPORT}'\
                'MTK_MULTI_SIM_SUPPORT = ${MTK_MULTI_SIM_SUPPORT}'\
                'TARGET_PLATFORM = ${TARGET_PLATFORM}'"
                
FILES_${PN} = "${base_libdir}/*.so \
               ${base_bindir}\
               ${base_sbindir}"


FILES_${PN}-dev = "/test \
                   ${includedir}"

FILES_${PN}-doc = "/doc"

FILES_${PN}-dbg ="${base_bindir}/.debug \
                  ${base_libdir}/.debug \
                  ${base_sbindir}/.debug"

INSANE_SKIP_${PN} += "already-stripped"
INSANE_SKIP_${PN} += "installed-vs-shipped"


#INHIBIT_PACKAGE_STRIP = "1"
do_compile () {
		oe_runmake all -C ${SRC-DIR} ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST} -Os -Wl,--hash-style=gnu -DTELEPHONYWARE"
}

do_install () {
    oe_runmake install -C ${SRC-DIR} ROOT=${D}
	
    if [ -d "${WORKONSRC}" ] ; then
        install -d ${D}${includedir}/
        cp -af ${SRC-DIR}/include/ ${D}${includedir}/
    fi 
}

addtask bachclean
do_bachclean () {
    oe_runmake clean
}
