/*******************************************************
* 
* @brief:
* @details:  add fota A/B backup service 
* @author:   l.yang
* @date:     2023.8.29
* @version:  V1.0
* @copyright：Copyright (c) MobileTek 
*
*********************************************/


#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <dlfcn.h>
#include <string.h>
#include <pthread.h>
#include <stdint.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <liblog/lynq_deflog.h>


#ifdef __cplusplus
extern "C" {
#endif

#define FOTA_REBOOT_FLAG "/mnt/userdata/.fota_reboot_flag"
#define FOTA_FLAG_FILE "/mnt/userdata/.back_up_flag"
#define FOTA_SYNC_FLAG    1
#define FOTA_CURRENT_SYS  "/mnt/userdata/.fota_current_sys"

#define USER_LOG_TAG "LYNQ_FOTA_BACKUP"

extern int lynq_sync_system();
extern int lynq_fota_get_addr_value(char *tmp_value);
extern int lynq_fota_set_addr_value(char        *value,int size);
extern int lynq_fota_nrestart(void);
extern int lynq_get_current_system();


#define REBOOT_DONE  1

void set_upgrade_reboot_flag(void)
{
    FILE *fp = NULL;
    int reboot_flag = REBOOT_DONE;
    fp = fopen(FOTA_REBOOT_FLAG,"w+");
    if(fp == NULL)
    {
        LYERRLOG("Open reboot flag file failed\n");
        return;
    }
    
    fwrite(&reboot_flag,sizeof(int),1,fp);
    fclose(fp);
    system("sync");
    return ;
}

int check_need_sync()
{
    int current_sys = 0;
    int record_sys = 0;
    int ret = 0;
    char tmp_sys[8] = {0};
    FILE *fp = NULL;

    //not fota 
    if(access(FOTA_FLAG_FILE, F_OK) == -1)
    {
        LYINFLOG("Fota flag file no exist\n");

        //file no exist,get current sys write to file
        if(access(FOTA_CURRENT_SYS,F_OK) == -1)
        {
            LYINFLOG("Record current sys file no exist\n");
            
            fp = fopen(FOTA_CURRENT_SYS,"w");
            if(fp == NULL)
             {
                LYERRLOG("creat  record current file failed\n");
                return -1;
            }
            current_sys = lynq_get_current_system();
            if(current_sys < 0)
            {
                LYERRLOG("Get current system failed %d\n",current_sys);
                fclose(fp);
                return -1;
            }
            else
            {
                
                LYINFLOG("Get current system success  %d\n",current_sys);
                fprintf(fp, "%d", current_sys);
                fclose(fp);
                system("sync");
                
                return 0;
            }
        }
        else
        {
            current_sys = lynq_get_current_system();
            if(current_sys < 0)
            {
                LYERRLOG("Get current system failed %d\n",current_sys);
                return -1;
            }

            LYINFLOG("Get current system success  %d\n",current_sys);
            
            fp = fopen(FOTA_CURRENT_SYS,"r");
            if(fp == NULL)
            {
                LYERRLOG("read file failed \n");
                return -1;
            }
        
            if(fgets(tmp_sys, sizeof(tmp_sys), fp) != NULL)
            {
                record_sys = atoi(tmp_sys);
            }
            else
            {
                LYERRLOG("tmp_sys is NULL");
                fclose(fp);
                return -1;
            }
            
            if( record_sys == current_sys)
            {
                LYINFLOG("System not need sync \n");
                fclose(fp);
                return 0;
            }
            else 
            {
                LYINFLOG("System need sync \n");
                ret = lynq_sync_system();
                if(ret < 0 )
                {
                    LYERRLOG("A/B sync system failed \n");
                    return -1;
                }
                LYINFLOG("A/B sync system success,record current sys \n");
                fp = fopen(FOTA_CURRENT_SYS,"w");
                if(fp == NULL)
                {
                    LYERRLOG("creat file failed  \n");
                    return -1;
                }
                
                fprintf(fp,"%d",current_sys);
                fclose(fp);
                system("sync");
                
                
                return 0;
            }
        }
            
        
    }
    else
    {
        fp = fopen(FOTA_CURRENT_SYS,"w");
        if(fp == NULL)
        {
            LYERRLOG("Creat file failed \n");
            return -1;
        }
        LYINFLOG("fota flag file exist,record current sys \n");
        current_sys = lynq_get_current_system();
        if(current_sys < 0)
        {
            LYERRLOG("Get current system failed %d\n",current_sys);
            return -1;
        }
        
        fprintf(fp,"%d",current_sys);
        fclose(fp);
        system("sync");
        return 0;
    }
           

}

int main()
{
    int ret = 0 ;
    int sync_flag = 0;
    char tmp_addr[128] = {0};
    FILE *fp = NULL;

    check_need_sync();

    fp = fopen(FOTA_FLAG_FILE,"r");
    if(fp == NULL)
    {
        LYERRLOG("No need fota sync\n");
        return -1;

    }

    fread(&sync_flag,sizeof(int),1,fp);
    fclose(fp);
    
    set_upgrade_reboot_flag();
    
    if(sync_flag == FOTA_SYNC_FLAG)
    {
        ret = lynq_sync_system();
        if(ret != 0)
        {
            LYERRLOG("sync faild\n");
        }
       system("rm -rf /mnt/userdata/.back_up_flag");
        
    }
    else if(sync_flag != FOTA_SYNC_FLAG)
    {
        ret = lynq_fota_get_addr_value(tmp_addr);
        if(ret != 0)
        {
            LYERRLOG("Get addr failed\n");
            return -1;
        }
        LYINFLOG("tmp_addr is %s\n",tmp_addr);
        ret = lynq_fota_set_addr_value(tmp_addr,10);
        if(ret != 0)
        {
            LYERRLOG("Set addr failed\n");
            return -1;
        }
        ret = lynq_fota_nrestart();
        if(ret != 0)
        {
            LYERRLOG("Upgrade failed\n");
            return -1;
        }
        
    }
   
    return 0;

}
DEFINE_LYNQ_LIB_LOG(LYNQ_FOTA_BACKUP)

#ifdef __cplusplus
}
#endif

