#inherit externalsrc package

DESCRIPTION = "lynq sdk-ready sev"
LICENSE = "CLOSED"
LIC_FILES_CHKSUM = "file://LICENSE;md5=b1e07e8d88e26263e71d3a9e2aa9a2ff"
DEPENDS += "liblynq-uci liblynq-log "
#inherit workonsrc
WORKONSRC = "${TOPDIR}/../src/lynq/framework/lynq-sdk-ready"
FILESEXTRAPATHS_prepend :="${TOPDIR}/../src/lynq/framework/:"
SRC_URI = " \
          file://lynq-sdk-ready \
          "

SRC-DIR = "${S}/../lynq-sdk-ready"
TARGET_CC_ARCH += "${LDFLAGS}"
SYSTEMD_PACKAGES = "${PN}"
SYSTEMD_SERVICE_${PN} = "lynq_sdk_ready.service"
FILES_${PN} += "${systemd_unitdir}/system/lynq_sdk_ready.service"
FILES_${PN} += "/system/etc/tele/ring ${bindir}"
#Parameters passed to do_compile()
EXTRA_OEMAKE = "'RAT_CONFIG_C2K_SUPPORT = ${RAT_CONFIG_C2K_SUPPORT}'\
                'MTK_MULTI_SIM_SUPPORT = ${MTK_MULTI_SIM_SUPPORT}'\
                'TARGET_PLATFORM = ${TARGET_PLATFORM}'\
                'MTK_LED_SUPPORT = ${MTK_LED_SUPPORT}'\
                'TARGET_PLATFORM = ${TARGET_PLATFORM}'"


#INHIBIT_PACKAGE_STRIP = "1"
do_compile () {
	if test "${PACKAGE_ARCH}" = "cortexa7hf-vfp-vfpv4-neon" || test "${PACKAGE_ARCH}" = "cortexa7hf-neon-vfpv4"; then
		oe_runmake all -C ${SRC-DIR} ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST} -mhard-float"
	else
		oe_runmake all -C ${SRC-DIR} ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST}"
	fi
}

do_install() {
	install -d ${D}${bindir}/
	install -m 0755 ${SRC-DIR}/lynq-sdk-ready ${D}${bindir}/
	if ${@bb.utils.contains('DISTRO_FEATURES','systemd','true','false',d)}; then
		install -d ${D}${systemd_unitdir}/system/
		install -m 0644 ${B}/lynq_sdk_ready.service ${D}${systemd_unitdir}/system
	else
		install -d ${D}${sysconfdir}/init.d
		install -m 0755  ${SRC-DIR}/lynq-sdk-ready.sh ${D}${sysconfdir}/init.d/lynq-sdk-ready.sh
		install -d ${D}${sysconfdir}/rcS.d
		ln -s ../init.d/lynq-sdk-ready.sh ${D}${sysconfdir}/rcS.d/S23lynq-sdk-ready
	fi
}
