#!/bin/sh
#
# zxic Yocto Project Build Environment Setup Script
#
. sources/meta-zxic-custom/tools/setup-utils.sh

CWD=`pwd`
PROGNAME="setup-environment"
exit_message ()
{
   echo "To return to this build environment later please run:"
   echo "source setup-environment <build_dir>"
}

usage()
{
    echo -e "\nUsage: source zxic-setup-release.sh
    Optional parameters: [-b build-dir] [-h]"
echo "
    * [-b build-dir]: Build directory, if unspecified script uses 'build' as output directory
    * [-h]: help
"
}

clean_up()
{
    unset CWD BUILD_DIR 
    unset zxic_setup_help zxic_setup_error zxic_setup_flag
    unset usage clean_up
    exit_message clean_up
}

# get command line options
OLD_OPTIND=$OPTIND

while getopts "k:r:t:b:e:gh" zxic_setup_flag
do
    case $zxic_setup_flag in
        b) BUILD_DIR="$OPTARG";
           echo -e "\n Build directory is " $BUILD_DIR
           ;;
        h) zxic_setup_help='true';
           ;;
        \?) zxic_setup_error='true';
           ;;
    esac
done
shift $((OPTIND-1))
if [ $# -ne 0 ]; then
    zxic_setup_error=true
    echo -e "Invalid command line ending: '$@'"
fi
OPTIND=$OLD_OPTIND
if test $zxic_setup_help; then
    usage && clean_up && return 1
elif test $zxic_setup_error; then
    clean_up && return 1
fi

if [ -z "$DISTRO" ]; then
    DISTRO='cpe'
fi

if [ -z "$BUILD_DIR" ]; then
    BUILD_DIR='build'
fi

if [ -z "$MACHINE" ]; then
    MACHINE='zx297520v3'
fi

if [ -z "$SDK" ]; then
    MK_SDK_VERSION='no'
else
    MK_SDK_VERSION=$SDK
fi

if [ -z "$BOOT_CTL" ]; then
    BOOT_CTL='normal'
else
    BOOT_CTL=$BOOT_CTL
fi

if [ -z "$STRORAGE_CONF" ]; then
    STRORAGE_CONF='nand-config-default'
else
    STRORAGE_CONF=$STRORAGE_CONF
fi

# Set up the basic yocto environment
rm -fr $BUILD_DIR/conf/
DISTRO=$DISTRO MACHINE=$MACHINE MK_SDK_VERSION=$MK_SDK_VERSION BOOT_CTL=$BOOT_CTL STRORAGE_CONF=$STRORAGE_CONF . ./$PROGNAME $BUILD_DIR

# Point to the current directory since the last command changed the directory to $BUILD_DIR
BUILD_DIR=.

if [ ! -e $BUILD_DIR/conf/local.conf ]; then
    echo -e "\n ERROR - No build directory is set yet. Run the 'setup-environment' script before running this script to create " $BUILD_DIR
    echo -e "\n"
    return 1
fi

# On the first script run, backup the local.conf file
# Consecutive runs, it restores the backup and changes are appended on this one.
if [ ! -e $BUILD_DIR/conf/local.conf.org ]; then
    cp $BUILD_DIR/conf/local.conf $BUILD_DIR/conf/local.conf.org
else
    cp $BUILD_DIR/conf/local.conf.org $BUILD_DIR/conf/local.conf
fi

if [ ! -e $BUILD_DIR/conf/bblayers.conf.org ]; then
    cp $BUILD_DIR/conf/bblayers.conf $BUILD_DIR/conf/bblayers.conf.org
else
    cp $BUILD_DIR/conf/bblayers.conf.org $BUILD_DIR/conf/bblayers.conf
fi

echo "" >> $BUILD_DIR/conf/bblayers.conf
echo "# zxic Yocto Project Release layers" >> $BUILD_DIR/conf/bblayers.conf

hook_in_layer meta-zxic-custom
echo "" >> $BUILD_DIR/conf/bblayers.conf
echo "BBLAYERS += \" \${BSPDIR}/sources/meta-zxic \"" >> $BUILD_DIR/conf/bblayers.conf
echo "BBLAYERS += \" \${BSPDIR}/sources/meta-selinux \"" >> $BUILD_DIR/conf/bblayers.conf
echo "BBLAYERS += \" \${BSPDIR}/sources/meta-zxic-selinux \"" >> $BUILD_DIR/conf/bblayers.conf
#echo "BBLAYERS += \" \${BSPDIR}/sources/meta-toolchain/meta-external-toolchain \"" >> $BUILD_DIR/conf/bblayers.conf
#echo "BBLAYERS += \" \${BSPDIR}/sources/meta-toolchain/meta-sourcery \"" >> $BUILD_DIR/conf/bblayers.conf

echo "BBLAYERS += \" \${BSPDIR}/sources/meta-openembedded/meta-oe \"" >> $BUILD_DIR/conf/bblayers.conf
echo "BBLAYERS += \" \${BSPDIR}/sources/meta-openembedded/meta-python \"" >> $BUILD_DIR/conf/bblayers.conf
echo "BBLAYERS += \" \${BSPDIR}/sources/meta-openembedded/meta-networking \"" >> $BUILD_DIR/conf/bblayers.conf
if [ x"$DISTRO" = x"cpe" ] || [ x"$DISTRO" = x"v2x-openwrt" ] || [ x"$DISTRO" = x"v2x-16bit" ]; then
    echo "BBLAYERS += \" \${BSPDIR}/sources/meta-openwrt \"" >> $BUILD_DIR/conf/bblayers.conf
  ##  echo "BBLAYERS += \" \${BSPDIR}/sources/meta-zxic-openwrt-selinux \"" >> $BUILD_DIR/conf/bblayers.conf
fi
#TCLIBC=`bitbake -e | grep 'TCLIBC='|cut -d'=' -f2|tr -d '"'`
#LIBCPATH=$(cat $(pwd)/../sources/meta-toolchain/toolchain/toolchain-$TCLIBC/toolchain-shar-extract.sh |grep 'LIBC_PATH='|cut -d'=' -f2|tr -d '"')
#if [ ! -f $LIBCPATH/toolchain-shar-extract.sh ] ; then
#	. $(pwd)/../sources/meta-toolchain/toolchain/toolchain-$TCLIBC/toolchain-shar-extract.sh
#fi

cd  $BUILD_DIR
clean_up

