DESCRIPTION = "softap_demo"
DEPENDS     = "libsoftap libatutils libsofttimer libnvram"
SECTION     = "app"
LICENSE     = "zte"
PV = "1.0.0"
PR = "r0"

CLASS_COM = " \
    ${@bb.utils.contains('DISTRO_FEATURES', 'procd', 'openwrt openwrt-services', '', d)} \
    ${@bb.utils.contains('DISTRO_FEATURES', 'systemd', 'systemd', '', d)} \
"
inherit ${CLASS_COM}

#配置code路径信息。
FILESEXTRAPATHS_prepend :="${APP-OPEN-PATH}:"
SRC_URI = " \
          file://test/softap_demo \		  
		  ${@bb.utils.contains("DISTRO_FEATURES", "procd", "file://softap_demo.init","", d)} \
		  ${@bb.utils.contains("DISTRO_FEATURES", "systemd", "file://softap_demo.service","", d)} \
          "
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"
S = "${WORKDIR}"
S_SRC_PATH = "${S}/test/softap_demo"
#引用公用头文件和编译选项。
include ${BSPDIR}/sources/meta-zxic/conf/app_com.inc

#inherit autotools pkgconfig systemd

do_compile() {
	make -C ${S_SRC_PATH}
}

do_install () {
	install -d ${D}${bindir}/
	install -m 0755 ${S_SRC_PATH}/softap_demo ${D}${bindir}/
	
	if ${@bb.utils.contains('DISTRO_FEATURES','procd','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/softap_demo.init ${D}${sysconfdir}/init.d/softap_demo
	fi

	if ${@bb.utils.contains('DISTRO_FEATURES','systemd','true','false',d)}; then
		install -d ${D}${systemd_unitdir}/system
		install -m 0644 ${WORKDIR}/softap_demo.service ${D}${systemd_unitdir}/system
	fi
	
	#install elfs
	install -d ${ELFS-PATH}/
	install -m 0755 ${S_SRC_PATH}/softap_demo ${ELFS-PATH}/	
}

do_cleanlibs () {
	rm -fr ${ELFS-PATH}/softap_demo
}

addtask  cleanlibs after do_clean  before do_cleansstate

FILES_${PN} = "\
    ${bindir}/ \
    ${@bb.utils.contains("DISTRO_FEATURES", "procd", "${sysconfdir}/init.d/softap_demo","", d)} \
    "
SYSTEMD_SERVICE_${PN}     = "softap_demo.service"
SYSTEMD_AUTO_ENABLE_${PN} = "disable"

RDEPENDS_${PN} = " libsoftap libatutils libsofttimer libnvram"
