# Note, we can probably remove the lzma option as it has be replaced with xz,
# and I don't think the kernel supports it any more.

DESCRIPTION = "Tools for manipulating OpenWrt SquashFS filesystems"
SECTION = "base"
LICENSE = "GPL-2"
LIC_FILES_CHKSUM = "file://COPYING;md5=b234ee4d69f5fce4486a80fdaf4a4263"

PV = "4.14"

SRC_URI = "http://sources.cdn.openwrt.org/squashfskit-v${PV}.tar.xz \
			file://0001-fix-version.sh.patch \
			file://0002-fix-build-failure-against-gcc-10.patch \
			file://0010-portability.patch \
"
SRC_URI[md5sum] = "a5a6412dacdef9436f1ee40506e6cfc7"
SRC_URI[sha256sum] = "5761aaa3aedc4f7112b708367d891c9abdc1ffea972e3fe47923ddba23984d95"

S = "${WORKDIR}/squashfskit-v${PV}"

EXTRA_OEMAKE = "${PACKAGECONFIG_CONFARGS}"

PACKAGECONFIG ??= "gzip xz lzo lz4 zstd lzma xattr reproducible"
PACKAGECONFIG[gzip] = "GZIP_SUPPORT=1,GZIP_SUPPORT=0,zlib"
PACKAGECONFIG[xz] = "XZ_SUPPORT=1,XZ_SUPPORT=0,xz"
PACKAGECONFIG[lzo] = "LZO_SUPPORT=1,LZO_SUPPORT=0,lzo"
PACKAGECONFIG[lz4] = "LZ4_SUPPORT=1,LZ4_SUPPORT=0,lz4"
PACKAGECONFIG[lzma] = "LZMA_XZ_SUPPORT=1,LZMA_XZ_SUPPORT=0,xz"
PACKAGECONFIG[xattr] = "XATTR_SUPPORT=1,XATTR_SUPPORT=0,attr"
PACKAGECONFIG[zstd] = "ZSTD_SUPPORT=1,ZSTD_SUPPORT=0,zstd"
PACKAGECONFIG[reproducible] = "REPRODUCIBLE_DEFAULT=1,REPRODUCIBLE_DEFAULT=0,"

do_compile() {
	make -C squashfs-tools \
	XZ_SUPPORT=1 \
    LZMA_XZ_SUPPORT=1 \
    XATTR_SUPPORT=1 \
	GZIP_SUPPORT=1 \
	LZO_SUPPORT=1 \
	LZ4_SUPPORT=1 \
	ZSTD_SUPPORT=1 \
    mksquashfs unsquashfs
}


do_install() {
	install -Dm0755 squashfs-tools/mksquashfs ${D}${sbindir}/mksquashfs4
	install -Dm0755 squashfs-tools/unsquashfs ${D}${sbindir}/unsquashfs4
}


BBCLASSEXTEND = "native"

CVE_PRODUCT = "squashfskit"
