DESCRIPTION = "mkimgsig"
SECTION     = "mkimgsig"
LICENSE     = "zte"
PV = "1.0.0"
PR = "r0"

SRC_URI_zx297520v3 = " \
    file://${ELFS-PATH}/uImage \
    "

SRC_URI[sha256sum] = "054819ffb4eb9e670f762e56d3496ee7018b5c3473d8b83c7f3fa6de02a37bc8"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"
S = "${WORKDIR}"

DEPENDS  += "\
    u-boot-tools-native dtc-native \
    "

#pub include
include ${BSPDIR}/sources/meta-zxic/conf/pub.inc

do_configure[nostamp] = "1"

KERNEL_BIN_NAME = "${@bb.utils.contains("BOOT_CTL", "recovery", "ap_recovery.bin", "ap_cpucap.bin", d)}"

#编译
EXTRA_OEMAKE_append = "S=${S}  BINS-PATH=${BINS-PATH}  DISTRO=${DISTRO} BOOT_CTL=${BOOT_CTL}"
do_compile() {
	if [ ${MACHINE} = 'zx297520v3' ];	then
		rm -rf ${S}/input && mkdir -p ${S}/input
		cp -rf ${ELFS-PATH}/uImage                	  ${S}/input/uImage
		${BSPDIR}/tools/SignTool/SignImage -i ${S}/input/uImage -o ${S}/${KERNEL_BIN_NAME} -k  ${SIGNIMAGE_PRIVATE_KEY}
		cp -rf ${S}/${KERNEL_BIN_NAME} ${BINS-PATH}/
	fi
}


#清image
do_cleanimage () {
	rm -fr ${BINS-PATH}/${KERNEL_BIN_NAME}
}

addtask  do_cleanimage after do_clean  before do_cleansstate
