#!/usr/bin/python3
# -*- coding: utf-8 -*-

import sys

conf_sample='''/*
 * U-Boot uImage source file
 */

/dts-v1/;

/ {
    description = "U-Boot uImage source file";

    images {
        #address-cells = <2>;
        #size-cells = <1>;
        kernel@A9 {
            description = "Unify(TODO) Linux kernel";
            data = /incbin/("./input/Image");
            type = "kernel";
            arch = "arm";
            os = "linux";
            compression = "none";
            load = <0x00000000 %s>;
            entry = <0x00000000 %s>;
            reg=<0x0 0x0 0x0>;
        };
        fdt@zx297520v3 {
            description = "Flattened Device Tree blob";
            data = /incbin/("./input/%s");
            type = "flat_dt";
            arch = "arm";
            compression = "none";
            reg=<0x0 0x0 0x0>;
        };
    };

    configurations {
        #address-cells = <2>;
        #size-cells = <1>;
        default = "conf@%s";
        conf@zx297520v3 {
            description = "Boot Linux kernel with FDT blob";
            kernel = "kernel@A9";
            fdt = "fdt@%s";
            reg=<0x0 0x0 0x0>;
        };
    };
};
'''
def gen_main(chip_name, kernel_addr, dtb_file, its_file):
	fd = open(its_file, 'w')
	data_buf = conf_sample % (kernel_addr, kernel_addr, dtb_file, chip_name, chip_name)
	fd.write(data_buf)
	fd.close()

if __name__ == '__main__':
    argc = len(sys.argv)
    if (argc < 5):
        print("usage:\n %s chip_name kernel_addr dtb_file its_file" % sys.argv[0])
        exit(-1)
    chip_name = sys.argv[1]
    kernel_addr = sys.argv[2]
    dtb_file = sys.argv[3]
    its_file = sys.argv[4]
    print("gen_fdt_its chip_name:%s kernel_addr:%s dtb_file:%s out_its_file:%s" % (chip_name, kernel_addr, dtb_file, its_file))
    gen_main(chip_name, kernel_addr, dtb_file, its_file)
