# zxic  Distro for CPE.

#require conf/distro/poky.conf
require conf/distro/poky-tiny.conf

DISTRO          = "cpe"
DISTRO_NAME     = "zxic Distro CPE"
DISTRO_VERSION  = "1.0"
SDK_VENDOR      = "-zxic"
MAINTAINER      = "Sanechips Co.，Ltd."
TARGET_VENDOR   = "-zxic"
DISTROOVERRIDES = "cpe"

# multilib app 32bit  kernel 64bits
#require conf/multilib.conf
#MULTILIBS = "multilib:lib32"
#DEFAULTTUNE_virtclass-multilib-lib32 = "armv7a"

ROOT_HOME ?= "/root"

#define BSDPDIR for esdk
BSPDIR ?= "${TOPDIR}"
# zxic version path
BINS-PATH     = "${BSPDIR}/../allbins/${MACHINE}/${DISTRO}/bins"
ELFS-PATH     = "${BSPDIR}/../allbins/${MACHINE}/${DISTRO}/elf/${BOOT_CTL}"
SRC-PATH      = "${BSPDIR}/zxic_code/zxic_source/"
APP-PATH      = "${BSPDIR}/zxic_code/zxic_source/zxic_app"
APP-OPEN-PATH = "${BSPDIR}/zxic_code/zxic_source/zxic_app_open"
RELEASE-PATH  = "${BSPDIR}/zxic_code/zxic_binary/zxic_app_release/${TCLIBC}"
FS-DIR        = "${BSPDIR}/sources/meta-zxic-custom/recipes-core/images/files/${MACHINE}/${DISTRO}"

PSEUDO_IGNORE_PATHS .= ",${BINS-PATH},${ELFS-PATH},${RELEASE-PATH}"

#exeternal toolchain
#TCMODE = "external-sourcery"
#EXTERNAL_TOOLCHAIN = "${BSPDIR}/sources/meta-toolchain/toolchain/toolchain-musl"
PACKAGE_DEBUG_SPLIT_STYLE = "debug-without-src"

#INHERIT += " openwrt-distro-defaults "
INHERIT += " ${@bb.utils.contains("DISTRO_FEATURES", "OPENWRT", "openwrt-distro-defaults", "", d)} "

# external toolschain  musl 
TCLIBC = "musl"
#PREFERRED_PROVIDER_musl               = "musl-external"
#PREFERRED_PROVIDER_virtual/libc       = "musl-external"
#PREFERRED_PROVIDER_virtual/libiconv   = "musl-external"
#PREFERRED_PROVIDER_virtual/libintl    = "musl-external"
#PREFERRED_PROVIDER_virtual/crypt      = "musl-external"
#PREFERRED_PROVIDER_linux-libc-headers = "musl-external"
#PREFERRED_PROVIDER_virtual/nativesdk-libintl  = "nativesdk-glibc"
#PREFERRED_PROVIDER_virtual/nativesdk-libiconv = "nativesdk-glibc"

PREFERRED_PROVIDER_virtual/kernel  = "linux-zxic"
#PREFERRED_VERSION_linux-zxic      = "4.14%"
#LINUX_CONFIG                      = "v4-cpe-${BOOT_CTL}-defconfig"
PREFERRED_VERSION_linux-zxic       = "5.4%"
LINUX_CONFIG                       = "v5-cpe-${BOOT_CTL}-defconfig"
#PREFERRED_PROVIDER_virtual/kernel = "linux-zxic"

#
# Use busybox/mdev for system initialization
#
VIRTUAL-RUNTIME_dev_manager    = "${@bb.utils.contains("DISTRO_FEATURES", "OPENWRT", "procd", "busybox", d)}"
VIRTUAL-RUNTIME_login_manager  = "busybox"
VIRTUAL-RUNTIME_init_manager   = "${@bb.utils.contains("DISTRO_FEATURES", "OPENWRT", "procd", "busybox", d)}"
#VIRTUAL-RUNTIME_initscripts   = ""
#DISTRO_FEATURES_BACKFILL_CONSIDERED += "sysvinit"

zxic_app = ""
zxic_lib = ""
EXTRA_IMAGE_FEATURES_remove += " package-management opkg"
IMAGE_FEATURES_remove        = "splash"

# product default set
WIFI_MODULE    ?= "realtek"
WIFI_FUNCTION  ?= "ap sta"

GLOBAL_DEBUG   ?= "no"
CUSTOM_MACRO   += " ${@bb.utils.contains("GLOBAL_DEBUG", "yes", "-DGLOBAL_DEBUG", "", d)} "

#DISTRO_FEATURES += "MMI_LCD"

#rootfs set
IMAGE_FSTYPES ?= "jffs2 "

#rootfs jffs2 fs配置参数
PAGESIZE      ?= "0x800"
ERASEBLOCK    ?= "0x20000"
EXTRA_IMAGECMD_jffs2 = "--pad ${JFFS2_ENDIANNESS} --eraseblock=${ERASEBLOCK} --no-cleanmarkers --pagesize=${PAGESIZE}"

#rootfs ubi fs配置参数 
UBI_VOLNAME  ?= "rootfs"

#rootfs ext4 fs配置参数 
EXTRA_IMAGECMD_ext4 ?= "-i 4096"

#userdata文件系统类型
USERDATA_FSTYPE       ?= "ubi ext4"

#userdata ext4 文件系统大小
EXTRA_USERDATACMD_ext4 ?= "-i 4096"
USERDATA_EXT4SIZE      ?= "194018"

#配置MMI LCD
CUSTOM_MACRO += " ${@bb.utils.contains("DISTRO_FEATURES", "MMI_LCD", "-DDISABLE_LCD", "", d)} "

#DISTRO_ARM_INSTRUCTION ?= "thumb"
CFLAGS_append_arm += " ${@bb.utils.contains("DISTRO_ARM_INSTRUCTION", "thumb", "-mthumb -mthumb-interwork -Wa,-mimplicit-it=thumb", "", d)} "

# custom macro for lib and app
CUSTOM_MACRO += "\
    -DAPP_OS_LINUX=1 -DAPP_OS_TYPE=APP_OS_LINUX  -DFOTA_RB_DL    \
    -DPRODUCT_MIFI_CPE=0  -DPRODUCT_PHONE=1 -DPRODUCT_DATACARD=2 \
    "

CONNECTIVITY_CHECK_URIS = "https://it.zte.com.cn"
SANITY_TESTED_DISTROS   = ""
ERROR_QA_remove         = " compile-host-path file-rdeps"
DISTRO_FEATURES_remove  = "ptest" 
PACKAGE_CLASSES         = "package_ipk"

