#!/bin/bash

if [ $# -ne 6 ]; then
    echo "$0 error"
    echo "Usage:"
    echo "        $0 mtd_name dirname outfile mkubifs_para vol_size ubinize_para"
    exit  -1
fi

mtdname=$1
dirname=$2
outfile=$3
workdir=$(dirname $outfile)
mkubifs_para=$4
vol_size_MB=$5
ubinize_para=$6

echo "mtdname:$mtdname"
echo "dirname:$dirname"
echo "outfile:$outfile"
echo "mkubifs_para:$mkubifs_para"
echo "vol_size_MB:$vol_size_MB"
echo "ubinize_para:$ubinize_para"


mkfs.ubifs -r $dirname -o ${workdir}/${mtdname}.ubifs  $mkubifs_para
if [ $? -ne 0 ]; then
    echo "mkfs.ubifs error"
    exit -1
else
    echo "mkfs.ubifs ok"
fi

cfg_file_name=${workdir}/$mtdname.cfg

echo "[$mtdname]"                           > $cfg_file_name
echo "mode=ubi"                            >> $cfg_file_name
echo "image=${workdir}/${mtdname}.ubifs"   >> $cfg_file_name
echo "vol_id=0"                            >> $cfg_file_name
echo "vol_size=${vol_size_MB}"             >> $cfg_file_name
echo "vol_type=dynamic"                    >> $cfg_file_name
echo "vol_name=${mtdname}"                 >> $cfg_file_name
echo "vol_flags=autoresize"                >> $cfg_file_name

cat $cfg_file_name

ubinize  -o $outfile $ubinize_para $cfg_file_name
if [ $? -ne 0 ]; then
    echo "ubinize error"
    exit -2
else
    echo "ubinize ok"
fi

rm -v $cfg_file_name  ${workdir}/${mtdname}.ubifs
