#!/bin/sh
#
#Author: zhouguopo
#

#外部传参 
# 参数1: mount点
# 参数2: 分区名
# 参数3: vol_name
# 参数4: type 默认ubifs，可以是squashfs
mount_point=$1
mtd_name=$2
vol_name=$3
if [ $# -lt 4 ]; then
  fs_type=ubifs
else
  fs_type=$4
fi

secboot=$(cat /proc/cmdline | grep "pubkeyhash=")
sestatus=$(sestatus | grep "SELinux status" | awk '{print $NF}')

if [ x"$UBI_MNT_OPT" = x"" ]; then
  UBI_MNT_OPT=rw,noatime
fi
if [ x"$fs_type" = x"squashfs" ]; then
  if [ x"$sestatus" = x"enabled" ]; then
    UBI_MNT_OPT=ro,defcontext=system_u:object_r:default_t:s0
  else
    UBI_MNT_OPT=ro
  fi
fi
echo "mount_point:$mount_point"
echo "mtd_name:$mtd_name"
echo "vol_name:$vol_name"
echo "fs_type:$fs_type"
echo "UBI_MNT_OPT:$UBI_MNT_OPT"
#exit  -1

g_ubi_dev="ubi0_0"
g_ubiblock_dev="ubiblock0_0"
# check_vol_is_attached vol_name
# 1 is attached, 0 not attached
function check_vol_is_attached()
{
  ret=0
  vol_name=$1
  found=0
  #declare -g g_ubi_dev
  while read -r f; do
    vol_name_tmp=$(cat "$f")
    if [ x"$vol_name_tmp" = x"$vol_name" ]; then
      g_ubi_dev=$(echo "$f" | awk -F'/' '{print $7}')
      echo "$vol_name already attached $g_ubi_dev"
      found=1
      break
    fi
  done <<EOF
$(find /sys/devices/virtual/ubi -name "name")
EOF
  if [ "$found" -eq 1 ]; then
    ret=1
  fi
  return "$ret"
}

function mtd_do_attach()
{
  mtd_name_temp=$1
  #not attached and do attach
  MTD_NUM=`cat /proc/mtd | grep "$mtd_name\"" | awk '{print $1}'| cut -b 4- |sed 's/://g'`
  echo "attach $mtd_name  mtd$MTD_NUM"
  ubiattach /dev/ubi_ctrl -m ${MTD_NUM}
  if [ $? != 0 ];then
	  echo "fail to attach $2"
	  return 1
  fi
  return 0
}

check_vol_is_attached $vol_name
if [ $? = 0 ];then
  mtd_do_attach $mtd_name  #not attached and do attach
  if [ $? = 1 ]; then
    exit -1  #attach fail and exit error
  else
    #check again,fill g_ubi_dev
    check_vol_is_attached $vol_name
    if [ $? = 0 ];then
      echo "check ubi vol attached again and fail"
      exit -2
    fi
  fi
fi

if [ $fs_type = "squashfs" ]; then
  g_ubiblock_dev=`echo $g_ubi_dev | sed 's/ubi/ubiblock/'`
  echo "g_ubiblock_dev:$g_ubiblock_dev"
  if [ ! -b "/dev/$g_ubiblock_dev" ]; then
    echo "g_ubiblock_dev:$g_ubiblock_dev not exist and create"
    ubiblock -c /dev/$g_ubi_dev
  fi
fi

if [ $fs_type = "squashfs" ]; then
  if [[ "$secboot" != "" ]]; then
    zxic_parse_squashfs_verity /dev/$g_ubiblock_dev /tmp/sign /tmp/raw_table /tmp/hash_tree_offset
    #openssl dgst -sha256 -verify  /etc_ro/dm-verity-pub.pem  -signature /tmp/sign /tmp/raw_table
    if [ -f /usr/lib/libcrypto.so.3 ]; then
      oem_zxic_verify_3 -s /tmp/sign -f /tmp/raw_table
    else
      oem_zxic_verify -s /tmp/sign -f /tmp/raw_table
    fi
    if [ $? -ne 0 ]; then
      echo "dm-verity sign verify fail"
      exit 1
    fi

    root_hash=` sed -n '/Root hash/p' /tmp/raw_table | awk '{print $3}' `
    salt=` sed -n '/Salt/p' /tmp/raw_table | awk '{print $2}' `
    hash_offset=` cat /tmp/hash_tree_offset `
    veritysetup --restart-on-corruption open /dev/$g_ubiblock_dev $mtd_name /dev/$g_ubiblock_dev  --hash-offset=$hash_offset $root_hash -s $salt
    if [ $? -ne 0 ]; then
      echo "dm-verity veritysetup open fail"
      exit 1
    fi
    rm /tmp/sign /tmp/raw_table /tmp/hash_tree_offset
    mount -t $fs_type  -o $UBI_MNT_OPT /dev/mapper/$mtd_name   $mount_point
  else
    mount -t $fs_type  -o $UBI_MNT_OPT /dev/$g_ubiblock_dev  $mount_point
  fi
else
  mount -t $fs_type  -o $UBI_MNT_OPT $g_ubi_dev  $mount_point
fi

