#inherit externalsrc package

DESCRIPTION = "liblynq-qser-wifi.so "
SECTION = "base"
#LICENSE = "Mobiletek""
LICENSE = "CLOSED"
LIC_FILES_CHKSUM = "file://LICENSE;md5=4f60c98fa94e02f659ef5939f67fa8ae"
DEPENDS += "bootchart liblynq-log libupi-ab openssl libsctel"

#inherit workonsrc
WORKONSRC = "${TOPDIR}/../src/lynq/lib/liblynq-qser-wifi/"

FILESEXTRAPATHS_prepend :="${TOPDIR}/../src/lynq/lib/:"
SRC_URI = " \
          file://liblynq-qser-wifi \
          "

SRC-DIR = "${S}/../liblynq-qser-wifi"
TARGET_CC_ARCH += "${LDFLAGS}"
BB_INCLUDE_ADD = "--sysroot=${STAGING_DIR_HOST}"
BB_LDFLAGS_ADD = "--sysroot=${STAGING_DIR_HOST} -Wl,--hash-style=gnu"

#Parameters passed to do_compile()

FILES_${PN} = "${base_libdir}/*.so "


FILES_${PN}-dev = "/test \
                   ${includedir}"

FILES_${PN}-doc = "/doc"

FILES_${PN}-dbg ="${base_bindir}/.debug \
                  ${base_libdir}/.debug \
                  ${base_sbindir}/.debug"

INSANE_SKIP_${PN} += "already-stripped"
INSANE_SKIP_${PN} += "installed-vs-shipped"


#INHIBIT_PACKAGE_STRIP = "1"
do_compile () {
		oe_runmake all -C ${SRC-DIR} ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST} -Os -Wl,--hash-style=gnu"
}

do_install () {
    oe_runmake install -C ${SRC-DIR} ROOT=${D}
	
    if [ -d "${WORKONSRC}" ] ; then
        install -d ${D}${includedir}/
        cp -af ${SRC-DIR}/include/ ${D}${includedir}/
    fi 
}

addtask bachclean
do_bachclean () {
    oe_runmake clean
}
