#inherit externalsrc package
LICENSE     = "zte"
DESCRIPTION = "liblynq-shm.so"
#LICENSE = "MobileTekProprietary"
#LIC_FILES_CHKSUM = "file://LICENSE;md5=b1e07e8d88e26263e71d3a9e2aa9a2ff"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"
DEPENDS += "liblynq-log"
#inherit workonsrc
WORKONSRC = "${TOPDIR}/../src/lynq/lib/liblynq-shm/"
FILESEXTRAPATHS_prepend :="${TOPDIR}/../src/lynq/lib/:"
SRC_URI = " \
          file://liblynq-shm \
          "

SRC-DIR = "${S}/../liblynq-shm"
TARGET_CC_ARCH += "${LDFLAGS}"
BB_INCLUDE_ADD = "--sysroot=${STAGING_DIR_HOST}"
BB_LDFLAGS_ADD = "--sysroot=${STAGING_DIR_HOST} -Wl,--hash-style=gnu"


FILES_${PN} = "${base_libdir}/*.so "

FILES_${PN}-dev = "/test \
                   ${includedir}"

FILES_${PN}-doc = "/doc"

FILES_${PN}-dbg ="${base_bindir}/.debug \
                  ${base_libdir}/.debug \
                  ${base_sbindir}/.debug"

INSANE_SKIP_${PN} += "already-stripped"
INSANE_SKIP_${PN} += "installed-vs-shipped"


#INHIBIT_PACKAGE_STRIP = "1"
do_compile () {
	if [ "${PACKAGE_ARCH}" = "cortexa7hf-vfp-vfpv4-neon" ]; then
		oe_runmake all -C ${SRC-DIR} ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST} -Os -mhard-float -Wl,--hash-style=gnu -DTELEPHONYWARE"
	elif [ "${PACKAGE_ARCH}" = "cortexa7hf-neon-vfpv4" ]; then
		oe_runmake all -C ${SRC-DIR}  ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST} -Os -mhard-float -Wl,--hash-style=gnu -DTELEPHONYWARE"
	elif [ "${PACKAGE_ARCH}" = "cortexa53hf-neon-fp-armv8" ]; then
		oe_runmake all -C ${SRC-DIR}  ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST} -Os -mhard-float -Wl,--hash-style=gnu -DTELEPHONYWARE -mhard-float -mfpu=neon-fp-armv8 -mfloat-abi=hard -mcpu=cortex-a53 -mtune=cortex-a53"
	else
		oe_runmake all -C ${SRC-DIR}  ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST} -Os -Wl,--hash-style=gnu -DTELEPHONYWARE"
	fi
}

do_install () {
    oe_runmake install -C ${SRC-DIR} ROOT=${D}
	
    if [ -d "${WORKONSRC}" ] ; then
        install -d ${D}${includedir}/lynq_shm
        cp -arf ${SRC-DIR}/include/* ${D}${includedir}/lynq_shm/	    	
    fi 
}

addtask bachclean
do_bachclean () {
    oe_runmake clean
}
