#inherit externalsrc package

DESCRIPTION = "lynq-default demo"
LICENSE = "CLOSED"
LIC_FILES_CHKSUM = "file://LICENSE;md5=b1e07e8d88e26263e71d3a9e2aa9a2ff"
DEPENDS += "liblynq-uci"
#inherit workonsrc
WORKONSRC = "${TOPDIR}/../src/lynq/packages/apps/lynq-default"
FILESEXTRAPATHS_prepend :="${TOPDIR}/../src/lynq/packages/apps:"
SRC_URI = " \
          file://lynq-default \
          "

SRC-DIR = "${S}/../lynq-default"
TARGET_CC_ARCH += "${LDFLAGS}"

#Parameters passed to do_compile()
EXTRA_OEMAKE = "'RAT_CONFIG_C2K_SUPPORT = ${RAT_CONFIG_C2K_SUPPORT}'\
                'MTK_MULTI_SIM_SUPPORT = ${MTK_MULTI_SIM_SUPPORT}'\
                'TARGET_PLATFORM = ${TARGET_PLATFORM}'"

EXTRA_OEMAKE += "'LYNQ_CONFIG_VERSION = ${LYNQ_CONFIG_VERSION}' \
                 'LYNQ_CONFIG_SW_VERSION = ${LYNQ_CONFIG_SW_VERSION}'"

#INHIBIT_PACKAGE_STRIP = "1"
do_compile () {
	if [ "${PACKAGE_ARCH}" = "cortexa7hf-vfp-vfpv4-neon" ]; then
		oe_runmake all -C ${SRC-DIR} ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST} -Os -mfpu=neon-vfpv4 -mhard-float -Wl,--hash-style=gnu -DTELEPHONYWARE"
	elif [ "${PACKAGE_ARCH}" = "cortexa7hf-neon-vfpv4" ]; then
		oe_runmake all -C ${SRC-DIR} ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST} -Os -mfpu=neon-vfpv4 -mhard-float -Wl,--hash-style=gnu -DTELEPHONYWARE"
	elif [ "${PACKAGE_ARCH}" = "cortexa53hf-neon-fp-armv8" ]; then
		oe_runmake all -C ${SRC-DIR} ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST} -Os -mfpu=neon-vfpv4 -mhard-float -Wl,--hash-style=gnu -DTELEPHONYWARE -mhard-float -mfpu=neon-fp-armv8 -mfloat-abi=hard -mcpu=cortex-a53 -mtune=cortex-a53"
	else
		oe_runmake all -C ${SRC-DIR} ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST} -Os -Wl,--hash-style=gnu -DTELEPHONYWARE"
	fi
}

do_install() {
	install -d ${D}${bindir}/
	install -m 0755 ${SRC-DIR}/lynq-default ${D}${bindir}/
}
