#include "hd8040_upgrade.h"
#include "port.h"
#include <getopt.h>
#include <include/lynq-gpio.h>
#define READ_MAX_LENGTH 128
#define PORT_NAME ("/dev/ttyS2")
uint8_t g_bin_buff[500*1024] = {0};
uint32_t g_bin_buff_size = 0;
extern int get_mon_ver(int uart_fd,uint8_t *ver_buf, int ver_len);

#define READ_LEN_MAX 1024 //BOOT_UPGRADE_BUFF_MAX_1

int read_bin_file(uint8_t *path, uint8_t *buff)
{
    int fp = -1;
    int ret = 0;
    int i = 0;
    int size = 0;

    if (NULL == path || NULL == buff)
    {
        printf("[%s %d] str error", __FUNCTION__, __LINE__);
        return -1;
    }

    fp = open((char *)path, O_RDONLY);
    if(fp < 0)
    {
        printf( "[%s %d]open file failed ! errno is %d\n", __FUNCTION__, __LINE__, errno);
        return -1;
    }

    size = lseek(fp, 0x00, SEEK_END);
    if(size <= 0)
    {
        printf( "[%s %d]file is empty\n", __FUNCTION__, __LINE__);
        return -1;
    }

    printf( "[%s %d]file size is:%d\n", __FUNCTION__, __LINE__, size);
    lseek(fp, 0x00, SEEK_SET);
    while(1)
    {
        ret = read(fp, buff, READ_LEN_MAX);
        i += ret;
        if(ret == READ_LEN_MAX)
        {
            buff += READ_LEN_MAX;
        }
        else
        {
            break;
        }
    }

    printf( "[%s %d]file size is:%d,i:%d\n", __FUNCTION__, __LINE__, size, i);
    close(fp);
    if(size != i)
    {
        return -1;
    }
    g_bin_buff_size = size;
    return 0;
}

static void print_usage(const char *prog)
{
    printf("Usage: %s [-BUTVh]\n", prog);
    puts("  -B --boot    boot mode select\n"
         "  -U --user  user mode select \n"
         "  -T --usertoboot  usertoboot mode select \n"
         "  -V --version firmware version get \n"
         "  -h --help    help message print \n");
    exit(1);
}

struct option long_options[] = {
{ "name", 0, NULL, 'n' },
{ "bf_name", 0, NULL, 'b' },
{ "love", 1, NULL, 'l' },
{ 0, 0, 0, 0},
};

static const struct option lopts[] = {
{ "boot",	required_argument, NULL, 'B' },//required_argument
{ "user",	required_argument, NULL, 'U' },
{ "usertoboot", required_argument, NULL, 'T' },
{ "version",   0, NULL, 'V' },
{ "help",	0, NULL, 'h' },
{ 0, 0, 0, 0 },
};
char* const short_options1 = "B:U:T:Vh";

int write_file(uint8_t *path, uint8_t *buff, int len)
{
    int fp = -1;
    int ret = 0;
    int i = 0;
    int size = 0;

    if (NULL == path || NULL == buff)
    {
        printf("[%s %d] str error", __FUNCTION__, __LINE__);
        return -1;
    }

    fp = open((char *)path, O_RDWR );
    if(fp < 0)
    {
        printf( "[%s %d]open file failed ! errno is %d\n", __FUNCTION__, __LINE__, errno);
        return -1;
    }

    size = lseek(fp, 0x00, SEEK_END);

    write(fp, buff, len);

    printf( "[%s %d]file size is:%d,i:%d\n", __FUNCTION__, __LINE__, size, i);
    close(fp);
    return 0;
}

//example  //升级过程中，禁止其他程序操作该串口，禁止断电复位等操作
int main(int argc, char *argv[])
{
    uint8_t newVersionBuf[READ_MAX_LENGTH] = {0};
    uint8_t cleintID[READ_MAX_LENGTH] = "999999";
    int fd = -1; // uart handle
    int ret = -1;
    uint8_t filePath[256] = {0};
    uint16_t filePtahLen = 0;

    if (argc == 1)
    {
        printf("This program needs arguments....\n\n");
        print_usage(argv[0]);
    }

    int num;
    while ((num = getopt_long(argc, argv, short_options1, lopts, NULL)) != -1)
    {
        printf("getopt_long C:%d\n", num);
        switch (num)
        {

        case 'B':
        {
            printf("optarg:%s\n", optarg);
            if ( optarg == NULL )
            {
                printf("%s: option 'B' requires argument...\n", argv[0]);
                break;
            }
            filePtahLen = strlen(optarg);
            if(filePtahLen < sizeof(filePath))
            {
                memcpy((char *)filePath, optarg, filePtahLen);
                goto HD_UPG;
            }

            //sleep(1);
        }
            break;
        case 'V':
        {
            printf("check version\n");
            fd = OpenUart((char *)PORT_NAME);
            if (fd < 0)
            {

                printf("open uart failed %d\n", fd);
                return -1;
            }
            get_mon_ver(fd, newVersionBuf, sizeof(newVersionBuf));
            printf("version is: %s\n", newVersionBuf);
            uart_close(fd);
            return 0;
        }
            break;

        default:
        {
            printf("please input correct parameters\n");
        }
            break;
        }
    }

    //芯片上电
HD_UPG:
    fd = OpenUart((char *)PORT_NAME);
    if (fd < 0)
    {

        printf("open uart failed %d\n", fd);
        return -1;
    }
    ret = read_bin_file(filePath, g_bin_buff);
    if (ret < 0)
    {
        printf("open file failed %d\n", fd);
        return -1;
    }

    /*go to boot-mode need change pin status*/
    lynq_gpio_init(15,1,0,0);
    lynq_gpio_value_set(15, 0);
    usleep(100000);//100ms
    lynq_gpio_init(126,1,1,0);
    lynq_gpio_value_set(126, 1);
    usleep(1000000);//1s
    lynq_gpio_value_set(126, 0);
    usleep(100000);//100ms
    lynq_gpio_direction_set(15, 0);
    lynq_gpio_pullsel_set(15, 0);
    lynq_gpio_deinit(15);
    lynq_gpio_deinit(126);

    ret = fw_update_boot(fd, g_bin_buff, g_bin_buff_size);
    if (ret < 0)
    {
        printf("open file failed %d\n", fd);
        return -1;
    }
    sleep(1);
    if(ret == HDBD_UPG_SUCESS)
    {
        printf("upgrade sucess!\r\n");
    }
    else
    {
        printf("upgrade FAIL, fail style:%d\r\n",ret);
    }
    uart_close(fd);
    return ret;
}
