#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <lynq_uci.h>
#include "lynq_monitor.h"



void handler(int exception_type, int error_code, int opt_code)
{
    printf("MonitorExceptionHandler start,exception_type=%d, error_code=%d,error_codeopt_code\n", exception_type, error_code, error_code);
    return ;

}
int main(int argc,char** argv)
{
    int ret;
    char* file_name = "/etc/config/lynq_monitor.cfg";
    
    ret = lynq_monitor_set_all_state(1);
    if(ret != 0)
    {
        printf("lynq_monitor_set_all_state failed\n");
        return -1;
    }
    ret = lynq_monitor_set_monitor_state(0, 1);
    if(ret != 0)
    {
        printf("lynq_monitor_set_enable failed\n");
        return -1;
    }
    ret = lynq_monitor_init(file_name);
    if(ret != 0)
    {
        printf("lynq_monitor_init failed\n");
        return -1;
    }
    ret = lynq_monitor_register_exception_handler(handler);
    if(ret != 0)
    {
        printf("lynq_monitor_register_exception_handler failed\n");
        return -1;
    }
    while(1)
    {
        printf("lynq_monitor_run\n");
        sleep(100);
    }

    return ret;

}
