#inherit externalsrc package
#inherit externalsrc package systemd
DESCRIPTION = "lynq ril service"
LICENSE = "CLOSED"
LIC_FILES_CHKSUM = "file://LICENSE;md5=b1e07e8d88e26263e71d3a9e2aa9a2ff"
DEPENDS += "${@bb.utils.contains('TARGET_PLATFORM', 'mt2735', 'audio-mixer-ctrl streamer1.0', '', d)} libapn libpal libril libvendor-ril libbinder glib-2.0 dbus liblynq-log liblynq-uci liblynq-shm libmedia libsd-daemon liblynq-led"
RDEPENDS_${PN} = "libbinder libril libsd-daemon"
#inherit workonsrc
WORKONSRC = "${TOPDIR}/../src/lynq/framework/lynq-ril-service/src"
FILESEXTRAPATHS_prepend :="${TOPDIR}/../src/lynq/framework/:"
SRC_URI = " \
          file://lynq-ril-service \
          "

SRC-DIR = "${S}/../lynq-ril-service/src"
TARGET_CC_ARCH += "${LDFLAGS}"
SYSTEMD_PACKAGES = "${PN}"
SYSTEMD_SERVICE_${PN} = "lynq_ril_service.service"
FILES_${PN} += "${systemd_unitdir}/system/lynq_ril_service.service"
FILES_${PN} += "/system/etc/tele/ring ${bindir}"
#Parameters passed to do_compile()
EXTRA_OEMAKE = "'RAT_CONFIG_C2K_SUPPORT = ${RAT_CONFIG_C2K_SUPPORT}'\
                'MTK_MULTI_SIM_SUPPORT = ${MTK_MULTI_SIM_SUPPORT}'\
                'TARGET_PLATFORM = ${TARGET_PLATFORM}'\
                'MTK_LED_SUPPORT = ${MTK_LED_SUPPORT}'\
                'TARGET_PLATFORM = ${TARGET_PLATFORM}'"
EXTRA_OEMAKE += "'MOBILETEK_RIL_CFG = ${MOBILETEK_RIL_CFG}'"

EXTRA_OEMAKE += "'MOBILETEK_FOTA_CFG = ${MOBILETEK_FOTA_CFG}'"

#INHIBIT_PACKAGE_STRIP = "1"
do_compile () {
	if test "${PACKAGE_ARCH}" = "cortexa7hf-vfp-vfpv4-neon" || test "${PACKAGE_ARCH}" = "cortexa7hf-neon-vfpv4"; then
		oe_runmake all -C ${SRC-DIR} ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST} -mhard-float"
	else
		oe_runmake all -C ${SRC-DIR} ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST}"
	fi
}

do_install() {
	echo "lynq-ril-service PN ${PN}"
	echo "lynq-ril-service FILES_${PN} ${FILES_${PN}}"
	echo "lynq-ril-service D ${D}"
	echo "lynq-ril-service bindir ${bindir}"
	echo "lynq-ril-service ${D}${bindir}"
	echo "lynq-ril-service ${S}/lynq-ril-service"
	install -d ${D}${bindir}/
	install -m 0755 ${SRC-DIR}/lynq-ril-service ${D}${bindir}/
	if ${@bb.utils.contains('DISTRO_FEATURES','systemd','true','false',d)}; then
		install -d ${D}${systemd_unitdir}/system/
		install -m 0644 ${B}/lynq_ril_service.service ${D}${systemd_unitdir}/system
	else
		install -d ${D}${sysconfdir}/init.d
		install -m 0755  ${SRC-DIR}/lynq-ril-service.sh ${D}${sysconfdir}/init.d/lynq-ril-service.sh
		install -d ${D}${sysconfdir}/rcS.d
		ln -s ../init.d/lynq-ril-service.sh ${D}${sysconfdir}/rcS.d/S21lynq-ril-service
	fi
#	install -d ${D}${includedir}
#	install ${S}/atci/ATCI.h ${D}${includedir}
#	cp -R ${S}/demoscript ${D}${bindir}/
	if test "${TARGET_PLATFORM}" = "mt2731"; then
		install -d ${D}/system/etc/tele/ring
		cp -R ${TOPDIR}/../src/lynq/framework/lynq-ril-service/ringtone/*.wav ${D}/system/etc/tele/ring
	fi
}
