#include <ctype.h>
#include <errno.h>
#include <unistd.h>
#include <getopt.h>
#include <limits.h>
#include <netdb.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <syslog.h>
#include <pthread.h>

#include <include/lynq-qser-autosuspend.h>
#include <include/lynq-qser-wifi.h>

void lynq_wifi_event_handle_demo(lynq_wifi_event_s *event, void *arg)
{
    if(event->id == LYNQ_WIFI_EVENT_AP_STATION)
        printf("[lynq-wifi-demo]  %s:event-id = %d - %d\n", __func__, event->id, event->status);
    else if(event->id == LYNQ_WIFI_EVENT_STA_STATUS)
        printf("[lynq-wifi-demo]  %s:event-id = %d,%d,%s,%s\n", __func__, event->id, event->ap_sta_info.connected, event->ap_sta_info.mac,event->ap_sta_info.hostname);
    else
        return;
}

void lynq_wifi_event_handle_sta_demo(lynq_wifi_sta_scan_list_t *event)
{
    int i = 0;
    for (i = 0; i < event->cnt; i++)
    {
        printf("[lynq-wifi-demo] %s : ap[%d]:%s,%d,%d,%d,%s,%d,%d,%d\n", __func__, i, event->info[i].essid, event->info[i].auth,
               event->info[i].cipher, event->info[i].channel, event->info[i].bssid, event->info[i].signal_level,event->info[i].frequency,event->info[i].signal);
    }
}

static void print_lynq_lanhost_t(lynq_lanhost_ts lynq_arrays) 
{
	int i = 0;
	for (i = 0; i < lynq_arrays.array_len; i++) {
		printf("Element %d:\n", i);
		printf("addr: %s\n", lynq_arrays.array[i].addr);
		printf("macaddr: %s\n", lynq_arrays.array[i].macaddr);
		printf("name: %s\n", lynq_arrays.array[i].name);
		printf("ifname: %s\n", lynq_arrays.array[i].ifname);
		printf("uptime: %d\n", lynq_arrays.array[i].uptime);
		printf("\n");
	}
}

int main(int argc, char *argv[])
{
    int num = qser_wakelock_create("wifi_lock", 10);
    if(num < 0)
    {
        printf("wakelock create fail\n");
        printf("num=%d\n", num);
    }
    lynq_wifi_ap_index_e type;
    if (strcmp(argv[0], "lynq-wifi-demo") == 0)
        type = LYNQ_WIFI_AP_INDEX_AP0; // 2.4G
    else
        type = LYNQ_WIFI_AP_INDEX_AP1; // 5G
    if (argc == 2)
    {
        if (strcmp(argv[1], "0") == 0) //Turn off WiFi and uninstall
        {
            qser_wifi_enable();      // enable wifi
            qser_wifi_ap_stop(type); // Disable ap mode for 2.4G/5G
            qser_wifi_disable();     // Turn off WiFi
            int ret = qser_wakelock_unlock(num);
            if(ret != 0)
            {
                printf("wakelock unlock fail\n");
                printf("ret=%d\n", ret);
            }
            ret = qser_wakelock_destroy(num);
            if(ret != 0)
            {
                printf("wakelock destroy fail\n");
                printf("ret=%d\n", ret);
            }
        }
        else if (strcmp(argv[1], "1") == 0) //Load WiFi and turn on WiFi
        {
            char pw[65] = {0};
            char mac_list[360] = {0};
            srand(time(NULL));
            sprintf(pw, "lynq123456");
            sprintf(mac_list, "AA:BB:CC:DD:EE:%d%d;AA:BB:CC:%d%d:EE:00;AA:BB:%d%d:DD:EE:00",rand()%10,rand()%10,rand()%10,rand()%10,rand()%10,rand()%10);
            qser_wifi_enable(); // enable wifi
            if (type == LYNQ_WIFI_AP_INDEX_AP0)
                qser_wifi_work_mode_set(LYNQ_WIFI_WORK_MODE_AP0); // Set 2.4G, and this function must be called after the qser_wifi_enable function
            else
                qser_wifi_work_mode_set(LYNQ_WIFI_WORK_MODE_AP1); // Set 5G, and this function must be called after the qser_wifi_enable function
            qser_wifi_ap_acl_set(type,LYNQ_WIFI_MAC_ACL_RULE_BLACK,mac_list); // Example mac address of the blacklist "AA:BB:CC:DD:EE:XX"
            qser_wifi_ap_ssid_set(type, type == LYNQ_WIFI_AP_INDEX_AP0 ?"hello-2.4G":"hello-5G");                 // Set the ssid of 2.4G/5G to hello
            if (strcmp(argv[0], "lynq-wifi-demo") == 0 || strcmp(argv[0], "/usr/bin/lynq-wifi-demo") == 0)
                qser_wifi_ap_ssid_hide_set(type, 0);
            else
                qser_wifi_ap_ssid_hide_set(type, 1);
            qser_wifi_ap_max_sta_set(type, 22);      // Example Set the maximum number of connections to 22
            qser_wifi_ap_channel_set(type, "CN", 0); // Set the country code to CN and channel to 0(acs)
            if (type == LYNQ_WIFI_AP_INDEX_AP0)
                qser_wifi_ap_mode_set(type, LYNQ_WIFI_MODE_80211BGNAX_2G); // Set the working protocol mode of 2.4G/5G to 80211BGN
            else
            {
                qser_wifi_ap_bandwidth_set(type, LYNQ_WIFI_BANDWIDTH_HT80);
                qser_wifi_ap_mode_set(type, LYNQ_WIFI_MODE_80211ANACAX_5G);
            }
            qser_wifi_ap_auth_set(type, LYNQ_WIFI_AUTH_WPA2_PSK, pw); // Set the authentication of 2.4G/5G to wpa2 and the password to lynq123456
            qser_wifi_ap_start(type);                                 // Set the ap mode of 2.4G/5G
            int ret = qser_wakelock_lock(num);
            if(ret != 0)
            {
                printf("wakelock lock fail\n");
                printf("ret=%d\n", ret);
            }
        }
        else if (strcmp(argv[1], "2") == 0) //Callback query that only covers WiFi as an ap
        {
            char pw[65] = {0};
            char ssid[33] = {0};
            bool hidden = 0;
            char country_code[12] = {0};
            char mac_list[360] = {0};
            int channel, max_sta_num;
            lynq_wifi_mode_type_e mode;
            lynq_wifi_ap_auth_t auth_mode;
            lynq_wifi_mac_acl_rule_e acl_rule;
            lynq_wifi_work_mode_e work_type;
            lynq_wifi_ap_status_t stat = {0};
            lynq_wifi_sta_status_t status_stat = {0};
            lynq_wifi_pkt_stats_t pkt_stat = {0};
            lynq_wifi_bandwidth_type_e bandwidth;
            int ret = -1;
            qser_wifi_enable();                      // enable wifi
            ret = qser_wifi_ap_ssid_get(type, ssid); // Gets the ssid of 2.4G/5G
            printf("[lynq-wifi-demo]  ssid=%s ret = %d\n", ssid, ret);
            ret = qser_wifi_ap_ssid_hide_get(type, &hidden); // Gets whether the ssid state is hidden
            printf("[lynq-wifi-demo]  hidden=%d ret = %d\n", hidden, ret);
            ret = qser_wifi_ap_max_sta_get(type, &max_sta_num); // Gets the maximum sta number for 2.4G/5G
            printf("[lynq-wifi-demo]  max_sta_num = %d ret = %d\n", max_sta_num, ret);
            ret = qser_wifi_ap_mode_get(type, &mode); // Gets the working protocol mode for 2.4G/5G
            printf("[lynq-wifi-demo]  mode = %d ret = %d\n", mode, ret);
            ret = qser_wifi_ap_auth_get_s(type, &auth_mode); // Get 2.4G/5G's password security authentication and password
            printf("[lynq-wifi-demo]  passwd = %s auth_mode = %d group_rekey = %d pairwise = %d ret = %d\n", auth_mode.passwd, auth_mode.auth, auth_mode.group_rekey, auth_mode.pairwise, ret);
            ret = qser_wifi_ap_channel_get(type, country_code, &channel); // Get the country code and channel of 2.4G/5G
            printf("[lynq-wifi-demo]  country_code = %s channel = %d ret = %d\n", country_code, channel, ret);
            ret = qser_wifi_ap_bandwidth_get(type, &bandwidth); // Gets the bandwidth of 2.4G/5G
            printf("[lynq-wifi-demo]  bandwidth = %d ret = %d\n", bandwidth, ret);
            ret = qser_wifi_ap_acl_get(type,&acl_rule,mac_list); // Get the WiFi2.4G or 5G whitelist
            printf("[lynq-wifi-demo]  mac_list = %s acl_rule = %d ret = %d\n", mac_list, acl_rule, ret);
            ret = qser_wifi_work_mode_get(&work_type); // 2.4g or 5g working mode Gettings
            printf("[lynq-wifi-demo]  work_type = %d ret = %d\n", work_type, ret);
            ret = qser_wifi_ap_get_status(type,&stat); // Example Query ap working status
            printf("[lynq-wifi-demo]  ifname = %s status = %d bssid = %s ret = %d\n", stat.ifname, stat.status, stat.bssid, ret);
            ret = qser_wifi_sta_get_status(&status_stat); // Gets the status value associated with sta
            printf("[lynq-wifi-demo]  status = %d ifname = %s ap_bssid = %s signal_level = %d reason_code = %d\n", status_stat.status, status_stat.ifname, status_stat.ap_bssid, status_stat.signal_level, status_stat.reason_code);
            if (status_stat.has_addr == 1)
                printf("[lynq-wifi-demo]addr ip:%s, netmask:%s, subnet_bits:%d, gateway:%s, dnsp:%s, dnss:%s\n",
                       status_stat.addr.addr, status_stat.addr.netmask, status_stat.addr.subnet_bits,
                       status_stat.addr.gateway, status_stat.addr.dnsp, status_stat.addr.dnss);
            if (status_stat.has_addr6 == 1)
                printf("[lynq-wifi-demo]addr6 ip:%s, prefix:%s, prefix_bits:%d, gateway:%s, dnsp:%s, dnss:%s\n",
                       status_stat.addr6.addr, status_stat.addr6.prefix, status_stat.addr6.prefix_bits,
                       status_stat.addr6.gateway, status_stat.addr6.dnsp, status_stat.addr6.dnss);
            ret = qser_wifi_get_ap_pkt_stats(type, &pkt_stat); // Obtain data packets sent and received by ap
            printf("[lynq-wifi-demo]ap_pkt_get rx[%llu, %llu, %llu, %llu] tx[%llu, %llu, %llu, %llu] ret=%d\n",
                   pkt_stat.rx_packets, pkt_stat.rx_bytes, pkt_stat.rx_errors, pkt_stat.rx_dropped,
                   pkt_stat.tx_packets, pkt_stat.tx_bytes, pkt_stat.tx_errors, pkt_stat.tx_dropped, ret);
        }
        else if (strcmp(argv[1], "3") == 0) //Enable the callback query only when WiFi is used as an ap
        {
            int ret = -1;
            int args = 3;       // enable ap_sta callback
            qser_wifi_enable(); // enable wifi
            qser_wifi_register_handle(lynq_wifi_event_handle_demo, NULL, (void *)&args);
            while (1)
            {
                char cmdstr[128] = {0};
                printf("[lynq-wifi-demo]Get sta device information received as an ap :ap_lanhost\n");
                if (NULL != fgets(cmdstr, sizeof(cmdstr) - 1, stdin))
                {
                    if (1 >= strlen(cmdstr))
                    {
                        continue;
                    }
                    if (0 == strncmp(cmdstr, "ap_lanhost", strlen(cmdstr) - 1))
                    {
                        lynq_lanhost_ts ap_lanhost = {0};
                        ret = qser_wifi_lanhost_get_list(&ap_lanhost);
                        printf("[lynq-wifi-demo]ret = %d\n",ret);
                        print_lynq_lanhost_t(ap_lanhost);
                        continue;
                    }
                }
                else
                {
                    printf("  [lynq-wifi-demo]Parameter error, please re-enter\n");
                }
            }
        }
        else if (strcmp(argv[1], "4") == 0) //Overlay WiFi callback as ap and scan callback as sta
        {
            int ret = -1;
            int args = 0; //enable ap_set and ap_sta callback
            char ssid[33] = {0};
            char cmdstr[128] = {0};
            lynq_wifi_sta_param_t stat = {0};
            qser_wifi_enable(); // enable wifi
            if (type == LYNQ_WIFI_AP_INDEX_AP0)
                qser_wifi_work_mode_set(LYNQ_WIFI_WORK_MODE_AP0); // Set 2.4G, and this function must be called after the qser_wifi_enable function
            else
                qser_wifi_work_mode_set(LYNQ_WIFI_WORK_MODE_AP1); // Set 5G, and this function must be called after the qser_wifi_enable function
            qser_wifi_register_handle(lynq_wifi_event_handle_demo, lynq_wifi_event_handle_sta_demo, (void *)&args);
            qser_wifi_ap_start(type); // Set the ap mode of 2.4G/5G
            qser_wifi_sta_start();
            qser_wifi_sta_start_scan(); // When this function is executed once, sta's scan is called once
            memset(cmdstr, 0, sizeof(cmdstr));
            ret = qser_wakelock_lock(num);
            if(ret != 0)
            {
                printf("wakelock lock fail\n");
                printf("ret=%d\n", ret);
            }
            while (1)
            {
                printf("[lynq-wifi-demo]Enter the ssid and password as shown in the following example:ssid auth paris pw ||sta_pkt_get ||sta_param_get || sta_scan ||sta_stop\n");
                if (NULL != fgets(cmdstr, sizeof(cmdstr) - 1, stdin))
                {
                    if (1 >= strlen(cmdstr))
                    {
                        continue;
                    }
                    if (0 == strncmp(cmdstr, "sta_param_get", strlen(cmdstr) - 1))
                    {
                        ret = qser_wifi_sta_param_get(&stat);
                        printf("[lynq-wifi-demo]sta_param_get[%s, %d, %d, %s] ret=%d\n", stat.ssid, stat.auth, stat.pairwise, stat.passwd, ret);
                        continue;
                    }
                    if (0 == strncmp(cmdstr, "sta_pkt_get", strlen(cmdstr) - 1))
                    {
                        lynq_wifi_pkt_stats_t pkt_stat = {0};
                        ret = qser_wifi_get_sta_pkt_stats(&pkt_stat); // Obtain data packets sent and received by ap
                        printf("[lynq-wifi-demo]sta_pkt_get rx[%llu, %llu, %llu, %llu] tx[%llu, %llu, %llu, %llu] ret=%d\n",
                               pkt_stat.rx_packets, pkt_stat.rx_bytes, pkt_stat.rx_errors, pkt_stat.rx_dropped,
                               pkt_stat.tx_packets, pkt_stat.tx_bytes, pkt_stat.tx_errors, pkt_stat.tx_dropped, ret);
                        continue;
                    }
                    else if (0 == strncmp(cmdstr, "sta_scan", strlen(cmdstr) - 1))
                    {
                        qser_wifi_sta_start_scan(); // When this function is executed once, sta's scan is called once
                        printf("[lynq-wifi-demo] sta_scan \n");
                        continue;
                    }
                    else if (0 == strncmp(cmdstr, "sta_stop", strlen(cmdstr) - 1))
                    {
                        qser_wifi_sta_stop();
                        printf("[lynq-wifi-demo]end \n");
                        break;
                    }
                    else
                    {
                        sscanf(cmdstr, "%s %d %d %s", stat.ssid, &stat.auth, &stat.pairwise, stat.passwd);
                        ret = qser_wifi_sta_param_set(&stat);
                        printf("[lynq-wifi-demo]  qser_wifi_sta_param_set ret = %d\n", ret);
                        if (ret == 0)
                            qser_wifi_sta_start();
                        printf("[lynq-wifi-demo]cmdstr = %s\n", cmdstr);
                    }
                }
            }
        }
        else
        {
            printf("  [lynq-wifi-demo]Parameter error, please re-enter\n");
        }
    }
    else
    {
        printf("[lynq-wifi-demo]Please enter one of the parameters 0,1,2,3,4\n");
        printf("  [lynq-wifi-demo]4: sta mode to obtain access point information and set ssid and password and other information connection\n");
        printf("  [lynq-wifi-demo]3: Obtain sta data information in ap mode\n");
        printf("  [lynq-wifi-demo]2: View information such as ssid, password, and channel in ap mode\n");
        printf("  [lynq-wifi-demo]1: initializes wifi and enables and sets ap mode\n");
        printf("  [lynq-wifi-demo]0: indicates off.\n");
        return 0;
    }

    return 0;
}
