#inherit externalsrc package
#inherit externalsrc package systemd
DESCRIPTION = "Mobiletek_Tester_RDIT"
LICENSE = "CLOSED"
LICENSE = "CLOSED"
LIC_FILES_CHKSUM = "file://LICENSE;md5=b1e07e8d88e26263e71d3a9e2aa9a2ff"

DEPENDS += "liblynq-call liblynq-sms liblynq-network liblynq-sim liblynq-data liblynq-qser-data liblynq-qser-network liblynq-qser-voice  liblynq-qser-sim liblynq-qser-sms"

#inherit workonsrc
WORKONSRC = "${TOPDIR}/../src/lynq/packages/apps/Mobiletek_Tester_RDIT"
FILESEXTRAPATHS_prepend :="${TOPDIR}/../src/lynq/packages/apps/:"
SRC_URI = " \
          file://Mobiletek_Tester_RDIT \
          "

SRC-DIR = "${S}/../Mobiletek_Tester_RDIT"
TARGET_CC_ARCH += "${LDFLAGS}"
SYSTEMD_PACKAGES = "${PN}"
SYSTEMD_SERVICE_${PN} = "lynq_ril_service.service"
FILES_${PN} += "${systemd_unitdir}/system/lynq_ril_service.service"
FILES_${PN} += "/system/etc/tele/ring ${bindir}"
#Parameters passed to do_compile()
EXTRA_OEMAKE = "'RAT_CONFIG_C2K_SUPPORT = ${RAT_CONFIG_C2K_SUPPORT}'\
                'MTK_MULTI_SIM_SUPPORT = ${MTK_MULTI_SIM_SUPPORT}'\
                'TARGET_PLATFORM = ${TARGET_PLATFORM}'\
                'MTK_LED_SUPPORT = ${MTK_LED_SUPPORT}'"
EXTRA_OEMAKE += "'MOBILETEK_RIL_CFG = ${MOBILETEK_RIL_CFG}'"

EXTRA_OEMAKE += "'MOBILETEK_FOTA_CFG = ${MOBILETEK_FOTA_CFG}'"

#INHIBIT_PACKAGE_STRIP = "1"
do_compile () {
	if test "${PACKAGE_ARCH}" = "cortexa7hf-vfp-vfpv4-neon" || test "${PACKAGE_ARCH}" = "cortexa7hf-neon-vfpv4"; then
		oe_runmake all -C ${SRC-DIR} ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST} -mhard-float"
	else
		oe_runmake all -C ${SRC-DIR} ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST}"
	fi
}

do_install() {
	echo "lynq-ril-service PN ${PN}"
	echo "lynq-ril-service FILES_${PN} ${FILES_${PN}}"
	echo "lynq-ril-service D ${D}"
	echo "lynq-ril-service bindir ${bindir}"
	echo "lynq-ril-service ${D}${bindir}"
	echo "lynq-ril-service ${S}/Mobiletek_Tester_RDIT"
	install -d ${D}${bindir}/
	install -m 0755 ${SRC-DIR}/Mobiletek-Tester-RDIT ${D}${bindir}/
	install -m 0755 ${SRC-DIR}/socket-tool ${D}${bindir}/
}
