SUMMARY = "SELinux SELinux policy"
DESCRIPTION = "\
This is the targeted variant of the SELinux reference policy.  Most service \
domains are locked down. Users and admins will login in with unconfined_t \
domain, so they have the same access to the system as if SELinux was not \
enabled. \
"

DEPENDS += " secilc secilc-native  policycoreutils-native  checkpolicy-native "
RDEPENDS_${PN}-dev =+ " \
        python3-core \
"
inherit python3native

# DEFAULT_ENFORCING ??= "permissive"
DEFAULT_ENFORCING ??= "enforcing"

PROVIDES += "virtual/refpolicy"
RPROVIDES_${PN} += "refpolicy"

POLICY_NAME = "selinux-policy"
POLICY_TYPE = "selinux-policy"

#SRC_URI = "git://git.defensec.nl/selinux-policy.git"
#SRC_URI[md5sum] = "babb0d5ca2ae333631d25392b2b3ce8d"
#SRC_URI[sha256sum] = "3b58f751a21394e3aef47fd6c9fe9430fadde6427deb5c79f08478904837ec91"
SRC_URI = "file://selinux-policy-0.8 \
          "
LICENSE = "GPLv2"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"

S = "${WORKDIR}/selinux-policy-0.8"
PARALLEL_MAKE = ""
B = "${S}"
EXTRA_OEMAKE += "tc_usrbindir=${STAGING_BINDIR_NATIVE}"

do_compile() {
	echo  "tc_usrbindir=${STAGING_BINDIR_NATIVE}"
	oe_runmake 'tc_usrbindir=${STAGING_BINDIR_NATIVE}'
}

install_config () {
	echo "\
# This file controls the state of SELinux on the system.
# SELINUX= can take one of these three values:
#     enforcing - SELinux security policy is enforced.
#     permissive - SELinux prints warnings instead of enforcing.
#     disabled - No SELinux policy is loaded.
SELINUX=${DEFAULT_ENFORCING}
# SELINUXTYPE= can take one of these values:
#     targeted - Targeted processes are protected.
#     selinux-policy - Basic SELinux Security Policy designed specifically for OpenWrt.
SELINUXTYPE=${POLICY_NAME}
" > ${WORKDIR}/config
	install -d ${D}/${sysconfdir}/selinux
	install -m 0644 ${WORKDIR}/config ${D}/${sysconfdir}/selinux/
}

do_install () {
    mkdir -p  ${D}${sysconfdir}/selinux/${POLICY_NAME}/contexts/files/
    mkdir -p  ${D}${sysconfdir}/selinux/${POLICY_NAME}/policy/
    install -m 0644 ${B}/customizable_types  ${D}${sysconfdir}/selinux/${POLICY_NAME}/contexts
    install -m 0644 ${B}/file_contexts.subs_dist  ${D}${sysconfdir}/selinux/${POLICY_NAME}/contexts/files/
    install -m 0644 ${B}/file_contexts   ${D}${sysconfdir}/selinux/${POLICY_NAME}/contexts/files/
    install -m 0644 ${B}/policy.*        ${D}${sysconfdir}/selinux/${POLICY_NAME}/policy/
    install_config
}

FILES_${PN} += " \
	${sysconfdir}/selinux/ \
	"
