DESCRIPTION = "fluxstat"
#fluxstat依赖libnvram库
DEPENDS     = "libnvram libsoftap libsofttimer"
SECTION     = "app"
LICENSE     = "zte"
PV = "1.0.0"
PR = "r0"

CLASS_COM = " \
    ${@bb.utils.contains('DISTRO_FEATURES', 'procd', 'openwrt openwrt-services', '', d)} \
    ${@bb.utils.contains('DISTRO_FEATURES', 'systemd', 'systemd', '', d)} \
"
inherit ${CLASS_COM}

#配置code路径信息。
FILESEXTRAPATHS_prepend :="${APP-OPEN-PATH}/platform:"
SRC_URI = " \
          file://fluxstat \
		  ${@bb.utils.contains("DISTRO_FEATURES", "procd", "file://fluxstat.init","", d)} \
		  ${@bb.utils.contains("DISTRO_FEATURES", "systemd", "file://fluxstat.service","", d)} \
		  ${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "file://fluxstat.sysvinit","", d)} \
          "

LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"
S = "${WORKDIR}"

#引用公用头文件和编译选项。
include ${BSPDIR}/sources/meta-zxic/conf/app_com.inc

#编译
do_compile() {
	make -C fluxstat
}

#库文件的安装，封库的宏MK_SDK_VERSION
do_install () {
	install -d ${D}${bindir}/
	install -m 0755 ${S}/fluxstat/fluxstat ${D}${bindir}/
	
	if ${@bb.utils.contains('DISTRO_FEATURES','procd','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/fluxstat.init ${D}${sysconfdir}/init.d/fluxstat
	fi

	if ${@bb.utils.contains('DISTRO_FEATURES','systemd','true','false',d)}; then
		install -d ${D}${systemd_unitdir}/system
		install -m 0644 ${WORKDIR}/fluxstat.service ${D}${systemd_unitdir}/system
	fi
	
	if ${@bb.utils.contains('DISTRO_FEATURES','sysvinit','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/fluxstat.sysvinit ${D}${sysconfdir}/init.d/fluxstat
		install -d ${D}${sysconfdir}/rcS.d
		ln -s ../init.d/fluxstat ${D}${sysconfdir}/rcS.d/S24fluxstat
	fi
	
	#install elfs
	install -d ${ELFS-PATH}/
	install -m 0755 ${S}/fluxstat/fluxstat ${ELFS-PATH}/
}
#清库
do_cleanlibs () {
	rm -fr ${ELFS-PATH}/fluxstat
}

addtask  cleanlibs after do_clean  before do_cleansstate

#rootfs包含的文件
FILES_${PN} = "\
    ${bindir}/ \
    ${@bb.utils.contains("DISTRO_FEATURES", "procd", "${sysconfdir}/init.d/fluxstat","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "${sysconfdir}/","", d)} \
    "
SYSTEMD_SERVICE_${PN}     = "fluxstat.service"
SYSTEMD_AUTO_ENABLE_${PN} = "enable"

RDEPENDS_${PN} = " libnvram libsoftap libsofttimer"