DESCRIPTION = "fota-auto-sync"
#依赖库
DEPENDS     = "libnvram libsoftap libsofttimer libatutils libupi-ab lzma"
SECTION     = "app"
LICENSE     = "zte"
PV = "1.0.0"
PR = "r0"

CLASS_COM = " \
    ${@bb.utils.contains('DISTRO_FEATURES', 'procd', 'openwrt openwrt-services', '', d)} \
    ${@bb.utils.contains('DISTRO_FEATURES', 'systemd', 'systemd', '', d)} \
"
inherit ${CLASS_COM}

#配置code路径信息。
FILESEXTRAPATHS_prepend :="${APP-OPEN-PATH}/platform:"
SRC_URI = " \
          file://fota_auto_sync \
		  ${@bb.utils.contains("DISTRO_FEATURES", "procd", "file://fota_auto_sync.init","", d)} \
		  ${@bb.utils.contains("DISTRO_FEATURES", "systemd", "file://fota_auto_sync.service","", d)} \
		  ${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "file://fota_auto_sync.sysvinit","", d)} \
          "

LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"
S = "${WORKDIR}"

#引用公用头文件和编译选项。
include ${BSPDIR}/sources/meta-zxic/conf/app_com.inc
include ${BSPDIR}/sources/meta-zxic/conf/pub.inc

CFLAGS_append = "${ZXIC_EXTRA_CFLAGS}"

#编译
do_compile() {
	make -C fota_auto_sync
}

#库文件的安装，封库的宏MK_SDK_VERSION
do_install () {
	install -d ${D}${bindir}/
	install -m 0755 ${S}/fota_auto_sync/fota_auto_sync ${D}${bindir}/
	
	if ${@bb.utils.contains('DISTRO_FEATURES','procd','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/fota_auto_sync.init ${D}${sysconfdir}/init.d/fota_auto_sync
	fi

	if ${@bb.utils.contains('DISTRO_FEATURES','systemd','true','false',d)}; then
		install -d ${D}${systemd_unitdir}/system
		install -m 0644 ${WORKDIR}/fota_auto_sync.service ${D}${systemd_unitdir}/system
	fi
	
	if ${@bb.utils.contains('DISTRO_FEATURES','sysvinit','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/fota_auto_sync.sysvinit ${D}${sysconfdir}/init.d/fota_auto_sync
		install -d ${D}${sysconfdir}/rcS.d
		ln -s ../init.d/fota_auto_sync ${D}${sysconfdir}/rcS.d/S76fota_auto_sync
	fi
	
	#install elfs
	install -d ${ELFS-PATH}/
	install -m 0755 ${S}/fota_auto_sync/fota_auto_sync ${ELFS-PATH}/
}
#清库
do_cleanlibs () {
	rm -fr ${ELFS-PATH}/fota_auto_sync
}

addtask  cleanlibs after do_clean  before do_cleansstate

#rootfs包含的文件
FILES_${PN} = "\
    ${bindir}/ \
    ${@bb.utils.contains("DISTRO_FEATURES", "procd", "${sysconfdir}/init.d/fota_auto_sync","", d)} \
	${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "${sysconfdir}/","", d)} \
    "
SYSTEMD_SERVICE_${PN}     = "fota_auto_sync.service"
SYSTEMD_AUTO_ENABLE_${PN} = "enable"