DESCRIPTION = "libril"
DEPENDS     = "libbinder libatchn libsoftap libnvram libsofttimer libatutils libtinyalsa libvoice libmedia libreference-ril"
SECTION     = "lib"
LICENSE     = "zte"
PV          = "1.0.0"
PR          = "r0"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"

#配置code路径信息。
FILESEXTRAPATHS_prepend :="${APP-OPEN-PATH}/sdk:"
SRC_URI = " \
          file://ril \
          "

S = "${WORKDIR}"
#引用公用头文件和编译选项。
include ${BSPDIR}/sources/meta-zxic/conf/app_com.inc

#编译
do_compile () {
	make -C ril
}

#库和头文件的安装
do_install () {
	install -d ${D}${libdir}/
	install -d ${D}/usr/include
	install -d ${D}/usr/include/telephony
	install -d ${D}/usr/include/libril
	
	#install -m 0755 ${S}/ril/reference-ril/libreference-ril.so  ${D}${libdir}/
	install -m 0755 ${S}/ril/libril/libril.so  ${D}${libdir}/
	install -m 0755 ${S}/ril/librilutils/librilutils.so  ${D}${libdir}/
	install -m 0755 ${S}/ril/nanopb-c/libprotobuf-c-nano-enable_malloc.so  ${D}${libdir}/
	
	#install -m 0644 ${S}/ril/include/telephony/*.h ${D}/usr/include/telephony/
	install -m 0644 ${S}/ril/libril/ril_ex.h ${D}/usr/include/libril/
	
	#install elfs
	install -d ${ELFS-PATH}/
	#install -m 0755 ${S}/ril/reference-ril/libreference-ril.so ${ELFS-PATH}/
	install -m 0755 ${S}/ril/libril/libril.so ${ELFS-PATH}/
	install -m 0755 ${S}/ril/librilutils/librilutils.so ${ELFS-PATH}/
	install -m 0755 ${S}/ril/nanopb-c/libprotobuf-c-nano-enable_malloc.so ${ELFS-PATH}/
}

#清库
do_cleanlibs () {
	#rm -fr ${ELFS-PATH}/libreference-ril.so
	rm -fr ${ELFS-PATH}/libril.so
	rm -fr ${ELFS-PATH}/librilutils.so
	rm -fr ${ELFS-PATH}/libprotobuf-c-nano-enable_malloc.so
	
}

#rootfs包含的文件
FILES_${PN}       += "${libdir}/*.so"
FILES_${PN}-dbg   += "${libdir}/.debug"
FILES_SOLIBSDEV   = ""
INSANE_SKIP_${PN} = "dev-so"
RDEPENDS_${PN} = "libbinder libatchn libsoftap libnvram libsofttimer libatutils libtinyalsa libvoice libmedia libreference-ril"
