DESCRIPTION = "libvoice"
DEPENDS = "libtinyalsa libnvram libsoftap libsofttimer"
SECTION     = "lib"
LICENSE     = "zte"
PV          = "1.0.0"
PR          = "r0"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"

#配置code路径信息。
FILESEXTRAPATHS_prepend :="${APP-OPEN-PATH}/platform:"
SRC_URI = " \
          file://libvoice \
          "

S = "${WORKDIR}"
#引用公用头文件和编译选项。
include ${BSPDIR}/sources/meta-zxic/conf/app_com.inc
CFLAGS_append    = "-I ${BSPDIR}/zxic_code/zxic_source/zxic_app_open/platform/libtinyalsa/include"

CFLAGS_append += "${@bb.utils.contains("CONFIG_VB_TRANSMIT_INTF", "RTP", "-I ${BSPDIR}/zxic_code/zxic_source/zxic_app/librtp/include", "", d)}"
DEPENDS += "${@bb.utils.contains('CONFIG_VB_TRANSMIT_INTF', 'RTP', 'librtp', '', d)}"
#编译
do_compile () {
	make -C libvoice CONFIG_VB_TRANSMIT_INTF=${CONFIG_VB_TRANSMIT_INTF} 
}

#库和头文件的安装
do_install () {
	install -d ${D}${libdir}/
	install -d ${D}/usr/include
	install -m 0755 ${S}/libvoice/libvoice.so  ${D}${libdir}/
	install -m 0755 ${S}/libvoice/libvoice.a   ${D}${libdir}/
	install -m 0644 ${S}/libvoice/include/*.h     ${D}/usr/include/	
	
	#install elfs
	install -d ${ELFS-PATH}/
	install -m 0755 ${S}/libvoice/libvoice.so ${ELFS-PATH}/
}

#清库
do_cleanlibs () {
	rm -fr ${ELFS-PATH}/libvoice.so
}

#rootfs包含的文件
FILES_${PN}       += "${libdir}/*.so"
FILES_${PN}-dbg   += "${libdir}/.debug"
FILES_SOLIBSDEV   = ""
INSANE_SKIP_${PN} = "dev-so"
