DESCRIPTION = "msm_svr"
DEPENDS     = "libsoftap libsofttimer libnvram libatutils libscipc libmsmsvr libtinyalsa libvoice libmedia"
SECTION     = "app"
LICENSE     = "zte"
PV = "1.0.0"
PR = "r0"

DEPENDS += "${@bb.utils.contains('CONFIG_MSMSVR_CODEC_TYPE', 'FFMPEG', 'fdk-aac-master opencore-amr vo-amrwbenc ffmpeg', '', d)}"
CLASS_COM = " \
    ${@bb.utils.contains('DISTRO_FEATURES', 'procd', 'openwrt openwrt-services', '', d)} \
    ${@bb.utils.contains('DISTRO_FEATURES', 'systemd', 'systemd', '', d)} \
"
inherit ${CLASS_COM}

#配置code路径信息。
FILESEXTRAPATHS_prepend :="${APP-OPEN-PATH}/platform:"
SRC_URI = " \
    file://msm_svr \
    ${@bb.utils.contains("DISTRO_FEATURES", "procd", "file://msm_svr.init","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "systemd", "file://msm_svr.service","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "file://msm_svr.sysvinit","", d)} \
    "

LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"
S = "${WORKDIR}"

#引用公用头文件和编译选项。
include ${BSPDIR}/sources/meta-zxic/conf/app_com.inc

#编译
do_compile() {
	make -C msm_svr CONFIG_MSMSVR_CODEC_TYPE=${CONFIG_MSMSVR_CODEC_TYPE}
}

#库文件的安装
do_install() {
	install -d ${D}${bindir}/
	install -m 0755 ${S}/msm_svr/msm_svr ${D}${bindir}/

	if ${@bb.utils.contains('DISTRO_FEATURES','procd','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/msm_svr.init ${D}${sysconfdir}/init.d/msm_svr
	fi

	if ${@bb.utils.contains('DISTRO_FEATURES','systemd','true','false',d)}; then
		install -d ${D}${systemd_unitdir}/system
		install -m 0644 ${WORKDIR}/msm_svr.service ${D}${systemd_unitdir}/system
	fi

	if ${@bb.utils.contains('DISTRO_FEATURES','sysvinit','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/msm_svr.sysvinit ${D}${sysconfdir}/init.d/msm_svr
		install -d ${D}${sysconfdir}/rcS.d
		ln -s ../init.d/msm_svr ${D}${sysconfdir}/rcS.d/S30msm_svr
	fi

	#install elfs
	install -d ${ELFS-PATH}/
	install -m 0755 ${S}/msm_svr/msm_svr ${ELFS-PATH}/
}
#清库
do_cleanlibs () {
	rm -fr ${ELFS-PATH}/msm_svr
}

addtask  cleanlibs after do_clean  before do_cleansstate

#rootfs包含的文件
FILES_${PN} = "\
    ${bindir}/ \
    ${@bb.utils.contains("DISTRO_FEATURES", "procd", "${sysconfdir}/","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "${sysconfdir}/","", d)} \
    "
SYSTEMD_SERVICE_${PN}     = "msm_svr.service"
SYSTEMD_AUTO_ENABLE_${PN} = "enable"

RDEPENDS_${PN} = " libsoftap libsofttimer libnvram libatutils libscipc libtinyalsa libvoice libmedia"