DESCRIPTION = "rtc-service"
DEPENDS     = "libnvram libsofttimer libsoftap libatutils libscipc"
SECTION     = "app"
LICENSE     = "zte"
PV = "1.0.0"
PR = "r0"

CLASS_COM = " \
    ${@bb.utils.contains('DISTRO_FEATURES', 'procd', 'openwrt openwrt-services', '', d)} \
    ${@bb.utils.contains('DISTRO_FEATURES', 'systemd', 'systemd', '', d)} \
"
inherit ${CLASS_COM}

#配置code路径信息。
FILESEXTRAPATHS_prepend :="${APP-OPEN-PATH}/platform:"
SRC_URI = " \
          file://rtc-service \
		  ${@bb.utils.contains("DISTRO_FEATURES", "procd", "file://rtc-service.init","", d)} \
		  ${@bb.utils.contains("DISTRO_FEATURES", "systemd", "file://rtc-service.service","", d)} \
		  ${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "file://rtc-service.sysvinit","", d)} \
          "
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"
S = "${WORKDIR}"
S_SRC_PATH = "${S}/rtc-service"
#引用公用头文件和编译选项。
include ${BSPDIR}/sources/meta-zxic/conf/app_com.inc

#inherit autotools pkgconfig systemd

do_compile() {
	#echo "TOPDIR = ${TOPDIR}"
	
	make -C ${S_SRC_PATH}
}

do_install () {
	install -d ${D}${bindir}/
	install -m 0755 ${S_SRC_PATH}/rtc-service ${D}${bindir}/
	install -m 0755 ${S_SRC_PATH}/zxic-rtc-clock ${D}${bindir}/
	
	if ${@bb.utils.contains('DISTRO_FEATURES','procd','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/rtc-service.init ${D}${sysconfdir}/init.d/rtc-service
	fi

	if ${@bb.utils.contains('DISTRO_FEATURES','systemd','true','false',d)}; then
		install -d ${D}${systemd_unitdir}/system
		install -m 0644 ${WORKDIR}/rtc-service.service ${D}${systemd_unitdir}/system
	fi
	
	if ${@bb.utils.contains('DISTRO_FEATURES','sysvinit','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/rtc-service.sysvinit ${D}${sysconfdir}/init.d/rtc-service
		install -d ${D}${sysconfdir}/rcS.d
		ln -s ../init.d/rtc-service ${D}${sysconfdir}/rcS.d/S21rtc-service
		ln -s ../init.d/rtc-service ${D}${sysconfdir}/rcS.d/K79rtc-service
	fi

	#install elfs
	install -d ${ELFS-PATH}/
	install -m 0755 ${S_SRC_PATH}/rtc-service ${ELFS-PATH}/
	install -m 0755 ${S_SRC_PATH}/zxic-rtc-clock ${ELFS-PATH}/	
}

do_cleanlibs () {
	rm -fr ${ELFS-PATH}/rtc-service
	rm -fr ${ELFS-PATH}/zxic-rtc-clock
}

addtask  cleanlibs after do_clean  before do_cleansstate

FILES_${PN} = "\
    ${bindir}/ \
    ${@bb.utils.contains("DISTRO_FEATURES", "procd", "${sysconfdir}/init.d/rtc-service","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "${sysconfdir}/","", d)} \
    "
SYSTEMD_SERVICE_${PN}     = "rtc-service.service"
SYSTEMD_AUTO_ENABLE_${PN} = "enable"

RDEPENDS_${PN} = " libnvram libsofttimer libsoftap libatutils libscipc"
INSANE_SKIP_${PN} += "ldflags"
