DESCRIPTION = "voiceipc_mainctrl"
DEPENDS     = "libnvram libsoftap libsofttimer libvoice"
SECTION     = "app"
LICENSE     = "zte"
PV = "1.0.0"
PR = "r0"

CLASS_COM = " \
    ${@bb.utils.contains('DISTRO_FEATURES', 'procd', 'openwrt openwrt-services', '', d)} \
    ${@bb.utils.contains('DISTRO_FEATURES', 'systemd', 'systemd', '', d)} \
"
inherit ${CLASS_COM}

#配置code路径信息。
FILESEXTRAPATHS_prepend :="${APP-OPEN-PATH}/platform:"
SRC_URI = " \
          file://voiceipc_mainctrl \		  
		  ${@bb.utils.contains("DISTRO_FEATURES", "procd", "file://voiceipc_mainctrl.init","", d)} \
		  ${@bb.utils.contains("DISTRO_FEATURES", "systemd", "file://voiceipc_mainctrl.service","", d)} \
		  ${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "file://voiceipc_mainctrl.sysvinit","", d)} \
          "
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"
S = "${WORKDIR}"
S_SRC_PATH = "${S}/voiceipc_mainctrl"
#引用公用头文件和编译选项。
include ${BSPDIR}/sources/meta-zxic/conf/app_com.inc
CFLAGS_append    = "-I ${BSPDIR}/zxic_code/zxic_source/zxic_app_open/platform/libtinyalsa/include"
#inherit autotools pkgconfig systemd

do_compile() {
	make -C ${S_SRC_PATH}
}

do_install () {
	install -d ${D}${bindir}/
	install -m 0755 ${S_SRC_PATH}/voiceipc_mainctrl ${D}${bindir}/
	
	if ${@bb.utils.contains('DISTRO_FEATURES','procd','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/voiceipc_mainctrl.init ${D}${sysconfdir}/init.d/voiceipc_mainctrl
	fi

	if ${@bb.utils.contains('DISTRO_FEATURES','systemd','true','false',d)}; then
		install -d ${D}${systemd_unitdir}/system
		install -m 0644 ${WORKDIR}/voiceipc_mainctrl.service ${D}${systemd_unitdir}/system
	fi
	
	if ${@bb.utils.contains('DISTRO_FEATURES','sysvinit','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/voiceipc_mainctrl.sysvinit ${D}${sysconfdir}/init.d/voiceipc_mainctrl
		install -d ${D}${sysconfdir}/rcS.d
		ln -s ../init.d/voiceipc_mainctrl ${D}${sysconfdir}/rcS.d/S21voiceipc_mainctrl
		ln -s ../init.d/voiceipc_mainctrl ${D}${sysconfdir}/rcS.d/K79voiceipc_mainctrl
	fi
	#install elfs
	install -d ${ELFS-PATH}/
	install -m 0755 ${S_SRC_PATH}/voiceipc_mainctrl ${ELFS-PATH}/	
}

do_cleanlibs () {
	rm -fr ${ELFS-PATH}/voiceipc_mainctrl
}

addtask  cleanlibs after do_clean  before do_cleansstate

FILES_${PN} = "\
    ${bindir}/ \
    ${@bb.utils.contains("DISTRO_FEATURES", "procd", "${sysconfdir}/init.d/voiceipc_mainctrl","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "${sysconfdir}/","", d)} \
    "
SYSTEMD_SERVICE_${PN}     = "voiceipc_mainctrl.service"
SYSTEMD_AUTO_ENABLE_${PN} = "enable"

RDEPENDS_${PN} = "libnvram libsoftap libsofttimer libvoice"
