DESCRIPTION = "zxic-audio-ctrl"
#ccapp依赖库
DEPENDS     = "libnvram libsoftap libsofttimer libatutils"
SECTION     = "app"
LICENSE     = "zte"
PV = "1.0.0"
PR = "r0"

CLASS_COM = " \
    ${@bb.utils.contains('DISTRO_FEATURES', 'procd', 'openwrt openwrt-services', '', d)} \
    ${@bb.utils.contains('DISTRO_FEATURES', 'systemd', 'systemd', '', d)} \
"
inherit ${CLASS_COM}

#配置code路径信息
FILESEXTRAPATHS_prepend :="${APP-OPEN-PATH}/platform:"
SRC_URI = " \
    file://zxic_audio_ctrl \
    ${@bb.utils.contains("DISTRO_FEATURES", "procd", "file://zxic_audio_ctrl.init","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "systemd", "file://zxic_audio_ctrl.service","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "file://zxic_audio_ctrl.sysvinit","", d)} \
    "

LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"
S = "${WORKDIR}"

#引用公用头文件和编译选项
include ${BSPDIR}/sources/meta-zxic/conf/app_com.inc
CFLAGS_append    = "-L ${S}/libsofttimer "

#编译
do_compile() {
	make -C zxic_audio_ctrl
}

#库文件的安装
do_install() {
	install -d ${D}${bindir}/
	install -m 0755 ${S}/zxic_audio_ctrl/zxic_audio_ctrl ${D}${bindir}/

	if ${@bb.utils.contains('DISTRO_FEATURES','procd','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/zxic_audio_ctrl.init ${D}${sysconfdir}/init.d/zxic_audio_ctrl
	fi

	if ${@bb.utils.contains('DISTRO_FEATURES','systemd','true','false',d)}; then
		install -d ${D}${systemd_unitdir}/system
		install -m 0644 ${WORKDIR}/zxic_audio_ctrl.service ${D}${systemd_unitdir}/system
	fi

	if ${@bb.utils.contains('DISTRO_FEATURES','sysvinit','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/zxic_audio_ctrl.sysvinit ${D}${sysconfdir}/init.d/zxic_audio_ctrl
		install -d ${D}${sysconfdir}/rcS.d
		ln -s ../init.d/zxic_audio_ctrl ${D}${sysconfdir}/rcS.d/
		#S24zxic_audio_ctrl
	fi
	
	#install elfs
	install -d ${ELFS-PATH}/
	install -m 0755 ${S}/zxic_audio_ctrl/zxic_audio_ctrl ${ELFS-PATH}/
}
#清库
do_cleanlibs () {
	rm -fr ${ELFS-PATH}/zxic_audio_ctrl
}

addtask  cleanlibs after do_clean  before do_cleansstate

#rootfs包含的文件
FILES_${PN} = "\
    ${bindir}/ \
    ${@bb.utils.contains("DISTRO_FEATURES", "procd", "${sysconfdir}/init.d/zxic_audio_ctrl","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "${sysconfdir}/","", d)} \
    "
SYSTEMD_SERVICE_${PN}     = "zxic_audio_ctrl.service"
SYSTEMD_AUTO_ENABLE_${PN} = "disable"