/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:hal_volte.c
 * File Mark:
 * Description:volte voice

 * Others:
 * Version:
 * Author:        lvwenhua
 * Date:
 * History 1:
 *     Date: 2016-2-16
 *     Version:
 *     Author:xuxinqiang
 *     Modification: edit for union version
 * History 2:
  ********************************************************************************/

/****************************************************************************
* 	                                           Include files
****************************************************************************/
#include "drvs_general.h"
#include "drvs_volte.h"
#include "drvs_voiceprocess.h"
#include "drvs_voice_config.h"
#include "hal_volte.h"


#include "drvs_audiomanager.h"

/****************************************************************************
* 	                                           Local Macros
****************************************************************************/



/****************************************************************************
* 	                                           Local Types
****************************************************************************/


/****************************************************************************
* 	                                           Local Constants
****************************************************************************/

/****************************************************************************
* 	                                           Local Function Prototypes
****************************************************************************/
static SINT32 volte_Open(T_ZDrvVoice_MODE mode);
static SINT32 volte_CfgParam(T_ZDrvVp_Cfg *cfgParam);
static SINT32 volte_Close(VOID);
static SINT32 volte_ReadStart(VOID);
static SINT32 volte_ReadStop(VOID);
static SINT32 volte_WriteStart(VOID);
static SINT32 volte_WriteStop(VOID);
static SINT32 volte_Read( VOID * pDataBuf, UINT32 count);//xiu gai chu
static SINT32 volte_Write( VOID * pDataBuf, UINT32 count);//xiu gai chu
static SINT32 volte_SetSample(T_HalVoice_Block* pVoiceBlock);
static SINT32 volte_Loop(T_ZDrvVoice_Switch enable);
static SINT32 volte_SetMute(T_ZDrvVoice_MuteInfo* pVoiceMuteInfo);
#ifdef _USE_VOLTE_LOOP_TEST
static VOID   volte_LoopProcessThreadEntry(SINT32 argu);
SINT32  volte_CreateLoopThread(VOID);
#endif
SINT32 vp_VolteReadStart(VOID);//xiu gai chu sheng ming
SINT32 vp_VolteWriteStop(VOID);//xiu gai chu sheng ming
SINT32 vp_VolteWriteStart(VOID);//xiu gai chu sheng ming
SINT32 vp_VolteReadStop(VOID);//xiu gai chu sheng ming

/****************************************************************************
* 	                                          Global Constants
****************************************************************************/



/****************************************************************************
* 	                                          Global Variables
****************************************************************************/
static ZOSS_SEMAPHORE_ID s_VolteWriteSema = NULL;

static T_Volte_Status s_volteStatus = VOLTE_IDLE;
static UINT32 s_volteBufSize=0;

#ifdef _USE_VOLTE_LOOP_TEST
T_ZDrvVoice_Cfg cfgParamVolte= {0};

UINT8* volteDataBuf = NULL ;

static ZOSS_THREAD_ID s_VolteLoopThread = NULL;
static UINT32 volteLoopCnt = 0;
static int s_volteLoopTestEn = 0;
static BOOL s_volteLoopThdRun = FALSE;

static ZOSS_SEMAPHORE_ID s_volteLoopSemaphore = NULL;
#endif


static T_HalVolte_Opt s_volteObjOpt =
{
    volte_Open,
    volte_Close,
    volte_Read,
    volte_Write,
    volte_SetSample,
    volte_Loop,
    volte_SetMute,
    volte_CfgParam,
    volte_ReadStart,
    volte_ReadStop,
    volte_WriteStart,
    volte_WriteStop,
};

//extern UINT8 g_volteIsWb;
//extern T_ZDrv_VpPath  g_vpPath ; //VP_PATH_HANDSET;
//extern T_ZDrv_VpVol g_vpVol ;
extern T_zDrvVoice_GbVar g_voiceVar;
/****************************************************************************
* 	                                          Global Function Prototypes
****************************************************************************/

extern SINT32 vp_Open(T_ZDrvVoice_MODE voiceMode);
extern SINT32 vp_CfgParam(T_ZDrvVp_Cfg *cfgParam);
extern SINT32 vp_Close(T_ZDrvVoice_MODE voiceMode);

extern SINT32 vp_WriteDataToCodec(UINT8 *pBuf, UINT32 count);
extern SINT32 vp_ReadDataFromCodec(UINT8 *pBuf, UINT32 count);
extern SINT32 zDrvVolte_Initiate(VOID);

/****************************************************************************
* 	                                          Function Definitions
****************************************************************************/
#if 0
VOID volte_I2sWriteDrainCb(VOID)
{
    zOss_PutSemaphore(s_VolteWriteSema);
}
#endif

static SINT32 volte_Open(T_ZDrvVoice_MODE mode)
{
    SINT32 ret = DRV_SUCCESS;
    zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, "volte_Open start, mode=%d!\n", mode);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "volte_Open start, mode=%d!\n", mode);
	
    ret = zDrvAudioM_GetResource(AUDIO_MANAGER_RESOURCE_VOLTE);
    if(ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " volte_Open fail to get volte resource\n");
        return ret;
    }

    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"volte_Open start \n");
    if(s_volteStatus !=VOLTE_IDLE)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"volte_Open err s_volteStatus=%d \n",s_volteStatus);
        zDrvAudioM_FreeResource(AUDIO_MANAGER_RESOURCE_VOLTE);
        return DRV_ERROR;
    }

    ret =vp_Open(mode);
    if (ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "volte_Open vp_Open ret=%d \n",ret);
        zDrvAudioM_FreeResource(AUDIO_MANAGER_RESOURCE_VOLTE);
        return DRV_ERROR;
    }

    s_volteBufSize=0;
    s_volteStatus=VOLTE_OPEN;


    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"volte_Open end tick=%d.\n", zOss_GetTickCount());

	zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL,"volte_Open end!\n");
    return DRV_SUCCESS;
}

static SINT32 volte_Close(VOID)
{
    SINT32 ret = DRV_SUCCESS;

    if ((s_volteStatus == VOLTE_IDLE) ||(s_volteStatus == VOLTE_INUSE))
    {
        return DRV_ERROR;
    }


    ret = vp_Close(g_voiceVar.voiceMode);
    if (ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "volte_Close  err ret =%d \r\n",ret);
        //return DRV_ERROR;
    }


    s_volteStatus = VOLTE_IDLE;

    zDrvAudioM_FreeResource(AUDIO_MANAGER_RESOURCE_VOLTE);
	zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " volte_Close end!\n");
	zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL,"volte_Close end!\n");
    return ret;
}


static SINT32 volte_CfgParam(T_ZDrvVp_Cfg *cfgParam)
{
    SINT32 ret = DRV_SUCCESS;
    ret = vp_CfgParam(cfgParam);
    if (ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "volte_CfgParam vp_CfgParam ret=%d \n",ret);
        return DRV_ERROR;
    }

    if ( cfgParam->clock_rate == 16000)
    {
        s_volteBufSize = cfgParam->samples_per_frame * 2;
    }
    else if ( cfgParam->clock_rate == 8000)
    {
        s_volteBufSize = cfgParam->samples_per_frame * 2;

    }
	else

	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "volte_CfgParam cfgParam->clock_rate=%d  not support \n",cfgParam->clock_rate);
		return DRV_ERROR;
	}

    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "volte_CfgParam end cfgParam->clock_rate=%d, s_volteBufSize %d\n",cfgParam->clock_rate, s_volteBufSize);
    return DRV_SUCCESS;
}


static SINT32 volte_ReadStart(VOID)
{
    SINT32 ret = DRV_SUCCESS;

    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"volte_ReadStart start\n");

    ret = vp_VolteWriteStart();
    if (ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "vp_VolteWriteStart  err ret =%d \r\n",ret);
        return DRV_ERROR;
    }
	
    ret = vp_VolteReadStart();
    if (ret != DRV_SUCCESS)
    {
        zDrvI2S_Write_Stop(I2S_1);
		vp_VolteWriteStop();
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "volte_ReadStart  err ret =%d \r\n",ret);
        return DRV_ERROR;
    }
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "volte_ReadStart \n");
    s_volteStatus = VOLTE_INUSE;
    return DRV_SUCCESS;
}

static SINT32 volte_ReadStop(VOID)
{
    SINT32  ret = DRV_SUCCESS;

    if (s_volteStatus==VOLTE_IDLE)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"volte_ReadStop  s_volteStatus already idle \n");
        return DRV_SUCCESS;
    }


    ret = vp_VolteReadStop();
    if (ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "volte_ReadStop  err ret =%d \r\n",ret);
        return DRV_ERROR;
    }


    s_volteStatus = VOLTE_OPEN;

    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "volte_ReadStop\n");
    return DRV_SUCCESS;
}

static SINT32 volte_WriteStart(VOID)
{
    SINT32 ret = DRV_SUCCESS;

    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"volte_WriteStart start\n");

    //ret = vp_VolteWriteStart();
    if(ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "volte_WriteStart  err ret =%d \r\n",ret);
        return DRV_ERROR;
    }


    s_volteStatus = VOLTE_INUSE;

    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "volte_WriteStart \n");

    return DRV_SUCCESS;
}

static SINT32 volte_WriteStop(VOID)
{
    SINT32  ret = DRV_SUCCESS;



    if (s_volteStatus == VOLTE_IDLE)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"volte_WriteStop  s_volteStatus already idle \n");
        return DRV_SUCCESS;
    }

    ret = vp_VolteWriteStop();
    if (ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "volte_WriteStop  err ret =%d \r\n",ret);
        return DRV_ERROR;
    }


    s_volteStatus=VOLTE_OPEN;

    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "volte_WriteStop \n");
    return DRV_SUCCESS;
}



//count only support ,320NB,640WB
static SINT32 volte_Read( VOID * pDataBuf, UINT32 count)//xiu gai chu
{
    SINT32 ret = DRV_SUCCESS;


    ret = vp_ReadDataFromCodec((UINT8*)pDataBuf,count);//xiu gai chu
    if (ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "volte_Read  err ret =%d \r\n",ret);
        return DRV_ERROR;
    }


    return DRV_SUCCESS;
}

//count only support ,320NB,640WB
static SINT32 volte_Write( VOID* pDataBuf, UINT32 count)//xiu gai chu
{
    SINT32 ret = DRV_SUCCESS;
    ret = vp_WriteDataToCodec((UINT8*)pDataBuf,count);
    if (ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "volte_Write  err ret =%d \r\n",ret);
        return DRV_ERROR;
    }

    return DRV_SUCCESS;
}

static SINT32 volte_SetSample(T_HalVoice_Block* pVoiceBlock)
{
    return DRV_ERR_NOT_SUPPORTED;
}

static SINT32 volte_Loop(T_ZDrvVoice_Switch enable)
{
    return DRV_ERR_NOT_SUPPORTED;
}

static SINT32 volte_SetMute(T_ZDrvVoice_MuteInfo* pVoiceMuteInfo)
{
    return DRV_ERR_NOT_SUPPORTED;
}

#ifdef _USE_VOLTE_LOOP_TEST
SINT32  volte_CreateLoopThread(VOID)
{
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "create volte Loop Thread start s_VolteLoopThread=%d\r\n",(int)s_VolteLoopThread);
    if (NULL == s_VolteLoopThread)
    {
        s_VolteLoopThread = zOss_CreateThread("VolteLoopThread",  volte_LoopProcessThreadEntry, 0,1024, 15, 0, 1);

        if (NULL == s_VolteLoopThread)
        {
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "create volte Loop Thread  err \r\n");
            return DRV_ERROR;
        }
    }
    return DRV_SUCCESS;
}



static VOID   volte_LoopProcessThreadEntry(SINT32 argu)
{
    SINT32 ret = DRV_SUCCESS;

    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "volte_LoopProcessThreadEntry start \r\n");

    s_volteLoopThdRun=TRUE;
    volteLoopCnt=0;

    while(1)
    {
        zOss_GetSemaphore(s_volteLoopSemaphore, ZOSS_WAIT_FOREVER);

        while (s_volteLoopTestEn == 1)
        {

#if 1
            ret = volte_Read(volteDataBuf,s_volteBufSize);
            if (ret != DRV_SUCCESS) {
                zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "volte_Read err ret=%d \r\n",ret);
                //continue;
                //break;
            }

#endif
			//added by caowenting

	        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "volte_LoopProcessThreadEntry,read_databuf = %x,data = %d.\n",volteDataBuf,*volteDataBuf);
         

#if 1
            ret = volte_Write(volteDataBuf,s_volteBufSize);
            if(ret != DRV_SUCCESS) {
                zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "volte_Write  err ret=%d \r\n",ret);
                //continue ;
                break;
            }
			//added by caowenting
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "volte_LoopProcessThreadEntry,write_databuf = %x,data = %d.\n",volteDataBuf,*volteDataBuf);

#endif
#if 0
            volteLoopCnt++;
            if(volteLoopCnt>10)// 260s
            {
                volteLoopCnt=0;
                s_volteLoopTestEn =FALSE;
                break;
            }

#endif
        }
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " volte_LoopProcessThreadEntry while end,time=%d! \r\n",zOss_GetTickCount());

        ret = volte_ReadStop();
        if (ret != DRV_SUCCESS) {
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "volte_ReadStop err ret=%d \r\n",ret);
            return ;
        }

        ret = volte_WriteStop();
        if (ret != DRV_SUCCESS) {
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "volte_WriteStop err ret=%d \r\n",ret);
            return ;
        }

        ret = volte_Close();
        if (ret != DRV_SUCCESS) {
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "volte_Close err ret=%d \r\n",ret);
            return ;
        }
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, " volte_LoopProcessThreadEntry end,time=%d! \r\n",zOss_GetTickCount());
        s_volteLoopThdRun=FALSE;

    }
}


SINT32 volte_LoopStart(VOID)
{
    SINT32 ret = DRV_SUCCESS;
    g_voiceVar.vpVol = VP_VOL_3;
    g_voiceVar.vpPath = VP_PATH_HEADSET;// VP_PATH_SPEAKER; //VP_PATH_HANDSET;

    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"volte_LoopStart  start ,s_volteLoopThdRun=0x%x\n",s_volteLoopThdRun);
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"volte_LoopStart  start ,TRUE=0x%x,FALSE=0x%x\n",TRUE,FALSE);

    if ( s_volteLoopTestEn != FALSE )
    {
        return DRV_ERROR;
    }
    if ( s_volteLoopThdRun != FALSE )
    {
        return DRV_ERROR;
    }

    if (NULL == s_volteLoopSemaphore)
    {
        s_volteLoopSemaphore = zOss_CreateSemaphore("VolteLoopSemaphore", 0);
    }
    ret = volte_CreateLoopThread();
    if (ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "volte_LoopStart  volte_CreateLoopThread err ret =%d \r\n",ret);
    }
    if (volteDataBuf == NULL)
    {
        volteDataBuf = (UINT8*)zOss_Malloc(320);
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"volte_LoopStart  volteDataBuf=%x \n",volteDataBuf);

    }

    cfgParamVolte.clock_rate=8000;//16000; //
    cfgParamVolte.bits_per_sample=16;
    cfgParamVolte.channel_count=1;
    cfgParamVolte.samples_per_frame=160;

    ret = volte_Open(VOICE_LTE_MODE);
    if (ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVolte_Open vp_Open ret=%d \n",ret);
        return DRV_ERROR;
    }
    ret = volte_CfgParam(&cfgParamVolte);
    if (ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVolte_Open vp_CfgParam ret=%d \n",ret);
        return DRV_ERROR;
    }



    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVolte_Open return \r\n");

    ret = volte_WriteStart();
    if (ret != DRV_SUCCESS) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "volte_WriteStart err ret=%d \r\n",ret);

	return DRV_ERROR;//xiu gai chu

    }

    ret = volte_ReadStart();
    if (ret != DRV_SUCCESS) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "volte_ReadStart  err ret=%d  \r\n",ret);
	return DRV_ERROR;//xiu gai chu

    }




    s_volteLoopTestEn = 1;

    //zOss_Sleep(5);


    if (s_volteLoopSemaphore != NULL)
    {
        zOss_PutSemaphore(s_volteLoopSemaphore);
    }

    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "volte_LoopStart  volte_CreateLoopThread ret=%d \r\n",ret);

    return ret;
}

SINT32 volte_LoopStartWB(VOID)
{


    SINT32 ret = DRV_SUCCESS;

    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"volte_LoopStart  start ,s_volteLoopThdRun=0x%x\n",s_volteLoopThdRun);
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"volte_LoopStart  start ,TRUE=0x%x,FALSE=0x%x\n",TRUE,FALSE);

    if ( s_volteLoopTestEn != FALSE )
    {
        return DRV_ERROR;
    }
    if ( s_volteLoopThdRun != FALSE )
    {
        return DRV_ERROR;
    }

    if (NULL == s_volteLoopSemaphore)
    {
        s_volteLoopSemaphore = zOss_CreateSemaphore("VolteLoopSemaphore", 0);
    }
    ret = volte_CreateLoopThread();
    if (ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "volte_LoopStart  volte_CreateLoopThread err ret =%d \r\n",ret);
    }
    if (volteDataBuf == NULL)
    {
       volteDataBuf = (UINT8*)zOss_Malloc(320);
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"volte_LoopStart  volteDataBuf=%x \n",volteDataBuf);

    }

    cfgParamVolte.clock_rate=16000;//16000; //
    cfgParamVolte.bits_per_sample=16;
    cfgParamVolte.channel_count=1;
    cfgParamVolte.samples_per_frame=320;

    g_voiceVar.vpVol = VP_VOL_3;
    g_voiceVar.vpPath = VP_PATH_HEADSET; //VP_PATH_HANDSET;

    ret = volte_Open(VOICE_LTE_MODE);
    if (ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVolte_Open vp_Open ret=%d \n",ret);
        return DRV_ERROR;
    }
    ret = volte_CfgParam(&cfgParamVolte);
    if (ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVolte_Open vp_CfgParam ret=%d \n",ret);
        return DRV_ERROR;
    }



    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVolte_Open return \r\n");

    ret = volte_WriteStart();
    if (ret != DRV_SUCCESS) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "volte_WriteStart err ret=%d \r\n",ret);
	 return DRV_ERROR;//xiu gai chu

    }

    ret = volte_ReadStart();
    if (ret != DRV_SUCCESS) {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "volte_ReadStart  err ret=%d  \r\n",ret);
        return DRV_ERROR;//xiu gai chu

    }




    s_volteLoopTestEn = 1;

    //zOss_Sleep(5);


    if (s_volteLoopSemaphore != NULL)
    {
        zOss_PutSemaphore(s_volteLoopSemaphore);
    }

    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "volte_LoopStart  volte_CreateLoopThread ret=%d \r\n",ret);

    return ret;



}

SINT32 volte_LoopStop(VOID)
{
    SINT32 ret = DRV_SUCCESS;
    while(s_volteLoopThdRun==TRUE)
    {
      zOss_Sleep(20);
	}

    s_volteLoopTestEn = 0;
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "volte_LoopStop set flag, time=%d \r\n",zOss_GetTickCount());
    //zOss_Sleep(5);


    if (NULL !=s_volteLoopSemaphore)
    {
        //zOss_PutSemaphore(s_volteLoopSemaphore);
        //ret += (SINT32)zOss_DeleteSemaphore(s_volteLoopSemaphore);
        //s_volteLoopSemaphore= NULL;
    }

   // zOss_Sleep(5);

    zOss_Free(volteDataBuf);
    volteDataBuf=NULL;
    return ret;

}

#endif
SINT32 zDrvVolte_Initiate(VOID)
{

    //SINT32 ret = DRV_SUCCESS;//xiu gai chu

    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"zDrvVolte_Initiate start!");
#ifdef _USE_VOLTE_API_INTF
    zDrvVolte_SetOperations(&s_volteObjOpt);
#endif

    return DRV_SUCCESS;
}



SINT32 zDrvVoice_Open(T_ZDrvVoice_Cfg *cfgParam)
{
    SINT32 ret = DRV_SUCCESS;
    if (cfgParam == NULL)
    {
        return DRV_ERR_INVALID_PARAM;
    }

    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"zDrvVolte_Open start cfgParam->rate = %d\n", cfgParam->clock_rate);



    ret = volte_Open(cfgParam->mode);
    if  (ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVolte_Open vp_Open ret=%d \n",ret);
        return DRV_ERROR;
    }
    ret =volte_CfgParam(cfgParam);
    if (ret != DRV_SUCCESS)
    {
	    volte_Close();
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVolte_Open vp_CfgParam ret=%d \n",ret);
        return DRV_ERROR;
    }
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVolte_Open vp_Open and vp_CfgParam\n");

#if 0
    ret = vp_Open(VOICE_LTE_MODE,cfgParam);

    if(ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "zDrvVolte_Open  err ret =%d \r\n",ret);
        return DRV_ERROR;
    }
#endif



    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,"zDrvVolte_Open start cfgParam->rate = %d\n", cfgParam->clock_rate);
    return DRV_SUCCESS;
}



SINT32 zDrvVoice_Close(VOID)
{
    SINT32 ret = DRV_SUCCESS;


    ret = volte_Close();
    if (ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "zDrvVolte_Close  err ret =%d \r\n",ret);
        return DRV_ERROR;
    }


    return DRV_SUCCESS;
}


SINT32 zDrvVoice_ReadStart(VOID)
{
    SINT32 ret = DRV_SUCCESS;


    ret=volte_ReadStart();
    if(ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "zDrvVolte_ReadStart  err ret =%d \r\n",ret);
        return DRV_ERROR;
    }

    return DRV_SUCCESS;
}

SINT32 zDrvVoice_ReadStop(VOID)
{
    SINT32  ret = DRV_SUCCESS;

    ret = volte_ReadStop();
    if (ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "zDrvVolte_ReadStart  err ret =%d \r\n",ret);
        return DRV_ERROR;
    }

    return DRV_SUCCESS;
}

SINT32 zDrvVoice_WriteStart(VOID)
{
    SINT32 ret = DRV_SUCCESS;


    ret = volte_WriteStart();
    if (ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "zDrvVolte_WriteStart  err ret =%d \r\n",ret);
        return DRV_ERROR;
    }



    return DRV_SUCCESS;
}

SINT32 zDrvVoice_WriteStop(VOID)
{
    SINT32  ret = DRV_SUCCESS;

    ret = volte_WriteStop();
    if (ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "zDrvVolte_WriteStop  err ret =%d \r\n",ret);
        return DRV_ERROR;
    }
    return DRV_SUCCESS;
}



SINT32 zDrvVoice_WriteOneFrame(UINT8 *pBuf)
{


    SINT32  ret = DRV_SUCCESS;

    if (pBuf == NULL)
    {
        return DRV_ERR_INVALID_PARAM;
    }


    ret = vp_WriteDataToCodec(pBuf,s_volteBufSize);
    if (ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "volte_WriteOneFrame  err ret =%d \r\n",ret);
        return DRV_ERROR;
    }


    return ret;


}


SINT32 zDrvVoice_ReadOneFrame(UINT8 *pBuf)
{
    SINT32  ret = DRV_SUCCESS;

    if (pBuf == NULL)
    {
        return DRV_ERR_INVALID_PARAM;
    }

    ret = vp_ReadDataFromCodec(pBuf,s_volteBufSize);
    if (ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "volte_ReadOneFrame  err ret =%d \r\n",ret);
        return DRV_ERROR;
    }



    return ret;
}

#ifdef _USE_VOLTE_LOOP_TEST








SINT32 zDrvVolte_LoopStart(VOID)
{
    SINT32 ret = DRV_SUCCESS;


    ret = volte_LoopStart();
    if (ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "zDrvVolte_LoopStart  volte_LoopStart err ret =%d \r\n",ret);
    }

    return ret;
}

SINT32 zDrvVolte_LoopStartWB(VOID)
{
    SINT32 ret = DRV_SUCCESS;

    ret = volte_LoopStartWB();
    if (ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "zDrvVolte_LoopStartWB  volte_LoopStartWB err ret =%d \r\n",ret);
    }

    return ret;
}


SINT32 zDrvVolte_LoopStop(VOID)
{
    SINT32 ret = DRV_SUCCESS;

    ret = volte_LoopStop();
    if (ret != DRV_SUCCESS)
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "zDrvVolte_LoopStop  volte_LoopStop err ret =%d \r\n",ret);
    }
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO,  "zDrvVolte_LoopStop set flag, time=%d \r\n",zOss_GetTickCount());


    return ret;
}
#endif

