/**
 * @file oss_sup.h
 * @brief ossģ鸽ӹ
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * 
 * 
 */

#ifndef _OSS_SUP_H
#define _OSS_SUP_H

/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/
#include "ramdump.h"
#ifdef __cplusplus
extern "C"
{
#endif


/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/
#ifndef DOXYGEN_SHOULD_SKIP_THIS
/* ûȡ¼ */
#define ZOSS_EVENTS_OR              0x00
#define ZOSS_EVENTS_AND             0x01
#define ZOSS_EVENTS_OR_CLEAR        0x02
#define ZOSS_EVENTS_AND_CLEAR       0x03

/* ûص */
#define ZOSS_SETHOOKFLAG_MONI       0x01         /* Ϣ                 */
#define ZOSS_SETHOOKFLAG_TRACK      0x02         /* Ը                 */
#define ZOSS_SETHOOKFLAG_INTER      0x03         /* Ϣػ                 */
#define ZOSS_SETHOOK_SEND           0x01         /* zOss_SendMsgϢչ     */
#define ZOSS_SETHOOK_SEND_DATA      0x02         /* zOss_SendMsgϢչ     */
#define ZOSS_SETHOOK_GET_ALL_ID     0x03         /* zOss_GetAllTaskIDչ    */
#define ZOSS_SETHOOK_GET_ID         0x04         /* zOss_GetTaskIDչ       */
#define ZOSS_SETHOOK_GET_NAME       0x05         /* zOss_GetTaskNameչ     */

/* Ϣ״̬ */
#define ZOSS_MSGSENDTYPE_MSG        0x01         /* Ϣ                 */
#define ZOSS_MSGSENDTYPE_DATA       0x02         /*                  */
#define ZOSS_MSGSENDTYPE_INTER      0x03         /* жз             */
#define ZOSS_MSGSENDTYPE_TIMER      0x04         /* ʱϢ               */

/* ״̬ */
#define ZOSS_STATUS_INIT            0x01         /* ʼ̬                   */
#define ZOSS_STATUS_WORK            0x02         /* ̬                   */
#define ZOSS_STATUS_IDLE            0x03         /* ̬                   */
#define ZOSS_STATUS_USERBASE        0x04         /* û״̬Զ           */

/* ״̬ */
#define ZOSS_STATE_STOPPED          0x01         /* ͣ                 */
#define ZOSS_STATE_IDLE             0x02         /*                  */
#define ZOSS_STATE_READY            0x03         /*                  */
#define ZOSS_STATE_RUN              0x04         /*                  */

/* Ϣ */
#define ZOSS_MSGDIRE_IN             0x01         /* Ϣ             */
#define ZOSS_MSGDIRE_OUT            0x02         /* Ϣ             */
#define ZOSS_MSGDIRE_INOUT          0x03         /* ˫򲶻                 */

/* Ϣȼ */
#define ZOSS_QUEUE_MSG_PRI_NORMAL   0x00         /* normal priority messageŵϢβ */
#define ZOSS_QUEUE_MSG_PRI_URGENT   0x01         /* urgent priority messageŵϢ */

/* ò󳤶 */
#define MAX_EVENTNAME_LEN           63          /* ¼󳤶       */
#define MAX_QUEUENAME_LEN           63          /* Ϣ       */ 
#define ZOSS_MAX_TASKNAME_LEN       63          /*                */
#define SHELL_CMD_LENGTH            31          /* shell󳤶      */
#define SHELL_CMD_PARAM_NUM         12          /* shell  */
#define SHELL_CMD_PARAM_LENGTH      23          /* shell󳤶  */

/* ӡ */
#define zOss_Printf                 zTools_Printf
#define PRINT_LEVEL_ALLWAYS         0x00        /* Ǵӡ                   */
#define PRINT_LEVEL_DEBUG           0x01        /* Լ                         */
#define PRINT_LEVEL_NORMAL          0x02        /* ͨ                         */
#define PRINT_LEVEL_SEVERE          0x03        /* ؼ                         */
#define PRINT_LEVEL_ABNORMAL        0x04        /* 쳣                         */
#define PRINT_LEVEL_RAM             0x05        /* ӡڴ,ڴӡʹ    */
#define PRINT_LEVEL_FORBID          0xff        /* ӡ                           */

/* NV ECC*/
#define ZOSS_NV_ECC_LOG_NR          (6)
#define ZOSS_NV_ECC_WORK            (1)
#define ZOSS_NV_ECC_BACKUP          (2)
#define ZOSS_NV_ECC_BOTH            (3)
#endif //#ifndef DOXYGEN_SHOULD_SKIP_THIS

/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/
#ifndef DOXYGEN_SHOULD_SKIP_THIS
/* ˫ģ */
typedef struct tag_NODE        
{
    struct tag_NODE *next;      
    struct tag_NODE *previous;  
}T_ZOss_Node;

typedef struct              
{
    SINT32      count;             
    T_ZOss_Node *HEAD;
    T_ZOss_Node *TAIL;
}T_ZOss_List;

/* λģ */
typedef struct     
{
    SINT32  pToBuf;     /* offset from start of buffer where to write next  */
    SINT32  pFromBuf;   /* offset from start of buffer where to read next   */
    SINT32  bufSize;    /* size of ring in bytes                            */
    CHAR    *buf;       /* pointer to start of buffer                       */
}T_ZOss_Ring, *T_ZOss_RingId;

/* ʱģ 20130415osa.h*/

/* ITCģ 20130523 ɾ*/

/* ramdump ҽӺ */
typedef VOID (*T_zOss_RamdumpHookFunc)(VOID); 

/* Ϣģ */
typedef struct
{
    T_ZOss_Node     node;
    ZOSS_TASK_ID    t_task_id;      /* ĿID   */
    ZOSS_TASK_ID    s_task_id;      /* ԴID     */
    UINT32          msgID;          /* ϢID       */
    UINT16          msgLen;         /* Ϣ峤   */
    UINT8           send_state;     /* Ϣ״̬ */
}T_ZOss_TaskMsgHead;                /* Ϣͷ       */

typedef struct
{
    VOID    *msgbuf;
    UINT16  msgLenEX;
}T_ZOss_TaskMsg;        /* Ϣ */

typedef UINT32 (*TASK_SEND_HOOK)(T_ZOss_TaskMsgHead *buf, UINT8 dire);

/* ģ */                    
typedef VOID (*FUNC_TASKENTRY)(UINT8 state, UINT32 msg_id, UINT8 *buf, UINT16 msg_len, UINT8 *private_data);

typedef struct struTCB
{
    T_ZOss_Node     node;                                   /* ˫                             */
    UINT32          type;                                   /* ǷSDL                          */
    UINT32          count;                                  /* ִеĴ                           */
    CHAR            task_name[ZOSS_MAX_TASKNAME_LEN + 1];   /* ,63                        */
    FUNC_TASKENTRY  taskEntry;                              /*                                  */
    TASK_SEND_HOOK  HookEntry[3];                           /* ص                                 */
    ZOSS_TASK_ID    task_id;                                /* ID                                   */
    ZOSS_TASK_ID    sender_task_id;                         /* ϢԴID                             */
    ZOSS_THREAD_ID  thread_id;                              /* ߳ID                               */
    T_ZOss_List     msg_queue;                              /* Ϣ                         */
    UINT32          stack_size;                             /* ջС                                 */
    UINT32          priority;                               /* ȼ(0-31)                         */
    UINT32          private_data_len;                       /* ˽ݳ                             */
    UINT32          time;                                   /* 񴴽ʱ                             */
    UINT32          stack_used;                             /* öջС                             */
    UINT32          task_time;                              /* ʼʱ                             */
    UINT32          msg_id;                                 /* ǰϢID                           */
    UINT8           dire[4];                                /* Ϣ                             */
    UINT8           thread_no;                              /* ̺߳                                   */
    UINT8           run_status;                             /* ״                                 */
    UINT8           state;                                  /* ״̬                                 */
    UINT8           *taskData;                              /* ָ                           */
    struct struTCB  *next;
    UINT32          cputime;                                /* cpuʱ                          */
    FLOAT           cpupercent;                             /* cpuռ                            */
    UINT32          runtime;                                /* ʱ                             */
    UINT32          malloc_size;                            /* mallocС                       */
    UINT32          ub_size;                                /* ڴشС                       */
    UINT8           reserved[4];                            /* λһֽΪϵͳ̬־λ   */
}T_ZOss_TCB;                      /* ƿ */

typedef struct 
{
    UINT8           is_use;
    CHAR            task_name[ZOSS_MAX_TASKNAME_LEN + 1];
    FUNC_TASKENTRY  task_entry;
    UINT32          priority;
    UINT32          stack_size;
    UINT32          private_data_len;
    UINT8           process_no;
    UINT8           ack_flag;
#ifdef _USE_HAL_HRDTST
    BOOL            hardTestFlag;
#endif
}T_ZOss_TaskTabItem;    /* ǼǱ */

/* SDL */
typedef struct 
{
    T_ZOss_Node     node;           /*              */
    UINT32          type;           /* ǷSDL  */
    SINT32          index;          /*              */
    UINT32          self_id;
    ZOSS_THREAD_ID  thread_id;      /* ߳ID       */
    VOID            *self;
    TASK_SEND_HOOK  HookEntry[3];   /* ص         */
    UINT8           dire[4];        /* Ϣ     */
}T_ZOss_SDLTCB;                     /* SDLƿ    */    

typedef struct signalcode_desc 
{
    UINT32  selfid;
    CHAR    task_name[ZOSS_MAX_TASKNAME_LEN + 1];
} T_ZOss_SignalCode_Desc;

typedef struct 
{
    UINT32          selfid;
    ZOSS_TASK_ID    task_id;
}tasksdl_desc;
/* shell */
typedef struct 
{
    CHAR    cmd[SHELL_CMD_LENGTH + 1];                              /* ַ       */
    CHAR    para[SHELL_CMD_PARAM_NUM][SHELL_CMD_PARAM_LENGTH + 1];  /*                  */
    UINT32  paraCount;                                              /*              */
}T_Shell_CommandMessage;                                            /* sehllϢṹ  */

typedef VOID (*Shell_Func)(T_Shell_CommandMessage *CmdMsg);         /* shellʵָֺ */

/* ̬Ͷ */
typedef struct 
{
    UINT8 (*pPrioMap)[32];
}T_OSA_PARAM;

typedef struct 
{
    UINT32          ub_pool_num;    /* ڴظ, ܳ255  */
    T_ZOss_UBPOOL   *UBPool;        /* ڴñָ             */
}T_MEM_PARAM;                       /* ڴģ                     */

typedef struct 
{
    UINT32  max_task_num;           /*                    */
    UINT32  max_schthread_num;      /* ߳10           */
    UINT32  max_msg_queue_len;      /* Ϣг             */
    UINT32  deadloop_time;          /* ѭжʱ, λs        */
}T_TASK_PARAM;                      /* ģ                     */

typedef struct 
{
    UINT32  SchPrio;                /* ʱ߳ȼ0-9                                              */
    UINT32  CallBackStack;          /* ʱص̶߳ջ                                               */
    UINT32  CallBackPrio;           /* ʱص߳ȼڵ߳ȼһΪSchPrio+1    */
    UINT32  MinTimeLen;             /* ʱСĳʱʱ,λ                                        */
    UINT32  MaxTimeNum;             /* ʱ                                                       */
}T_TIMER_PARAM;                     /* ʱģ                                                           */

typedef struct 
{
    UINT32  DeadLoopCheckTime;      /* ѭʱ                   */
    UINT32  UpdateCPUTime;          /* ˢCPUʹʱ                */
    UINT32  DeamonStartTime;        /* ϵͳʼExcepʱ  */
}T_EXCEP_PARAM;                     /* 쳣ģ                         */

typedef struct 
{
    T_ZOss_TaskTabItem  *pSysm_TaskItemTab;
    UINT32              task_num;
}T_SYSM_PARAM;  /* sysmģ */

typedef struct 
{
    UINT32  *pNvAddrCfg;
    UINT32  addrCfgNum;
    VOID    *pRevNvCfg;
    UINT32  revNvCfgNum;
    UINT32  NV_Work_Area_Base_Addr;       /* NVַ       */
    UINT32  NV_Start_Backup_Base_Addr;    /* ݿʼַ     */
    UINT32  NV_Backup_Area_Base_Addr;     /* NVַ       */    
    UINT32  NV_Backup_Area_Size;          /* NVС         */
    UINT32  NV_Factory_Area_Base_Addr;    /* NVַ       */
    UINT32  NV_Factory_Area_Size;         /* NVС         */
    UINT32  NV_Work_Area_Symbol_Addr;     /* д־λַ   */
    UINT32  NV_Backup_Area_Symbol_Addr;   /* д־λַ   */
    UINT32  NV_Factory_Area_Symbol_Addr;  /* ־λַ     */
    UINT32  NV_Reset_Factory_Symbol_Addr; /* ָñ־ַ */
    UINT32  NV_Ecc_log_Addr;              /* Ecc Logַ    */
    UINT32  NV_Block_Size;                /* С               */
}T_NVRAM_PARAM;                           /* NVRAMַϢ    */

typedef struct
{
    UINT8  count;
    UINT8  index;
    UINT8  type[ZOSS_NV_ECC_LOG_NR];
    UINT32 tick[ZOSS_NV_ECC_LOG_NR];
    UINT32 addr[ZOSS_NV_ECC_LOG_NR];
}T_ZOss_NvEccLog;

typedef struct
{
    UINT32  Work_Area_Base_Addr;       /* vSIMַ   */
    UINT32  Backup_Area_Base_Addr;     /* vSIMַ   */    
    UINT32  Factory_Area_Base_Addr;    /* vSIMַ   */
    UINT32  Area_Size;                 /* vSIMС     */
    UINT32  Work_Area_Symbol_Addr;     /* д־λַ */
    UINT32  Backup_Area_Symbol_Addr;   /* д־λַ */
    UINT32  Factory_Area_Symbol_Addr;  /* ־λַ   */
}T_vSIM_PARAM;

typedef struct 
{
    CHAR    WinDisk[4];    /* windows̷      */
    CHAR    LinuxPath[20]; /* linux豸    */
    CHAR    Format[20];    /* ļϵͳ     */
    CHAR    Device[20];    /* 豸           */
    CHAR    Params[100];   /* ز         */
    CHAR    Manager[40];   /* ߳       */
}T_OSA_DISKMAP;

typedef struct 
{
    T_OSA_DISKMAP   *diskMap;
    UINT32          diskNum;
}T_DISK_PARAM;

typedef VOID (*ramdump_Hook)(VOID);

typedef struct
{
    ramdump_Hook ramdump_Process_PreHook;
    ramdump_Hook ramdump_Process_AftHook;
}T_zOss_RamdumpOpt;


typedef VOID (*ramdump_IoInit)(VOID);
typedef VOID (*ramdump_IoReadData)(UINT8 *buffer, UINT32 size);
typedef VOID (*ramdump_IoWriteData)(UINT8 *buffer, UINT32 size);
typedef VOID (*ramdump_IoFinish)(VOID);

typedef struct
{
    ramdump_IoInit      init;
    ramdump_IoReadData  read;
    ramdump_IoWriteData write;
    ramdump_IoFinish    finish;
} T_zOss_RamdumpIoOpt;

typedef struct
{
    UINT32  baseForServer;
    UINT32  baseForSelf;
    UINT32  baseForCopy;
    UINT32  size;
} T_zOss_RamdumpRegion;

typedef struct 
{
    T_OSA_PARAM     OsaCfg;     /* osa              */
    T_DISK_PARAM    DiskMap;    /* ӳ         */
    T_MEM_PARAM     MemCfg;     /* ڴ             */
    T_TASK_PARAM    TaskCfg;    /*              */
    T_TIMER_PARAM   TimerCfg;   /* ʱ           */
    T_EXCEP_PARAM   ExcepCfg;   /* 쳣             */
    T_SYSM_PARAM    SysmCfg;    /* sysmt            */
    T_NVRAM_PARAM   NvramCfg;   /* Nv               */
    T_vSIM_PARAM    vSIMCfg;    /* vSim             */
#ifdef _USE_PSM
#ifdef _USE_PSM_NEW_FRAMEWORK
    T_zPsm_Param    PsmCfg;     /* Psm              */
#else
    T_PSM_PARAM     PsmCfg;     /* Psm              */
#endif
#endif
}T_OSS_PARAM;                   /* OSS̬  */

typedef enum 
{
    SYS_RESET_TO_NORMAL,
    SYS_RESET_TO_CHARGER,
    SYS_RESET_TO_ALRAM,
    SYS_RESET_TO_EXCEPTRESET,
    SYS_MAX_RESET_TYPE,
} T_ZOssSys_RESET_TYPE;
#endif //#ifndef DOXYGEN_SHOULD_SKIP_THIS

/*******************************************************************************
 *                       Global variable declarations                          *
 ******************************************************************************/


/*******************************************************************************
 *                       Global function declarations                          *
 ******************************************************************************/
#ifndef DOXYGEN_SHOULD_SKIP_THIS
/* OSAģʼ */
UINT32 OSA_Init(VOID);

/* ϵͳģ */
UINT32 zOss_Init(VOID);
UINT32 zOss_TaskInit(VOID);
UINT32 zOss_Start(VOID);
VOID zOss_TaskStartOK(VOID);
UINT32 zOss_SysPowerdown(VOID);
VOID zOss_SysSoftReset(T_ZOssSys_RESET_TYPE type);
T_OSS_PARAM *zOss_GetOssCfg(VOID);

/* ģ */
UINT32 zOss_Task_HookSet(UINT8 type, VOID *HookFunc);
ZOSS_TASK_ID zOss_CreateTask(const CHAR *task_name, FUNC_TASKENTRY task_entry, UINT32 stack_size, UINT32 priority, UINT32 private_data_len, UINT8 pno);
UINT32 zOss_DeleteTask(ZOSS_TASK_ID task_id);
UINT32 zOss_GetTaskInfo(ZOSS_TASK_ID task_id, T_ZOss_TCB *task_info);
CHAR *zOss_GetTaskName(ZOSS_TASK_ID task_id);
UINT32 zOss_GetAllTaskID(ZOSS_TASK_ID *task_id_arr);
ZOSS_TASK_ID zOss_GetTaskID(const CHAR *task_name);
ZOSS_TASK_ID zOss_GetSelfTaskID(VOID);
UINT32 zOss_SetState(UINT8 next_state);
UINT32 zOss_RegTaskSendHook(ZOSS_TASK_ID task_id, UINT8 hooktype, UINT8 dire, TASK_SEND_HOOK intercept_Entry);
UINT32 zOss_TaskSend(UINT32 msg_id, const VOID *msg_buf, UINT16 msg_len, ZOSS_TASK_ID task_id);
UINT32 zOss_TaskSendData(UINT32 msg_id, VOID *buf, UINT16 msg_len, ZOSS_TASK_ID task_id);
ZOSS_TASK_ID zOss_Sender(VOID);

/* ramdump */
#ifdef _USE_MULTI_CORE_RAMDUMP
VOID zOss_RamdumpSetOperation(T_zOss_RamdumpOpt *funcObjPtr);
VOID zOss_RamdumpConfigureMem(T_zOss_RamdumpRegion *regionInfo);
#else
VOID zOss_RamdumpConfigureMem(UINT32 base, UINT32 size, UINT32 map_base, UINT32 copy_base);
VOID zOss_RamdumpHookInstall(T_zOss_RamdumpHookFunc hook);
#endif
VOID zOss_RamdumpSetIoOpt(T_zOss_RamdumpIoOpt hook);

/* NVӿ */
UINT32 zOss_NvItemWrite(UINT32 NvItemID, UINT8 *NvItemData, UINT32 NvItemLen);
UINT32 zOss_NvItemRead(UINT32 NvItemID, UINT8 *NvItemData, UINT32 NvItemLen);
UINT32 zOss_ResetNVFactory(VOID);
UINT32 zOss_NvramFlush(VOID);
VOID zOss_NvSetErrorAddr(UINT32 addr);
BOOL zOss_NvInResume(VOID);
VOID zOss_NvCheck(VOID);
VOID zOss_NvWriteFactory(VOID);
VOID zOss_NvScanBackUpArea(VOID);
UINT32 zOss_NvGetEccLogInfo(T_ZOss_NvEccLog *logInfo);
UINT32 zOss_ChangeNvroAttr(int writable);
UINT32 Nvram_Flush(VOID);
UINT32 Nvram_Finish(VOID);

/* VSIMӿ */
UINT32 zOss_vSIMInit(VOID);
UINT32 zOss_vSIMDataRead(UINT32 addr, VOID *data, UINT32 len);
UINT32 zOss_vSIMDataWrite(UINT32 addr, VOID *data, UINT32 len);
UINT32 zOss_vSIMFacWrite(VOID *data, UINT32 len);
UINT32 zOss_vSIMRecovery(VOID);

/* ӡ */
UINT32 zTools_Printf(UINT32 nModNo, UINT8 nPrintLevel, const VOID *pFormat, ...);
VOID zOss_RamLog(CHAR *rambuf, UINT32 restrict);
VOID zOss_RamPrintf(VOID);

/* ά */
UINT32 zOss_DebugInfoRecord(UINT32 id, const VOID *pFormat, ...);

/* shellģ */
UINT32 zOss_AddShellCmd(const CHAR *cmd_name, const Shell_Func func, const CHAR *description);

/* Ź */
VOID zOss_WatchDogEnable(BOOL enable);

/* CRCУ */
UINT8 Comm_CrcCalc(const UINT8 *buf, UINT8 len);
SINT32 Comm_CrcCheck(UINT8 *buf, UINT8 len, UINT8 crc);

/* ģ */
VOID zOss_SetTransDataFlag(VOID);
BOOL zOss_GetTransDataFlag(VOID);

/* ¼ */
ZOSS_EVENT_ID zOss_CreateEvent(const CHAR *name);
UINT32 zOss_GetEvent(ZOSS_EVENT_ID eventId, UINT32 events, UINT32 getOptions, UINT32 *pEventsReceived, UINT32 timeout);
UINT32 zOss_SetEvent(ZOSS_EVENT_ID eventId, UINT32 events, UINT32 setOptions);
UINT32 zOss_DeleteEvent(ZOSS_EVENT_ID eventId);
UINT32 zOss_QueryEvent(ZOSS_EVENT_ID eventId);
BOOL   zOss_WaitingEvent(ZOSS_EVENT_ID eventId);

/* λ */ 
BOOL zOss_RingIsEmpty(T_ZOss_RingId ring_id); 
BOOL zOss_RingIsFull(T_ZOss_RingId ring_id);
T_ZOss_RingId zOss_RingCreate(SINT32 nbytes); 
SINT32 zOss_RingBufGet(T_ZOss_RingId ring_id, CHAR *buffer, SINT32 maxbytes); 
SINT32 zOss_RingBufPut(T_ZOss_RingId ring_id, CHAR *buffer, SINT32 nbytes);
SINT32 zOss_RingFreeBytes(T_ZOss_RingId ring_id);
SINT32 zOss_RingNBytes(T_ZOss_RingId ring_id);
VOID zOss_RingDelete(T_ZOss_RingId ring_id);
VOID zOss_RingFlush(T_ZOss_RingId ring_id);
VOID zOss_RingMoveAhead(T_ZOss_RingId ring_id, SINT32 n);
VOID zOss_RingPutAhead(T_ZOss_RingId ring_id, CHAR byte, SINT32 offset);

/* Ϣ */
ZOSS_QUEUE_ID zOss_QueueCreate(const CHAR *queue_name, UINT32 maxMsgs, UINT32 maxMsgLen);
UINT32 zOss_QueueSend(ZOSS_QUEUE_ID queue_id, VOID *msg_ptr, UINT32 size, UINT32 timeout, UINT32 priority);
UINT32 zOss_QueueRecv(ZOSS_QUEUE_ID queue_id, VOID *buffer, UINT32 maxsize, UINT32 timeout);
UINT32 zOss_QueueFreeCount(ZOSS_QUEUE_ID queue_id);
UINT32 zOss_QueueDelete(ZOSS_QUEUE_ID queue_id);

/* ܵ */
UINT32 zOss_PipeDevCreate(const CHAR *name, SINT32 nBytes);
UINT32 zOss_PipeDevDelete(const CHAR *name, BOOL force);

/* Cahceӿ */
VOID zOss_CacheCleanRange(UINT32 base, UINT32 size);
VOID zOss_CacheInvalidateRange(UINT32 base, UINT32 size);
VOID zOss_CacheCleanRangeFast(UINT32 base, UINT32 size);
VOID zOss_CacheInvalidateRangeFast(UINT32 base, UINT32 size);
VOID zOss_IoRemapPages(VOID *base, UINT32 size);

/* svûȡӿ */
UINT8 zOss_GetSvConfig(VOID);
VOID zOss_SetSvConfig(UINT8 sv);

/* ʱģ */
#ifdef _USE_PSM
VOID zOss_SetTimer_PsmFlag(ZOSS_TIMER_ID time_id, BOOL Flag);
UINT32 zOss_GetPs_SleepTimer(VOID);
#endif

#endif //#ifndef DOXYGEN_SHOULD_SKIP_THIS

/**
 * @brief ÷ʱ
 * @param time_len  Σʱλms
 * @param msg_id    Σʱ,͸öʱϢid
 * @param arg       ΣӲ,ݸںbufβδʱmsg_lenֵΪ4(sizeof(UINT32/arg))
 * @return ɹ:ӦĶʱʶ; ʧ:ZOSS_INVALID_TIMER_ID
 * @retval ZOSS_TIMER_ID͵ıʶ    ɹ
 * @retval ZOSS_INVALID_TIMER_ID      ʧ
 * @note  ʱΪο,ָʱ, öʱָϢԶͷŶʱռԴ
 * @warning  ڵ
 */
ZOSS_TIMER_ID zOss_SetRelativeTimer(UINT32 time_len, UINT32 msg_id, UINT32 arg);

/**
 * @brief ÷ʱĿϢ
 * @param time_len       Σʱλms
 * @param msg_id         Σʱ,͸öʱϢid
 * @param arg            ΣӲ,ݸںbufβδʱmsg_lenֵΪ4(sizeof(UINT32/arg))
 * @param desk_task_id   ΣָĿĿΪʱöʱ
 * @return ɹ:ӦĶʱʶ; ʧ:ZOSS_INVALID_TIMER_ID
 * @retval ZOSS_TIMER_ID͵ıʶ    ɹ
 * @retval ZOSS_INVALID_TIMER_ID      ʧ
 * @note 
 * @warning 
 */
ZOSS_TIMER_ID zOss_SetRelativeTimerByTaskId(UINT32 time_len, UINT32 msg_id, UINT32 arg, ZOSS_TASK_ID desk_task_id);

/**
 * @brief ʱ
 * @param time_len  Σʱλms
 * @param msg_id    Σʱ,͸öʱϢid
 * @param arg       ΣӲ,ݸںbufβδʱmsg_lenֵΪ4(sizeof(UINT32/arg))
 * @return ɹ:ӦĶʱʶ; ʧ:ZOSS_INVALID_TIMER_ID
 * @retval ZOSS_TIMER_ID͵ıʶ    ɹ
 * @retval ZOSS_INVALID_TIMER_ID      ʧ
 * @note  ʱΪο,ָʱ, öʱָϢԶͷŶʱռԴ
 * @warning ڵ
 */
ZOSS_TIMER_ID zOss_SetLoopTimer(UINT32 time_len, UINT32 msg_id, UINT32 arg);

/**
 * @brief ʱĿϢ
 * @param time_len       Σʱλms
 * @param msg_id         Σʱ,͸öʱϢid
 * @param arg            ΣӲ,ݸںbufβδʱmsg_lenֵΪ4(sizeof(UINT32/arg))
 * @param desk_task_id   ΣָĿĿΪʱöʱ
 * @return ɹ:ӦĶʱʶ; ʧ:ZOSS_INVALID_TIMER_ID
 * @retval ZOSS_TIMER_ID͵ıʶ    ɹ
 * @retval ZOSS_INVALID_TIMER_ID      ʧ
 * @note  
 * @warning 
 */
ZOSS_TIMER_ID zOss_SetLoopTimerByTaskId(UINT32 time_len, UINT32 msg_id, UINT32 arg, ZOSS_TASK_ID desk_task_id);

/**
 * @brief ʱ
 * @param tm_name        Σʱ
 * @param tm_callback    ΣʱҪõĻص
 * @param tm_param       Σص
 * @param bPeriod        ΣTRUEԶʱFALSEԶʱ
 * @return ɹ:ӦĶʱʶ; ʧ:ZOSS_INVALID_TIMER_ID
 * @retval ZOSS_TIMER_ID͵ıʶ    ɹ
 * @retval ZOSS_INVALID_TIMER_ID      ʧ
 * @note  ֮ԵzOss_StartTimer()ʱ
 * @warning 
 */
ZOSS_TIMER_ID zOss_CreateTimer(const CHAR *tm_name, ZOSS_TIMER_FUN tm_callback, SINT32 tm_param, BOOL bPeriod);

/**
 * @brief ʱ,ʱΪο,ָʱ,ûص
 * @param timer_id        Σʱid
 * @param time_len        Σʱʱλms
 * @param tm_callback     ΣʱҪõĻص
 * @param tm_param        Σص
 * @return ɹ:ZOSS_SUCCESS;ʧZOSS_ERROR
 * @retval ZOSS_SUCCESS    ɹ
 * @retval ZOSS_ERROR      ʧ
 * @note
 * @warning  صִʱڶʱʱ,ܻɴʱȷ
 */
UINT32 zOss_StartTimer(ZOSS_TIMER_ID timer_id, UINT32 time_len, ZOSS_TIMER_FUN tm_callback, SINT32 tm_param);

/**
 * @brief ֹͣʱʱ
 * @param timer_id        Σʱid
 * @return ɹ:ZOSS_SUCCESS;ʧZOSS_ERROR
 * @retval ZOSS_SUCCESS    ɹ
 * @retval ZOSS_ERROR      ʧ
 * @note 
 * @warning 
 */
UINT32 zOss_StopTimer(ZOSS_TIMER_ID timer_id);

/**
 * @brief ָͣʱļʱ
 * @param timer_id        Σʱid
 * @return ɹ:ZOSS_SUCCESS;ʧZOSS_ERROR
 * @retval ZOSS_SUCCESS    ɹ
 * @retval ZOSS_ERROR      ʧ
 * @note  ͣͬʱ¼ʣʱ䣬zOss_ResumeTime()ʱ
                ʱڱ,ִ굱ǰȺͣʱ
 * @warning 
 */
UINT32 zOss_PauseTimer(ZOSS_TIMER_ID timer_id);

/**
 * @brief ʹͣĶʱʱ
 * @param timer_id        Σʱid
 * @return ɹ:ZOSS_SUCCESS;ʧZOSS_ERROR
 * @retval ZOSS_SUCCESS    ɹ
 * @retval ZOSS_ERROR      ʧ
 * @note  
 * @warning 
 */
UINT32 zOss_ResumeTimer(ZOSS_TIMER_ID timer_id);

/**
 * @brief ɾָĶʱ
 * @param timer_id        Σʱid
 * @return ɹ:ZOSS_SUCCESS;ʧZOSS_ERROR
 * @retval ZOSS_SUCCESS    ɹ
 * @retval ZOSS_ERROR      ʧ
 * @note  
 * @warning 
 */
UINT32 zOss_KillTimer(ZOSS_TIMER_ID timer_id);

/*******************************************************************************
 *                      Inline function implementations                        *
 ******************************************************************************/
#ifndef DOXYGEN_SHOULD_SKIP_THIS
/* ˫ */
#if defined (_OS_TOS) || defined (_OS_LINUX)
/**************************************************************************
* :  zOss_ListInit
* :  ʼ˫
* ˵
             (IN)
                pList:ָ
             (OUT)
*   ֵ:
**************************************************************************/
static inline VOID zOss_ListInit(T_ZOss_List *pList)
{
    zOss_AssertExN(pList != NULL);

    pList->HEAD  = NULL;
    pList->TAIL  = NULL;
    pList->count = 0;
}

/**************************************************************************
* :  zOss_ListCount
* :  ȡܹĽڵ
* ˵
             (IN)
                pList:ָ
             (OUT)
*   ֵ:  ڵ
**************************************************************************/
static inline SINT32 zOss_ListCount(T_ZOss_List *pList)
{
    return (pList->count);
}

/**************************************************************************
* : zOss_ListDelete
* : ƳָĽڵ
* ˵
            (IN)
                pList:ָ
                pNode:ɾڵָ
            (OUT)
*   ֵ:
**************************************************************************/
static inline VOID zOss_ListDelete(T_ZOss_List *pList, T_ZOss_Node *pNode)
{
    if (pNode->previous != NULL)
    {
        pNode->previous->next = pNode->next;
    }
    else
    {
        pList->HEAD = pNode->next;
    }

    if (pNode->next != NULL)
    {
        pNode->next->previous = pNode->previous;
    }
    else
    {
        pList->TAIL = pNode->previous;
    }

    /* update node count */
    pList->count--;
}

/**************************************************************************
* : zOss_ListFirst
* : ȡ׽ڵ
* ˵
            (IN)
                pList:ָ
            (OUT)
*   ֵ: ڵָ(ûнڵʱؿ)
**************************************************************************/
static inline T_ZOss_Node* zOss_ListFirst(T_ZOss_List *pList)
{
    return (pList->HEAD);
}

/**************************************************************************
* : zOss_ListInsert
* : ָĽڵڵ
* ˵
            (IN)
                pList:ָ
                pPrev:ڵָ룬pPrevΪʱʾ뵽λ
                pNode:Ľڵָ
            (OUT)
*   ֵ:
**************************************************************************/
static inline VOID zOss_ListInsert (T_ZOss_List *pList, T_ZOss_Node *pPrev, T_ZOss_Node *pNode)
{
    T_ZOss_Node *pNext = NULL;

    if (pPrev != NULL)
    {
        pNext = pPrev->next;    /* make prev node point fwd to new */
        pPrev->next = pNode;
    }
    else
    {
     	pNext = pList->HEAD;    /* new node is to be first in list */
    	pList->HEAD = pNode;
    }

    if (pNext != NULL)
    {    	
       pNext->previous = pNode; /* make next node point back to new */
    }
    else
    {
        pList->TAIL = pNode;    /* new node is to be last in list */
    }

    /* set pointers in new node, and update node count */
    pNode->next     = pNext;
    pNode->previous = pPrev;

    pList->count++;
}

/**************************************************************************
* : zOss_ListAdd
* : βӽڵ
* ˵
            (IN)
                pList:ָ
                pNode:ӽڵָ
            (OUT)
*   ֵ:
**************************************************************************/
static inline VOID zOss_ListAdd (T_ZOss_List *pList, T_ZOss_Node *pNode)
{
    zOss_ListInsert(pList, pList->TAIL, pNode);
}

/**************************************************************************
* : zOss_ListLast
* : ȡָڵĺһڵ
* ˵
            (IN)
                pNode:ָڵָ
            (OUT)
*   ֵ: ڵָ(ûнڵʱؿ)
**************************************************************************/
static inline T_ZOss_Node* zOss_ListLast(T_ZOss_List *pList)
{
    return (pList->TAIL);
}

/**************************************************************************
* : zOss_ListNext
* : ȡָڵǰһڵ
* ˵
            (IN)
                pNode:ڵָ
            (OUT)
*   ֵ: ڵָ(ڵһڵʱؿ)
**************************************************************************/
static inline T_ZOss_Node* zOss_ListNext(T_ZOss_Node *pNode)
{
    return (pNode->next);
}

/**************************************************************************
* : zOss_ListPrevious
* : ȡָڵǰһڵ
* ˵
            (IN)
                pNode:ָڵָ
            (OUT)
*   ֵ: ڵָ(ڵһڵʱؿ)
**************************************************************************/
static inline T_ZOss_Node *zOss_ListPrevious(T_ZOss_Node *pNode)
{
    return (pNode->previous);
}

/**************************************************************************
* : zOss_ListNStep
* : ȡָڵnStepĽڵ
* ˵
            (IN)
                pNode:ڵָ
                nStep:. :nextڵ㣬previousڵ
            (OUT)
*   ֵ: ڵָ(ڼnStepڵβʱؿ)
**************************************************************************/
static inline T_ZOss_Node *zOss_ListNStep(T_ZOss_Node *pNode, SINT32 nStep)
{
    int i       = 0;
    
    if (nStep > 0)
    {
        for (i = nStep; i > 0; i--)
        {
            pNode = pNode->next;
            
            if (pNode == NULL)
            {
                break;
            }
        }
    }
    else
    {
        for (i = nStep; i < 0; i++)
        {
            pNode = pNode->previous;
            
            if (pNode == NULL)
            {
                break;
            }
        }
    }
    return (pNode);
}

/**************************************************************************
* : zOss_ListFind
* : еĽڵ
* ˵
            (IN)
                pList:ָ
                pNode:ҽڵָ
            (OUT)
*   ֵ: ָڵ:ڵе(1ʼ)
                        ָڵ:-1
**************************************************************************/
static inline SINT32 zOss_ListFind (T_ZOss_List *pList, T_ZOss_Node *pNode)
{
    T_ZOss_Node *pNextNode      = NULL;
    int         iNodePosition   = 1;

    pNextNode = zOss_ListFirst (pList);

    while ((pNextNode != NULL) && (pNextNode != pNode))
    {
        iNodePosition++;
        
        pNextNode = zOss_ListNext (pNextNode);
    }

    if (pNextNode != NULL)
    {
        return (iNodePosition);
    }
    else
    {
        return (-1);
    }
}

/**************************************************************************
* : zOss_ListConnect
* : һ
* ˵
            (IN)
                pList1: 1
                pList2: 2
            (OUT)
* ֵ:
* ˵    pList2ӵpList1βpList2ͷݲı
**************************************************************************/
static inline VOID zOss_ListConnect(T_ZOss_List *pList1, T_ZOss_List *pList2)
{
    if (pList1->count == 0)
    {
        pList1->HEAD    = pList2->HEAD;
        pList1->TAIL    = pList2->TAIL;
    }
    else
    {
        if (pList2->count != 0)
        {
            pList1->TAIL ->next     = pList2->HEAD;
            pList2->HEAD->previous  = pList1->TAIL;
            pList1->TAIL            = pList2->TAIL;
        }
    }
    pList1->count += pList2->count;
}
#else
VOID zOss_ListInit(T_ZOss_List *pList);
T_ZOss_Node *zOss_ListFirst(T_ZOss_List *pList);
T_ZOss_Node *zOss_ListLast(T_ZOss_List *pList);
T_ZOss_Node *zOss_ListNext(T_ZOss_Node *pNode);
T_ZOss_Node *zOss_ListPrevious(T_ZOss_Node *pNode);
T_ZOss_Node *zOss_ListNStep(T_ZOss_Node *pNode, SINT32 nStep); 
SINT32 zOss_ListCount(T_ZOss_List *pList); 
SINT32 zOss_ListFind(T_ZOss_List *pList, T_ZOss_Node *pNode);
VOID zOss_ListAdd(T_ZOss_List *pList, T_ZOss_Node *pNode);
VOID zOss_ListDelete(T_ZOss_List *pList, T_ZOss_Node *pNode);
VOID zOss_ListInsert(T_ZOss_List *pList, T_ZOss_Node *pPrev, T_ZOss_Node *pNode);
VOID zOss_ListConnect(T_ZOss_List *pList1, T_ZOss_List *pList2);
#endif

#endif //#ifndef DOXYGEN_SHOULD_SKIP_THIS


#ifdef __cplusplus
}
#endif

#endif  // #ifndef _OSS_SUP_H
